/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.receiver.fsm.RMReceiveSequence;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class RMInboundEndEvt
extends LogEvent {
    private EndpointReference m_endpoint;
    private String m_endpointS;
    private String m_sequenceIdentifier;
    private short m_type = (short)129;

    public RMInboundEndEvt(RMReceiveSequence rrs) {
        this.m_sequenceIdentifier = rrs.getSequenceState().getSequenceIdentifier().getIdentifier().toString();
        this.m_endpoint = rrs.getSequenceState().getEndpointReference();
        if (this.m_endpoint != null) {
            this.m_endpointS = this.stringify(this.m_endpoint);
        }
    }

    RMInboundEndEvt(short type) {
        this.m_type = type;
    }

    @Override
    public short type() {
        return 129;
    }

    public EndpointReference getEndpointReference() {
        return this.m_endpoint;
    }

    public String getSequenceIdentifier() {
        return this.m_sequenceIdentifier;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        RMManager.getRMManager().redoEnd(this);
    }

    @Override
    protected int memSizeBody() {
        int size = this.memSize(this.m_endpointS) + this.memSize(this.m_sequenceIdentifier);
        return size;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        this.writeNullOrUTF(this.m_endpointS, os);
        this.writeNullOrUTF(this.m_sequenceIdentifier, os);
    }

    private int memSize(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    private void writeNullOrUTF(String s, OutputStream os) throws IOException {
        byte[] b = StringUtil.stringToUTF("");
        if (s == null) {
            os.write(b, 0, b.length);
        } else {
            b = StringUtil.stringToUTF(s);
            os.write(b, 0, b.length);
        }
    }

    private int serializedSizeNullOrUTF(String s) {
        if (s == null) {
            return 4;
        }
        try {
            byte[] b = StringUtil.stringToUTF(s);
            return b.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String readNullOrUTF(InputStream is) throws IOException {
        String s = StreamUtil.readUTF(is);
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_endpointS = this.readNullOrUTF(in);
        if (this.m_endpointS != null) {
            this.m_endpoint = this.parse(this.m_endpointS);
            if (this.m_type == 120) {
                this.m_endpointS = this.stringify(this.m_endpoint);
            }
        }
        this.m_sequenceIdentifier = this.readNullOrUTF(in);
    }

    @Override
    public String toString() {
        return "RMInboundEndEvt: " + this.getSequenceIdentifier() + " dest: " + this.getEndpointReference().getAddress();
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        int size = this.serializedSizeNullOrUTF(this.m_endpointS) + this.serializedSizeNullOrUTF(this.m_sequenceIdentifier);
        return size;
    }

    private String stringify(EndpointReference epr) {
        Element e = epr.toDOM(null);
        return XMLUtils.ElementToString((Element)e);
    }

    private EndpointReference parse(String s) throws IOException {
        if (s == null) {
            return null;
        }
        try {
            if (this.m_type == 120) {
                return new EndpointReference(new Address(s));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
            Element el = XMLUtils.newDocument((InputStream)bais).getDocumentElement();
            return new EndpointReference(el);
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

