/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import progress.message.broker.MgramURLHelper;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.DraDestUtil;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ISubject;

public class RoutingSubjectResolver
extends DebugObject {
    private final IMgram m_mgram;
    private final String m_remoteNode;
    private final ISubject m_subject;
    private String m_overrideRNN = null;
    private int m_aclCheckMode = 0;
    private String m_aclSubjectForDisplay = null;
    public static final int USE_OVERRIDE_PROPERTY = 1;
    public static final int USE_CONFIGURED_NODE_URL = 2;
    public static final int USE_NORMAL_SUBJECT = 0;

    public RoutingSubjectResolver(IMgram m, ISubject subject, String remoteNode) {
        super(DebugState.GLOBAL_DEBUG_ON ? "RoutingSubjectResolver" : null);
        this.m_mgram = m;
        this.m_remoteNode = remoteNode;
        this.m_subject = subject;
    }

    public ISubject resolve() throws ConflictingHttpOverrides {
        String nodeURL;
        ISubject lookupSubject;
        if (this.DEBUG) {
            this.debug(" Entering getACLSubject() for subject: " + this.m_subject.getJMSName() + " rnn : " + this.m_remoteNode);
        }
        if (this.m_remoteNode == null || this.m_remoteNode.equals("")) {
            if (this.DEBUG) {
                this.debug(" getACLSubject returning local subject: " + this.m_subject);
            }
            return this.m_subject;
        }
        if (!MgramURLHelper.isValidRemoteHttpNode(this.m_remoteNode)) {
            ISubject lookupSubject2 = DraDestUtil.getRemoteSubject(this.m_subject, this.m_remoteNode);
            if (this.DEBUG) {
                this.debug(" getACLSubject returning sonic dra subject: " + lookupSubject2);
            }
            return lookupSubject2;
        }
        if (DraDestUtil.isSubjectURL(this.m_subject)) {
            ISubject lookupSubject3 = DraDestUtil.getRemoteSubject(this.m_subject, this.m_remoteNode);
            if (this.DEBUG) {
                this.debug(" getACLSubject returning http url subject: " + lookupSubject3);
            }
            return lookupSubject3;
        }
        String httpOverrideDestination = this.getHttpOverrideDestination();
        if (httpOverrideDestination != null) {
            if (this.DEBUG) {
                this.debug(" getACLSubject get override subject: " + httpOverrideDestination);
            }
            String effectiveRNN = MgramURLHelper.getEffectiveRNN(this.m_remoteNode, httpOverrideDestination);
            if (this.DEBUG) {
                this.debug(" getACLSubject get effectiveRNN: " + effectiveRNN);
            }
            if ((lookupSubject = RoutingSubjectResolver.getHttpOverrideSubject(httpOverrideDestination, effectiveRNN)) != null) {
                this.m_aclCheckMode = 1;
                if (!effectiveRNN.equals(this.m_remoteNode)) {
                    this.m_overrideRNN = effectiveRNN;
                }
                if (this.DEBUG) {
                    this.debug(" getACLSubject USE_OVERRIDE_PROPERTY subject: " + lookupSubject);
                }
                this.m_aclSubjectForDisplay = effectiveRNN + "::" + httpOverrideDestination;
                return lookupSubject;
            }
        }
        if ((nodeURL = MgramURLHelper.getHttpNodeURL(this.m_remoteNode)) != null) {
            if (this.DEBUG) {
                this.debug(" getACLSubject get node URL: " + nodeURL);
            }
            if ((lookupSubject = RoutingSubjectResolver.getHttpOverrideSubject(nodeURL, this.m_remoteNode)) != null) {
                this.m_aclCheckMode = 2;
                if (this.DEBUG) {
                    this.debug(" getACLSubject USE_CONFIGURED_NODE_URL subject: " + lookupSubject);
                }
                this.m_aclSubjectForDisplay = this.m_remoteNode + "::" + nodeURL;
                return lookupSubject;
            }
        }
        lookupSubject = DraDestUtil.getRemoteSubject(this.m_subject, this.m_remoteNode);
        if (this.DEBUG) {
            this.debug(" getACLSubject finally return default subject: " + lookupSubject);
        }
        return lookupSubject;
    }

    int getACLCheckingMode() {
        return this.m_aclCheckMode;
    }

    String getOverrideRNN() {
        return this.m_overrideRNN;
    }

    String getACLSubjectForDisplay() {
        return this.m_aclSubjectForDisplay;
    }

    short getNotAuthorizedErrorCode() {
        if (this.m_aclCheckMode == 1) {
            return -29;
        }
        if (this.m_aclCheckMode == 2) {
            return -30;
        }
        return -6;
    }

    private String getHttpOverrideDestination() throws ConflictingHttpOverrides {
        if (!MgramURLHelper.isValidRemoteHttpNode(this.m_remoteNode)) {
            return null;
        }
        if (this.m_mgram.getType() == 27) {
            Iterator it = this.m_mgram.getBatchHandle().getBatchIterator();
            HashSet<String> overrides = new HashSet<String>();
            while (it.hasNext()) {
                overrides.add(MgramURLHelper.getHttpOverrideDestination((IMgram)it.next()));
            }
            if (overrides.size() > 1) {
                throw new ConflictingHttpOverrides(overrides);
            }
            return overrides.size() == 0 ? null : (String)overrides.iterator().next();
        }
        return MgramURLHelper.getHttpOverrideDestination(this.m_mgram);
    }

    private static ISubject getHttpOverrideSubject(String nodeURL, String remoteNode) {
        ISubject subject = null;
        try {
            subject = MgramURLHelper.getHttpOverrideSubject(nodeURL, remoteNode);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return subject;
    }

    public static class ConflictingHttpOverrides
    extends ResolverError {
        private static final long serialVersionUID = 1L;
        private final String[] overrides;

        public ConflictingHttpOverrides(Set<String> overrides) {
            super("Batch contains conflicting values for the X-HTTP-DestinationURL JMS property");
            this.overrides = overrides.toArray(new String[overrides.size()]);
        }

        public String[] getOverrides() {
            return this.overrides;
        }
    }

    public static abstract class ResolverError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ResolverError(String message) {
            super(message);
        }

        public ResolverError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

