/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.client.EGeneralException;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class SetRouting
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    SetRouting(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "SetRouting" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block10: {
            if (this.DEBUG) {
                this.debug("Entered SetRouting");
            }
            try {
                Message msg = env.getMessage();
                Message rep = new Message();
                try {
                    boolean newRouting;
                    RoutingConnectionInfo r = new RoutingConnectionInfo();
                    r.unserialize(msg);
                    boolean setPassword = msg.readBoolean();
                    RoutingConnectionInfo old_r = this.m_reg.getRoutingConfig().getRoutingConnection(r.getRoutingNodeName());
                    boolean bl = newRouting = old_r == null;
                    if (newRouting) {
                        this.m_reg.getRoutingConfig().setRoutingConnection(r);
                    } else {
                        old_r.setConnectionURLs(r.getConnectionURLs());
                        old_r.setUserName(r.getUserName());
                        old_r.setLoadBalance(r.isLoadBalance());
                        old_r.setSequentialLoadBalancing(r.isSequentialLoadBalancing());
                        old_r.setTimeout(r.getTimeout());
                        old_r.setForwardRoutings(r.isForwardRoutings());
                        old_r.setStaticRouting(r.isStaticRouting());
                        old_r.setOutboundBrokerName(r.getOutboundBrokerName());
                        old_r.setRoutingAcceptor(r.getRoutingAcceptor());
                        if (setPassword) {
                            old_r.setPassword(r.getPassword());
                        }
                        this.m_reg.getRoutingConfig().setRoutingConnection(old_r);
                    }
                    rep.writeBoolean(true);
                }
                catch (Exception e) {
                    rep = new Message();
                    rep.writeBoolean(false);
                    rep.writeObject(e);
                }
                s.reply(rep, env);
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block10;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

