/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import progress.message.broker.ILogRandomAccessFile;

public final class WrappedRandomAccessFile
extends RandomAccessFile
implements ILogRandomAccessFile {
    public WrappedRandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
    }

    public WrappedRandomAccessFile(String name, String mode) throws IOException {
        super(name, mode);
    }

    @Override
    public void sync() throws IOException {
        FileDescriptor fd = this.getFD();
        fd.sync();
    }

    @Override
    public int readRAF(byte[] b) throws IOException {
        long pos = this.getFilePointer();
        try {
            this.readFully(b);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return (int)(this.getFilePointer() - pos);
    }

    @Override
    public int readRAF(byte[] b, int off, int len) throws IOException {
        long pos = this.getFilePointer();
        try {
            super.readFully(b, off, len);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return (int)(this.getFilePointer() - pos);
    }
}

