/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq.pse;

import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.util.IndexIterator;
import com.odi.util.OSHashtable;
import com.odi.util.OSTreeSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import progress.message.broker.Config;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.db.pse.util.OpContext;
import progress.message.dbq.IRoutingDBQ;
import progress.message.dbq.pse.DBQPSEBase;
import progress.message.dbsc.pse.pc.gr.PSERemoteBroker;
import progress.message.dbsc.pse.pc.gr.PSERouteHolder;
import progress.message.dbsc.pse.pc.gr.PSERouteInfo;
import progress.message.gr.RouteInfo;

public class RoutingDBQImplPSE
extends DBQPSEBase
implements IRoutingDBQ {
    private PSEBrokerDb m_pseDb;
    private OSTreeSet m_rootRBRegistry;
    private OSHashtable m_rootRouteHolders;
    private int added;
    private int deleted;
    private int replaced;
    private int calls;
    private int numRoutes;

    public RoutingDBQImplPSE(PSEBrokerDb db) {
        super("RoutingDBQImplPSE ");
        this.m_pseDb = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws EDatabaseException {
        if (this.m_dbCtx == null) {
            this.m_dbCtx = this.m_pseDb.getCtx(2);
        }
        this.m_opCtxUpdate = new OpContext(2, this.m_dbCtx);
        this.m_opCtxRead = new OpContext(1, 2, this.m_dbCtx);
        this.acquireLock(this.m_opCtxRead);
        try {
            int ct;
            boolean DEBUG1 = this.isDebugLevel1();
            if (DEBUG1) {
                ct = this.getRootRBRegistry().size();
                this.debug("count of RBRegistry= " + ct);
            }
            if (DEBUG1 || this.getDebug()) {
                ct = this.getRootRouteHolders().size();
                IndexIterator it = this.getRootRouteHolders().elements();
                int routeCt = 0;
                while (it.hasNext()) {
                    PSERouteHolder rh = (PSERouteHolder)it.next();
                    routeCt += rh.getCountRoutes();
                }
                this.debug("count of RouteHolders= " + ct + " countRoutes= " + routeCt);
                long dbSize = this.m_dbCtx.getDatabase().getSizeInBytes();
                this.debug("Routing db size= " + dbSize);
                this.numRoutes = routeCt;
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
    }

    @Override
    public Vector getRoutes() throws EDatabaseException {
        this.acquireLock(this.m_opCtxRead);
        try {
            Vector vector = this.getRoutesInternal();
            return vector;
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
    }

    @Override
    public Vector getRoutesTx() throws EDatabaseException {
        this.checkUpdateLock();
        return this.getRoutesInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRoutesInternal() throws EDatabaseException {
        Vector<RouteInfo> routes = new Vector<RouteInfo>(1000);
        boolean DEBUG1 = this.isDebugLevel1();
        if (DEBUG1) {
            this.debug("entering getRoutes");
        }
        try {
            RoutingConnectionInfo routing = null;
            RouteInfo route = null;
            IndexIterator it = this.getRootRouteHolders().elements();
            while (it.hasNext()) {
                PSERouteHolder rh = (PSERouteHolder)it.next();
                Iterator routeIterator = rh.getRoutes();
                while (routeIterator.hasNext()) {
                    String urls;
                    PSERouteInfo ri = (PSERouteInfo)routeIterator.next();
                    route = new RouteInfo();
                    route.setNodeName(rh.getRoutingNodeName());
                    route.setGlobalName(rh.getGlobalName());
                    String brokerName = ri.getBrokerName();
                    if (brokerName == null) {
                        brokerName = "";
                    }
                    route.setBrokerName(brokerName);
                    if (this.getDebug()) {
                        this.debug("getRoutes node= " + route.getNodeName() + " globalName= " + route.getGlobalName() + " brokername= " + route.getBrokerName());
                    }
                    if ((urls = ri.getConnectionURLs()) != null) {
                        routing = new RoutingConnectionInfo(route.getNodeName());
                        routing.setConnectionURLs(urls);
                        routing.setUserName(ri.getUserName());
                        routing.setPassword(ri.getUserPassword());
                        routing.setLoadBalance(ri.getLoadBalance());
                        routing.setSequentialLoadBalancing(ri.getSequential());
                        routing.setTimeout(ri.getTimeout());
                        routing.setForwardRoutings(ri.getForwardRoutings());
                        routing.setStaticRouting(ri.getStaticRouting());
                        brokerName = ri.getConnectionBrokerName();
                        if (brokerName == null) {
                            brokerName = "";
                        }
                        routing.setOutboundBrokerName(brokerName);
                        route.setConnectionInfo(routing);
                    }
                    route.setTimestamp(ri.getCreateTime());
                    route.setHops(ri.getNetworkHops());
                    brokerName = ri.getSendingBrokerName();
                    if (brokerName == null) {
                        brokerName = "";
                    }
                    route.setSendingBrokerName(brokerName);
                    routes.addElement(route);
                }
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            if (DEBUG1) {
                this.debug("leaving getRoutes; number of routes= " + routes.size() + " numRoutes counter=  " + this.numRoutes);
            }
        }
        return routes;
    }

    @Override
    public void addRouteTx(RouteInfo route) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        String nodename = route.getNodeName();
        String globalname = route.getGlobalName();
        String brokername = route.getBrokerName();
        if (DEBUG) {
            this.debug("addRouteTx starting node= " + nodename + " globalName= " + globalname + " brokername= " + brokername);
        }
        RoutingConnectionInfo routing = route.getConnectionInfo();
        this.checkUpdateLock();
        try {
            OSHashtable ht = this.getRootRouteHolders();
            PSERouteHolder rh = (PSERouteHolder)ht.get((Object)(nodename + globalname));
            if (rh == null) {
                rh = new PSERouteHolder(nodename, globalname);
                ht.put((Object)(nodename + globalname), (Object)rh);
            }
            PSERouteInfo ri = new PSERouteInfo(brokername);
            ri.setCreateTime(route.getTimestamp());
            ri.setNetworkHops(route.getHops());
            ri.setSendingBrokerName(route.getSendingBrokerName());
            if (routing != null) {
                ri.setConnectionURLs(routing.getConnectionURLs());
                ri.setUserName(routing.getUserName());
                ri.setUserPassword(routing.getPasswordBytes());
                ri.setLoadBalance(routing.isLoadBalance());
                ri.setSequential(routing.isSequentialLoadBalancing());
                ri.setTimeout(routing.getTimeout());
                ri.setForwardRoutings(routing.isForwardRoutings());
                ri.setStaticRouting(routing.isStaticRouting());
                ri.setConnectionBrokerName(routing.getOutboundBrokerName());
            }
            int beforeAdd = rh.getCountRoutes();
            rh.addRoute(ri);
            int afterAdd = rh.getCountRoutes();
            int diff = afterAdd - beforeAdd;
            if (diff == 0) {
                ++this.replaced;
            } else {
                if (DEBUG && Config.BROKER_NAME.equals(brokername)) {
                    this.debug("*****addRouteTx: saving route for THIS broker= " + brokername + " globalName= " + globalname + " node= " + nodename + " sendingBrokerName= " + route.getSendingBrokerName());
                    this.debug(ri.toStringAll());
                }
                ++this.added;
                ++this.numRoutes;
            }
            this.checkDebug();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        if (DEBUG) {
            this.debug("addRouteTx added: node= " + nodename + " globalName= " + globalname + " brokername= " + brokername);
        }
    }

    @Override
    public void deleteRoutesByNodeGlobalTx(String nodeName, String globalName) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering deleteRoutesByNodeGlobal: nodeName= " + nodeName + " globalName= " + globalName);
        }
        this.checkUpdateLock();
        int ct = 0;
        try {
            String key = nodeName + globalName;
            OSHashtable ht = this.getRootRouteHolders();
            PSERouteHolder rh = (PSERouteHolder)ht.get((Object)key);
            if (rh != null) {
                ct = rh.getCountRoutes();
                this.retrieveKeyAndDestroy(ht, key, rh);
                this.configDeletedAndNumRoutes(ct);
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        if (DEBUG) {
            this.debug("completed deleteRoutesByNodeGlobal: nodeName= " + nodeName + " globalName= " + globalName + " numRoutesDeleted= " + ct + " numRoutes= " + this.numRoutes);
        }
    }

    @Override
    public void deleteRoutesByNodeGlobalBrokerTx(String nodeName, String globalName, String brokerName) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering deleteRoutesByNodeGlobalBroker: nodeName= " + nodeName + " globalName= " + globalName + " brokerName= " + brokerName);
        }
        this.checkUpdateLock();
        int ct = 0;
        try {
            String key = nodeName + globalName;
            OSHashtable ht = this.getRootRouteHolders();
            PSERouteHolder rh = (PSERouteHolder)ht.get((Object)key);
            if (rh != null) {
                ct = rh.removeRoute(brokerName);
                if (rh.getCountRoutes() == 0) {
                    this.retrieveKeyAndDestroy(ht, key, rh);
                }
            }
            this.configDeletedAndNumRoutes(ct);
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        if (DEBUG) {
            this.debug("leaving deleteRoutesByNodeGlobalBroker: nodeName= " + nodeName + " globalName= " + globalName + " brokerName= " + brokerName + " numRoutesDeleted= " + ct);
        }
    }

    private void retrieveKeyAndDestroy(OSHashtable ht, String key, PSERouteHolder rh) {
        Object keyObj = ht.getKey((Object)key);
        ht.remove(keyObj);
        ObjectStore.destroy((Object)keyObj);
        ObjectStore.destroy((Object)rh);
    }

    private void configDeletedAndNumRoutes(int ct) {
        this.deleted += ct;
        this.numRoutes -= ct;
        this.checkDebug();
    }

    private OSHashtable getRootRouteHolders() {
        if (this.m_rootRouteHolders != null) {
            return this.m_rootRouteHolders;
        }
        return (OSHashtable)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("RouteInfo"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getRemoteBrokers() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        Vector<Object[]> remoteBrokers = new Vector<Object[]>(1000);
        if (DEBUG) {
            this.debug("entering getRemoteBrokers");
        }
        this.acquireLock(this.m_opCtxRead);
        try {
            Object[] nextRow = null;
            Iterator it = this.getRBRegistryIterator();
            while (it.hasNext()) {
                nextRow = new Object[7];
                PSERemoteBroker rb = (PSERemoteBroker)it.next();
                nextRow[0] = new Long(rb.getClientId());
                nextRow[1] = rb.getURL();
                nextRow[2] = rb.getFTPeerURL();
                nextRow[3] = rb.getUserName();
                byte[] passwordBytes = rb.getUserPassword();
                if (passwordBytes == null) {
                    passwordBytes = new byte[]{};
                }
                char[] passwordChars = new char[passwordBytes.length / 2];
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(passwordBytes));
                try {
                    for (int i = 0; i < passwordChars.length; ++i) {
                        passwordChars[i] = dis.readChar();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                nextRow[4] = new String(passwordChars);
                nextRow[5] = rb.getNode();
                nextRow[6] = rb.getBroker();
                remoteBrokers.addElement(nextRow);
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("leaving getRemoteBrokers; numBrokers= " + remoteBrokers.size());
        }
        return remoteBrokers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteBroker(long ClientID, String URL2, String FTPeerURL, String Node2, String Broker2, String UserName, String UserPassword) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering addRemotebroker");
        }
        this.acquireLock(this.m_opCtxUpdate);
        byte[] passwordBytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            if (DEBUG) {
                this.debug("UserPassword = " + UserPassword);
            }
            passwordBytes = this.writeAndRetrieveByteArray(dos, UserPassword, baos);
            if (DEBUG) {
                this.debug("passwordBytes.length = " + passwordBytes.length);
            }
            PSERemoteBroker rb = new PSERemoteBroker(ClientID);
            rb.setURL(URL2);
            rb.setFTPeerURL(FTPeerURL);
            rb.setUserName(UserName);
            rb.setUserPassword(passwordBytes);
            rb.setNode(Node2);
            rb.setBroker(Broker2);
            this.getRootRBRegistry().add((Object)rb);
            this.commit();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("leaving addRemoteBroker");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRemoteBroker(long ClientID, String URL2, String FTPeerURL, String Node2, String Broker2, String UserName, String UserPassword) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering updateRemotebroker");
        }
        byte[] passwordBytes = null;
        this.acquireLock(this.m_opCtxUpdate);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            passwordBytes = this.writeAndRetrieveByteArray(dos, UserPassword, baos);
            PSERemoteBroker rb = this.getRB(ClientID);
            rb.setURL(URL2);
            rb.setFTPeerURL(FTPeerURL);
            rb.setUserName(UserName);
            rb.setUserPassword(passwordBytes);
            rb.setNode(Node2);
            rb.setBroker(Broker2);
            this.commit();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (DEBUG) {
            this.debug("leaving updateRemoteBroker");
        }
    }

    private byte[] writeAndRetrieveByteArray(DataOutputStream dos, String UserPassword, ByteArrayOutputStream baos) {
        try {
            dos.writeChars(UserPassword);
            dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRemoteBroker(long ClientID) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering deleteRemotebroker");
        }
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSERemoteBroker rb = this.getRB(ClientID);
            if (rb != null) {
                this.getRootRBRegistry().remove((Object)rb);
            }
            ObjectStore.destroy((Object)rb);
            this.commit();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("leaving deleteRemoteBroker");
        }
    }

    private PSERemoteBroker getRB(long cid) {
        Long key = new Long(cid);
        return (PSERemoteBroker)this.getRootRBRegistry().getFromPrimaryIndex((Object)key);
    }

    private Iterator getRBRegistryIterator() {
        Iterator it = this.getRootRBRegistry().iterator();
        return it;
    }

    private OSTreeSet getRootRBRegistry() {
        if (this.m_rootRBRegistry != null) {
            return this.m_rootRBRegistry;
        }
        return (OSTreeSet)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("RBRegistry"));
    }

    private void checkDebug() {
        ++this.calls;
        if (this.isDebugLevel1() && this.calls % 100 == 0) {
            this.debug("calls= " + this.calls + " added= " + this.added + " replaced= " + this.replaced + " deleted= " + this.deleted + " numRoutes=  " + this.numRoutes);
            this.added = 0;
            this.replaced = 0;
            this.deleted = 0;
        }
    }
}

