/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import progress.message.db.EDatabaseException;
import progress.message.dd.NoDupDetectDbConnection;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class DupDetectionSyncReplicationMgr
extends DebugObject {
    private NoDupDetectDbConnection m_ndd;
    private String m_maxCommitId;
    private String m_currentCommitId;
    private boolean m_inDynamicSync;

    public DupDetectionSyncReplicationMgr(NoDupDetectDbConnection ndd) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DupDetectionSyncReplicationMgr" : null);
        this.m_ndd = ndd;
    }

    public String[] startDynamicSync() throws EDatabaseException {
        String[] limits = this.m_ndd.getLimits();
        if (limits != null) {
            this.m_currentCommitId = limits[0];
            this.m_maxCommitId = limits[1];
            this.m_inDynamicSync = true;
        }
        return limits;
    }

    public void setCurrentCommitId(String commitId) {
        this.m_currentCommitId = commitId;
    }

    public void completeDynamicSync() {
        this.m_inDynamicSync = false;
        this.m_currentCommitId = null;
        this.m_maxCommitId = null;
    }

    public boolean suppressSynchronization(String commitId) {
        if (this.DEBUG) {
            this.debug("Testing commitId: " + commitId);
        }
        if (this.DEBUG) {
            this.debug("Current commitId: " + this.m_currentCommitId);
        }
        if (this.DEBUG) {
            this.debug("Max commitId: " + this.m_maxCommitId);
        }
        if (this.m_inDynamicSync) {
            int currentResult = commitId.compareTo(this.m_currentCommitId);
            if (currentResult <= 0) {
                if (this.DEBUG) {
                    this.debug("Information has already been replicated, replicate");
                }
                return false;
            }
            int maxResult = commitId.compareTo(this.m_maxCommitId);
            if (maxResult <= 0) {
                if (this.DEBUG) {
                    this.debug("Information will be replicated, suppress");
                }
                return true;
            }
            if (this.DEBUG) {
                this.debug("Information is outside of dynamic sync range, replicate");
            }
            return false;
        }
        if (this.DEBUG) {
            this.debug("Not in dynamic sync, replicate");
        }
        return false;
    }
}

