/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.IOException;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentSender;
import progress.message.broker.Config;
import progress.message.client.EIntegrityCompromised;
import progress.message.ft.ConnectionManager;
import progress.message.ft.ReplicationChannel;
import progress.message.ft.ReplicationManager;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.zclient.BrokerConnectHandshaker;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.Sender;
import progress.message.zclient.SessionConfig;

final class ReplicationListener
extends AgentListener {
    private ReplicationManager m_rm;
    private ConnectionManager m_cm;
    private long m_adminClientId;
    private String m_adminClientDirectedAddr = null;
    private ReplicationChannel m_channel = null;
    private long m_id = -1L;
    private boolean m_activeConnect = false;

    ReplicationListener(AgentConnection con, ReplicationManager rm) throws IOException {
        super("ReplicationListener of", con);
        this.m_rm = rm;
        this.m_cm = rm.getConnectionMgr();
        this.m_channel = (ReplicationChannel)con;
        this.m_id = con.getSocketId();
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        this.m_adminClientId = reg.getAdminConnection().getClientId();
        this.m_adminClientDirectedAddr = SessionConfig.getDirectedSubject(reg.getAdminConnection().getEffectiveUid(), reg.getAdminConnection().getApplicationId(), reg.getCollective(), Config.BROKER_UID, "Swizzle");
    }

    @Override
    protected void setClientSessionVer(byte clientSessionVer) {
        super.setClientSessionVer(clientSessionVer);
    }

    @Override
    protected void handlePing(IMgram m) throws EUnexpectedMgram {
        this.m_channel.handlePing(m);
        super.handlePing(m);
    }

    @Override
    protected void handleAck(IMgram m) {
        this.m_cm.rcvdReplicationAck(m);
    }

    @Override
    protected void handleNormal(IMgram m) throws EIntegrityCompromised {
        if (m.isRequest() || m.isReply()) {
            try {
                super.handleNormal(m);
            }
            catch (InterruptedException e) {
                throw new EAssertFailure("queueMsg() interrupted in deliverToQueues()");
            }
        } else {
            this.m_cm.rcvdReplicationMgram(m);
        }
    }

    void setActiveConnect(boolean b) {
        this.m_activeConnect = b;
    }

    @Override
    protected void preconnectLoop(BrokerConnectHandshaker handshaker) throws IOException, EMgramFormatError, EUnexpectedMgram {
        if (this.DEBUG) {
            this.debug("entering preconnectLoop()...");
        }
        try {
            if (this.m_activeConnect) {
                AgentSender as = this.m_channel.getAgentSender();
                if (as == null) {
                    throw new IOException();
                }
                as.send(this.m_rm.getConnectionMgr().buildNewChannelRequest(0, this.m_channel.getSessionContext().getSessionId(), this.m_channel.getSocketId()));
            }
            IMgram m = this.m_converter.createMgram(this.m_is);
            switch (m.getType()) {
                case 22: {
                    this.m_channel.handleConvert(m);
                    break;
                }
                case 1: 
                case 4: {
                    if (this.DEBUG) {
                        this.debug("Peer is attempting to establish a new session.");
                    }
                }
                default: {
                    throw new EUnexpectedMgram(m);
                }
            }
        }
        catch (IOException ioe) {
            this.resetConnection();
            throw ioe;
        }
        catch (EMgramFormatError mfe) {
            this.resetConnection();
            throw mfe;
        }
        catch (EUnexpectedMgram ume) {
            this.resetConnection();
            throw ume;
        }
        if (this.DEBUG) {
            this.debug("exiting preconnectLoop()...");
        }
    }

    private void resetConnection() {
        if (this.m_id != this.m_channel.getSocketId()) {
            this.m_connection = null;
        } else {
            this.m_failedConnectAttempt = true;
        }
    }

    @Override
    protected void connectLoop(BrokerConnectHandshaker handshaker) {
        if (this.DEBUG) {
            this.debug("connectLoop(): skipping C/R handshake");
        }
    }

    @Override
    protected void setThreadName() {
        String name = this.m_threadNamePrefix;
        if (null != this.m_connection) {
            name = name + " " + (ReplicationChannel)this.m_connection;
            name = name + ", socketId=" + this.m_connection.getSocketId();
        }
        this.setThreadName(name);
    }

    @Override
    protected void connectSender() throws Exception {
    }

    @Override
    protected boolean handleUnexpectedMgramType(IMgram m, int phase) {
        if (phase == 2) {
            switch (m.getType()) {
                case 24: {
                    if (this.DEBUG) {
                        IStateEvent evt = m.getStateEventHandle().getStateEvent();
                        this.debug("Evt Received: " + evt);
                    }
                }
                case 25: 
                case 29: {
                    this.m_cm.rcvdReplicationMgram(m);
                    return true;
                }
                case 34: {
                    if (this.DEBUG) {
                        this.debug("Replication request/reply mgram received.");
                    }
                    this.m_cm.rcvdReplicationRequest(m);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    protected void fatalError(IMgram m, int channel) {
        if (this.DEBUG && channel != 0) {
            this.debug("fatalError() - message received on non-existent channel " + channel);
        }
        this.fatalError(m);
    }

    @Override
    protected void fatalError(IMgram m) {
        if (!this.m_channel.isShuttingDown() && this.m_channel.reset(this.m_id) && !this.m_rm.isShuttingDown()) {
            this.m_rm.onDisconnect(this.m_channel);
            if (ReplicationChannel.getActiveChannelCount() > 0) {
                this.m_channel.startConnectThread();
            }
        }
    }

    @Override
    protected void stopSender() {
        Sender sender = this.m_channel.getSender();
        if (sender != null && sender.isAlive()) {
            sender.interrupt();
        }
    }
}

