/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jms.JMSException;
import javax.jms.Message;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.parser.Selector;
import progress.message.jimpl.parser.SelectorTreeConstants;
import progress.message.jimpl.parser.SimpleNode;

public class LikePredicate
extends SimpleNode {
    boolean not = false;

    public LikePredicate(int id) {
        super(id);
    }

    public LikePredicate(Selector p, int id) {
        super(p, id);
    }

    @Override
    public String toString() {
        return SelectorTreeConstants.jjtNodeName[this.id] + " : " + (this.not ? "not like " : "like ");
    }

    @Override
    public Object eval(Message m) throws JMSException {
        Object identifier = ((SimpleNode)this.children[0]).eval(m);
        if (identifier == null) {
            return null;
        }
        String pattern = (String)((SimpleNode)this.children[1]).eval(m);
        Character escape = null;
        if (this.children.length > 2) {
            escape = (Character)((SimpleNode)this.children[2]).eval(m);
        }
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < pattern.length(); ++i) {
            switch (pattern.charAt(i)) {
                case '%': {
                    stringBuffer.append('.');
                    stringBuffer.append('*');
                    continue block6;
                }
                case '_': {
                    stringBuffer.append('.');
                    continue block6;
                }
                default: {
                    if (escape != null && pattern.charAt(i) == escape.charValue() && (pattern.charAt(i + 1) == '%' || pattern.charAt(i + 1) == '_')) {
                        ++i;
                    }
                    stringBuffer.append(pattern.charAt(i));
                }
            }
        }
        Pattern pat = null;
        try {
            pat = Pattern.compile(new String(stringBuffer));
        }
        catch (PatternSyntaxException patE) {
            throw JMSExceptionUtil.createJMSException("Illegal pattern in LIKE predicate: " + stringBuffer, patE);
        }
        if (!(identifier instanceof String)) {
            throw new IllegalArgumentException("Illegal value in LIKE predicate: " + identifier);
        }
        Matcher matcher = pat.matcher((String)identifier);
        if (this.not) {
            return new Boolean(!matcher.matches());
        }
        return new Boolean(matcher.matches());
    }
}

