/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mq.common.runtime.IConnectionMemberInfo;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class ConnectionMemberInfo
implements IConnectionMemberInfo {
    private static final long serialVersionUID = 0L;
    private static final short CURRENT_VERSION = 0;
    private static final ArrayList EMPTY_CHILD_LIST = new ArrayList(0);
    String m_name;
    short m_type;
    Long m_ref;
    Long m_parentRef;
    ArrayList m_childRefs;

    ConnectionMemberInfo() {
    }

    ConnectionMemberInfo(String name, short type, Long ref, Long parentRef, ArrayList childRefs) {
        this.m_name = name;
        this.m_type = type;
        this.m_ref = ref;
        this.m_parentRef = parentRef;
        this.m_childRefs = childRefs;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public short getType() {
        return this.m_type;
    }

    @Override
    public String getTypeString() {
        short type = this.getType();
        if (type < 0 || type > TYPE_TEXT.size()) {
            type = 0;
        }
        return (String)TYPE_TEXT.get(type);
    }

    @Override
    public Long getRef() {
        return this.m_ref;
    }

    @Override
    public Long getParentRef() {
        return this.m_parentRef;
    }

    @Override
    public ArrayList getChildRefs() {
        if (this.m_childRefs == null) {
            return EMPTY_CHILD_LIST;
        }
        return this.m_childRefs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Connection member:name=").append(this.m_name);
        sb.append(",type=").append(this.m_type);
        sb.append(",ref=").append(this.m_ref);
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(0);
        stream.writeUTF(this.m_name);
        stream.writeShort(this.m_type);
        stream.writeObject(this.m_ref);
        stream.writeObject(this.m_parentRef);
        stream.writeObject(this.m_childRefs);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        short version = stream.readShort();
        switch (version) {
            case 0: {
                this.m_name = stream.readUTF();
                this.m_type = stream.readShort();
                this.m_ref = (Long)stream.readObject();
                this.m_parentRef = (Long)stream.readObject();
                this.m_childRefs = (ArrayList)stream.readObject();
                break;
            }
            default: {
                throw new InvalidObjectException("Unsupported Sonic management version - class: " + this.getClass().getName() + ", version: " + version);
            }
        }
    }
}

