/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mq.components.ConfigPropertiesPopulator;
import java.io.IOException;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.Broker;
import progress.message.net.ESocketConfigException;

public class BrokerAcceptorsChangeHandler
implements IAttributeChangeHandler {
    private String m_configElementName = "";
    private String m_bname;
    private IElement m_primarybce;
    private IComponentContext m_context = null;

    BrokerAcceptorsChangeHandler(IComponentContext context, IElement primarybce, String bname, boolean primary, String configElementName) {
        this.m_context = context;
        this.m_primarybce = primarybce;
        this.m_bname = bname;
        this.m_configElementName = configElementName;
    }

    public void itemDeleted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void itemModified(Object newValue) {
        AcceptorHolder holder;
        AcceptorHolder acceptorHolder = holder = AcceptorHolder.getAcceptorHolder();
        synchronized (acceptorHolder) {
            try {
                IDeltaAttributeSet das = (IDeltaAttributeSet)newValue;
                String[] names = das.getModifiedAttributesNames();
                for (int i = 0; i < names.length; ++i) {
                    if (names[i].equals("ACCEPTORS")) {
                        this.acceptorsSetModified((IDeltaAttributeSet)das.getNewValue(names[i]), holder);
                        continue;
                    }
                    if (names[i].equals("DEFAULT_ACCEPTORS")) {
                        this.defaultAcceptorsModified((IDeltaAttributeSet)das.getNewValue(names[i]), holder);
                        continue;
                    }
                    if (!names[i].equals("HTTP_PARAMETERS")) continue;
                    this.httpParametersModified((IDeltaAttributeSet)das.getNewValue(names[i]), holder);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void acceptorsSetModified(IDeltaAttributeSet deltaAcceptorsSet, AcceptorHolder holder) {
        String[] newAcceptors = deltaAcceptorsSet.getNewAttributesNames();
        for (int i = 0; i < newAcceptors.length; ++i) {
            Acceptor acceptor;
            block8: {
                String configID = null;
                try {
                    configID = ((Reference)deltaAcceptorsSet.getNewValue(newAcceptors[i])).getElementName();
                }
                catch (NotModifiedAttException e) {
                    this.m_context.logMessage("Acceptor configuration failure, trace follows...", (Throwable)e, 2);
                    continue;
                }
                acceptor = null;
                try {
                    acceptor = ConfigPropertiesPopulator.newAcceptor(this.m_context, holder, configID, this.m_primarybce);
                    if (acceptor == null) {
                    }
                    break block8;
                }
                catch (ESocketConfigException e) {
                    this.m_context.logMessage("Acceptor configuration failure, trace follows...", (Throwable)e, 2);
                }
                continue;
            }
            try {
                Broker broker = Broker.getBroker();
                if (broker == null) continue;
                broker.initAcceptor(acceptor);
                continue;
            }
            catch (IOException e) {
                this.m_context.logMessage("Failed to initialize acceptor \"" + acceptor.getURL() + "\" , trace follows...", (Throwable)e, 2);
            }
        }
    }

    private void defaultAcceptorsModified(IDeltaAttributeSet mods, AcceptorHolder holder) throws Exception {
        String[] names = mods.getModifiedAttributesNames();
        for (int i = 0; i < names.length; ++i) {
            String configID = ((Reference)mods.getNewValue(names[i])).getElementName();
            Acceptor acceptor = holder.getAcceptor(configID);
            if (acceptor == null) continue;
            if (names[i].equals("PRIMARY_ACCEPTOR_REF")) {
                holder.setPrimaryAcceptor(acceptor);
                continue;
            }
            if (!names[i].equals("INTERBROKER_ACCEPTOR_REF")) continue;
            holder.setInterbrokerAcceptor(acceptor);
        }
    }

    private void httpParametersModified(IDeltaAttributeSet mods, AcceptorHolder holder) {
        this.m_context.logMessage(" dynamic configuration of HTTP acceptor parameters not supported, reload required", 2);
    }
}

