/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.direct;

import com.sonicsw.net.http.DestinationLookupException;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpInRequest;
import com.sonicsw.net.http.HttpInResponse;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpProtocolHandler;
import com.sonicsw.net.http.HttpRequestContext;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.direct.DirectHttpInConfig;
import com.sonicsw.net.http.direct.DirectHttpInRequest;
import com.sonicsw.net.http.direct.DirectHttpInResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import progress.message.jclient.Message;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.zclient.ProgressPasswordUser;

public class DirectHttpProtocolHandler
extends HttpProtocolHandler {
    protected static final String REPLYTO_TYPE_DIRECT = "DIRECT";
    public DirectHttpInConfig config = null;

    public DirectHttpProtocolHandler(HttpConfigInfo config) {
        super(config);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("DirectHttpProtocolHandler " + config.toString());
        }
        this.config = new DirectHttpInConfig(config);
    }

    @Override
    public HttpInRequest getInRequest(HttpServletRequest req) {
        return new DirectHttpInRequest(req);
    }

    @Override
    public HttpInResponse getInResponse(HttpServletResponse res) {
        return new DirectHttpInResponse(res);
    }

    @Override
    public ProgressPasswordUser authenticate(HttpInRequest request) {
        return super.authenticate(request, this.config.user, false, this.config.basicAuthentication, this.config.userPreconfigured, this.config.certificateAuthentication);
    }

    @Override
    public final boolean isBasicAuthSupported() {
        return this.config.basicAuthentication;
    }

    @Override
    public void service(HttpInRequest req, HttpInResponse res, HttpClientContext httpContext) throws IOException {
        DirectHttpInRequest request = (DirectHttpInRequest)req;
        DirectHttpInResponse response = (DirectHttpInResponse)res;
        try {
            HttpRequestContext reqContext;
            HttpLock lock;
            if (httpContext == null) {
                response.createResponse(500, "Service temporarily unavailable.");
                return;
            }
            if (this.config.isURLReceive()) {
                try {
                    request.mapReceiveDestination(this.config);
                }
                catch (DestinationLookupException de) {
                    response.createResponse(505, de.getMessage());
                    return;
                }
                catch (Exception e) {
                    int errcode = 404;
                    if (e.getMessage().startsWith("HTTP_NOT_AUTHORIZED")) {
                        errcode = 401;
                    }
                    response.createResponse(errcode, e.getMessage());
                    return;
                }
                if (request.isFileRetrival()) {
                    this.DoFileReceive(request, response);
                } else {
                    this.doReceiveFromQueue(request, response, httpContext, request.getReceiveQueueName());
                }
                return;
            }
            if (this.config.isReceive()) {
                this.doReceiveFromQueue(request, response, httpContext, this.config.receiveQueue);
                return;
            }
            try {
                request.mapJMSDestination(this.config);
            }
            catch (Exception e) {
                response.createResponse(506, e.getMessage());
                return;
            }
            Message message = request.handleMessage(this.config);
            if (!this.checkMaxMessageSize(message.getBodySize(), request, response)) {
                return;
            }
            if (!this.config.isOneway()) {
                this.setRequestReplyTo(message, REPLYTO_TYPE_DIRECT, httpContext);
            }
            if ((lock = (reqContext = this.sendMessageReusableLock(message, httpContext)).getHttpLock()).getContentReplyExpected() && reqContext.getMgram() != null) {
                try {
                    response.createEncodedContentResponse(reqContext.getMgram(), request.getCharacterEncoding());
                }
                catch (MessageHandlingException e) {
                    response.createResponse(500, e.getMessage());
                    int dmqReason = 10;
                    String msg = this.getPrBundleMsg("HTTP_DIRECT_UNSUPPORTED_MESSAGE_TYPE");
                    this.dmqNoException(reqContext.getMgram(), dmqReason, msg);
                }
                catch (Exception e) {
                    response.createResponse(500, "Failed to process content reply.");
                    int dmqReason = 4;
                    String msg = this.getPrBundleMsg("HTTP_DIRECT_CONNECTION_UNREACHABLE");
                    this.dmqNoException(reqContext.getMgram(), dmqReason, msg);
                }
            } else if (lock.getErrorType() != 200 && lock.getErrorType() != 202) {
                response.createResponse(lock.getErrorType(), lock.getMessage());
            } else {
                response.createResponse(200);
            }
        }
        catch (UnsupportedEncodingException e) {
            response.createResponse(400, "Unsupported encoding");
        }
        catch (Exception e) {
            if (HttpHelper.isMsgTooBigException(e)) {
                response.create413MessageTooLargeResponse();
                DirectHttpProtocolHandler.logLargeMessageWarning(request);
            }
            response.createResponse(400, "Invalid request: " + e.getMessage());
        }
    }

    private void DoFileReceive(DirectHttpInRequest request, DirectHttpInResponse response) throws IOException {
        try {
            byte[] aFile = request.readSonicfsFile();
            if (!this.checkMaxMessageSize(aFile.length, request, response)) {
                return;
            }
            response.createByteArrayContentResponse(aFile, "text/xml");
        }
        catch (Exception e) {
            response.createResponse(404, e.getMessage());
        }
    }

    private void doReceiveFromQueue(DirectHttpInRequest request, DirectHttpInResponse response, HttpClientContext httpContext, String qName) throws IOException {
        IMgram mgram = null;
        try {
            HttpRequestContext reqContext = this.receiveMessageAndWait(qName, httpContext, this.config.contentReplyTimeout * 1000);
            HttpLock lock = reqContext.getHttpLock();
            if (lock.getErrorType() != 200) {
                response.createResponse(lock.getErrorType(), lock.getMessage());
                return;
            }
            mgram = reqContext.getMgram();
            if (mgram == null) {
                HttpConstants.DEBUG("Request queue empty", 1);
                response.createResponse(204, "The receive queue is empty, or the request timed out while waiting for the next message.");
                return;
            }
            if (!this.checkMaxMessageSize(mgram.getBodyLength(), request, response)) {
                return;
            }
            try {
                response.createEncodedContentResponse(mgram, "ISO-8859-1");
            }
            catch (Exception e) {
                this.restore(mgram, this.config.receiveQueue);
                response.createResponse(500, "Failed to process receive request.");
            }
            try {
                this.ack(mgram);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            response.createResponse(500, "Failed to process receive request.");
        }
    }
}

