/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.jms;

import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import com.sonicsw.net.http.jms.JmsHttpCommand;
import com.sonicsw.net.http.jms.JmsHttpConfig;
import com.sonicsw.net.http.jms.JmsHttpInRequest;
import com.sonicsw.net.http.jms.JmsHttpInResponse;
import com.sonicsw.net.http.jms.JmsHttpProtocolHandler;
import javax.jms.JMSException;
import progress.message.jclient.Message;
import progress.message.msg.IMgram;

public class JmsHttpCommandPoll
implements JmsHttpCommand {
    private JmsHttpConfig config = null;
    private HttpClientContext context = null;
    private long uniqueId = -1L;
    private JmsHttpProtocolHandler handler = null;
    private String receiveQueue;
    private int receiveTimeout;

    public JmsHttpCommandPoll(JmsHttpConfig config, HttpClientContext httpContext, JmsHttpProtocolHandler handler) {
        this.config = config;
        this.context = httpContext;
        this.uniqueId = this.uniqueId;
        this.handler = handler;
    }

    @Override
    public Message parseRequest(JmsHttpInRequest request, JmsHttpConfig config) throws PropertyMissingException, PropertyBadValueException, JMSException, MessageHandlingException {
        request.handleReceiveDestination(true);
        this.receiveQueue = request.getReceiveQueue();
        request.handleReceiveTimeout(false);
        this.receiveTimeout = request.getReceiveTimeout();
        return null;
    }

    @Override
    public void createResponse(JmsHttpInResponse response, Message message) {
        response.createOKResponse(this.uniqueId, message);
    }

    @Override
    public void createContentResponse(JmsHttpInResponse response, IMgram mgram) {
        this.createEncodedContentResponse(response, mgram, "ISO-8859-1");
    }

    @Override
    public void createEncodedContentResponse(JmsHttpInResponse response, IMgram mgram, String encoding) {
        try {
            response.createEncodedContentResponse(mgram, encoding);
        }
        catch (Exception e) {
            HttpConstants.DEBUG(e, 1);
            this.handler.restore(mgram, this.receiveQueue);
            response.createResponse(500, "Failed to process content reply.");
        }
    }
}

