/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.jms;

import com.sonicsw.net.http.HttpConfigInfo;
import java.util.Hashtable;

public class JmsHttpConfig {
    private boolean dupDetect = false;
    private boolean reqConfirm = false;
    private Boolean oneway = null;
    public int contentReplyTimeout = 0;
    private boolean isReceive = false;
    public boolean headerAuthentication = false;
    public boolean basicAuthentication = false;
    public boolean certificateAuthentication = false;
    public boolean userPreconfigured = false;
    public String user = null;
    private Hashtable contentMaps = null;

    public JmsHttpConfig(HttpConfigInfo config) {
        this.dupDetect = config.getBooleanElement("DuplicateDetect", false);
        this.reqConfirm = config.getBooleanElement("RequestConfirm", false);
        String requestMode = config.getStringElement("RequestMode");
        if (requestMode != null && requestMode.equalsIgnoreCase("Receive")) {
            requestMode = "ContentReply";
            this.isReceive = true;
        }
        this.oneway = requestMode != null && requestMode.equalsIgnoreCase("ContentReply") ? new Boolean(false) : new Boolean(true);
        if (this.isReceive()) {
            this.contentReplyTimeout = config.getIntElement("ContentReplyTimeout", 3);
            this.contentReplyTimeout = Math.max(this.contentReplyTimeout, 1);
        } else {
            this.contentReplyTimeout = config.getIntElement("ContentReplyTimeout", 60);
            this.contentReplyTimeout = Math.max(this.contentReplyTimeout, 10);
        }
        this.headerAuthentication = config.getBooleanElement("HTTP_HEADER", false);
        this.basicAuthentication = config.getBooleanElement("HTTP_BASIC", false);
        this.certificateAuthentication = config.getBooleanElement("SSL_CERTIFICATE", false);
        this.userPreconfigured = config.getBooleanElement("CONFIG_USER", true);
        this.user = config.getStringElement("User");
        this.contentMaps = config.getContentMappings();
    }

    public boolean isDupDetect() {
        return this.dupDetect;
    }

    public boolean isRequestConfirm() {
        return this.reqConfirm;
    }

    public boolean isOneway() {
        if (this.oneway == null) {
            return true;
        }
        return this.oneway;
    }

    public final boolean isReceive() {
        return this.isReceive;
    }

    public boolean headerAuthentication() {
        return this.headerAuthentication;
    }

    public Hashtable getContentMappings() {
        return this.contentMaps;
    }
}

