/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.soap;

import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.InvalidSoapContentException;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.UnsupportedJMSMessageTypeException;
import com.sonicsw.net.http.direct.DirectHttpOutRequest;
import com.sonicsw.net.http.soap.SonicSoapVerifier;
import com.sonicsw.net.http.soap.prAccessor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import progress.message.jclient.MessagePart;
import progress.message.jclient.Part;
import progress.message.jimpl.xmessage.MultipartMessage;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.Message;

public class SoapHttpOutRequest
extends DirectHttpOutRequest {
    private String m_soapVersion = "SOAP 1.1";

    @Override
    public void buildRequest(IMgram mgram, HttpOutboundHandler handler) throws MessageHandlingException {
        byte[] body;
        String messageType = SoapHttpOutRequest.getMessageType(mgram);
        if (messageType == null) {
            throw new UnsupportedJMSMessageTypeException(com.sonicsw.net.http.prAccessor.getString("HTTP_ROUTING_UNSUPPORTED_JMS_MESSAGE_TYPE"));
        }
        ISidebandData side = mgram.getSidebandData();
        Hashtable table = side.getProperties();
        Object soapactionProperty = table.get("SOAPAction");
        if (soapactionProperty != null) {
            this.setProperty("SOAPAction", soapactionProperty.toString());
        } else {
            this.setProperty("SOAPAction", "\"\"");
        }
        InputStream is = null;
        if ("XML".equals(messageType) || "TEXT".equals(messageType)) {
            body = mgram.getRawBody();
            int offset = 4;
            if (body == null) {
                throw new MessageHandlingException(prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
            }
            int bodyLength = 0;
            try {
                bodyLength = mgram.getBodyLength();
            }
            catch (EAssertFailure e) {
                bodyLength = body.length;
            }
            if (bodyLength < offset || bodyLength > body.length) {
                throw new MessageHandlingException(prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT") + "Invalid message body length");
            }
            is = new ByteArrayInputStream(body, offset, bodyLength - offset);
        } else if ("MULTIPART".equals(messageType)) {
            try {
                MultipartMessage multiMessage = new MultipartMessage(new Envelope(new Message(mgram.getRawBody())));
                int count = multiMessage.getPartCount();
                if (count < 1) {
                    throw new MessageHandlingException(prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
                }
                Part part = multiMessage.getPart(0);
                if (!part.isMessagePart()) {
                    is = part.getInputStream();
                }
                MessagePart mp = (MessagePart)part;
                javax.jms.Message jmsMsg = mp.getMessage();
                if (!(jmsMsg instanceof TextMessage)) {
                    throw new MessageHandlingException(prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
                }
                try {
                    progress.message.jimpl.TextMessage textJmsMsg = (progress.message.jimpl.TextMessage)((Object)jmsMsg);
                    byte[] body2 = textJmsMsg.getEnvelope().getMessage().getBody();
                    is = new ByteArrayInputStream(body2, 4, body2.length - 4);
                }
                catch (Exception e) {
                    throw new MessageHandlingException(prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT") + e.getMessage());
                }
            }
            catch (ClassCastException e) {
                throw new MessageHandlingException(prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
            }
            catch (JMSException jmse) {
                throw new MessageHandlingException(prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
            }
        } else if ("BYTES".equals(messageType)) {
            body = mgram.getRawBody();
            int offset = 0;
            if (body == null || body.length < offset) {
                throw new MessageHandlingException(prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT"));
            }
            is = new ByteArrayInputStream(body, offset, body.length - offset);
        }
        try {
            SonicSoapVerifier verifier = new SonicSoapVerifier(is, "text/xml");
            this.setSoapVersion(verifier.getSoapVersionString());
        }
        catch (Exception e) {
            throw new InvalidSoapContentException(prAccessor.getString("SOAP_DIRECT_INVALID_SOAP_CONTENT") + e.getMessage());
        }
        super.buildRequest(mgram, handler);
    }

    public void setSoapVersion(String version) {
        if (version != null) {
            this.m_soapVersion = version;
        }
    }

    public String getSoapVersion() {
        return this.m_soapVersion;
    }
}

