/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.cert;

import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;

public class BrokerCertificateStore {
    private static BrokerCertificateStore s_certStore = null;
    private static Object _sync = new Object();
    private HashMap m_certById = null;
    private HashMap m_certsByIssuer = null;
    private KeyStore m_keyStore = null;
    private Object m_syncObj = new Object();
    private Thread m_wlockHolder = null;
    private int m_readCount = 0;
    private int m_writeCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerCertificateStore getInstance() throws KeyStoreException {
        if (s_certStore == null) {
            Object object = _sync;
            synchronized (object) {
                if (s_certStore == null) {
                    s_certStore = new BrokerCertificateStore();
                }
            }
        }
        return s_certStore;
    }

    private BrokerCertificateStore() throws KeyStoreException {
        this.m_certById = new HashMap();
        this.m_certsByIssuer = new HashMap();
        this.m_keyStore = KeyStore.getInstance("JKS");
        try {
            this.m_keyStore.load(null, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public KeyStore getKeyStore() {
        return this.m_keyStore;
    }

    public void init(HashMap certs) throws KeyStoreException {
        if (certs == null) {
            return;
        }
        this.m_certById = certs;
        for (X509Certificate cert : this.m_certById.values()) {
            String issuer = cert.getIssuerX500Principal().getName();
            this.configCertsBySerial(cert, issuer);
        }
        for (String alias : this.m_certById.keySet()) {
            X509Certificate cert = (X509Certificate)this.m_certById.get(alias);
            this.m_keyStore.setCertificateEntry(alias, cert);
        }
    }

    public synchronized X509Certificate findCertificateByIssuerAndSerialNumber(String issuerDNParam, BigInteger sn) {
        String issuerDN = issuerDNParam;
        X500Principal principal = null;
        try {
            principal = new X500Principal(issuerDN);
        }
        catch (IllegalArgumentException e) {
            StringTokenizer st = new StringTokenizer(issuerDN, ",");
            issuerDN = "";
            while (st.hasMoreElements()) {
                String s = st.nextToken();
                if (s == null || s.trim().length() == 0) continue;
                if (s.startsWith("E=") || s.startsWith("e=")) {
                    s = s.replaceFirst("E=", "EMAILADDRESS=");
                }
                if (issuerDN.trim().length() == 0) {
                    issuerDN = issuerDN + s;
                    continue;
                }
                issuerDN = issuerDN + "," + s;
            }
            try {
                principal = new X500Principal(issuerDN);
            }
            catch (IllegalArgumentException s) {
                // empty catch block
            }
        }
        if (principal == null) {
            return null;
        }
        String issuer = principal.getName();
        if (issuer == null || sn == null) {
            return null;
        }
        X509Certificate cert = null;
        HashMap certsBySerial = (HashMap)this.m_certsByIssuer.get(issuer);
        if (certsBySerial != null) {
            cert = (X509Certificate)certsBySerial.get(sn);
        }
        return cert;
    }

    public synchronized X509Certificate findCertificateBySubjectKeyIdentifier(byte[] ski) throws CertificateException {
        throw new CertificateException("findCertificateBySubjectKeyIdentifier() not supported.");
    }

    public synchronized void addToken(String key, X509Certificate cert) throws KeyStoreException {
        if (this.m_certById == null) {
            return;
        }
        String issuer = cert.getIssuerX500Principal().getName();
        this.m_certById.put(key, cert);
        this.m_keyStore.setCertificateEntry(key, cert);
        this.configCertsBySerial(cert, issuer);
    }

    private void configCertsBySerial(X509Certificate cert, String issuer) {
        HashMap<BigInteger, X509Certificate> certsBySerial = (HashMap<BigInteger, X509Certificate>)this.m_certsByIssuer.get(issuer);
        if (certsBySerial == null) {
            certsBySerial = new HashMap<BigInteger, X509Certificate>();
            this.m_certsByIssuer.put(issuer, certsBySerial);
        }
        certsBySerial.put(cert.getSerialNumber(), cert);
    }

    public synchronized void deleteToken(String key) throws KeyStoreException {
        HashMap certs;
        if (this.m_certById == null) {
            return;
        }
        X509Certificate cert = (X509Certificate)this.m_certById.remove(key);
        if (cert != null && (certs = (HashMap)this.m_certsByIssuer.get(cert.getIssuerX500Principal().getName())) != null) {
            X509Certificate x509Certificate = (X509Certificate)certs.remove(cert.getSerialNumber());
        }
        this.m_keyStore.deleteEntry(key);
    }

    public synchronized void reset() {
        this.m_certById = null;
        this.m_certsByIssuer = null;
        this.m_keyStore = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rlock() {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_writeCount == 0) {
                ++this.m_readCount;
                return;
            }
            boolean interrupted = false;
            while (this.m_writeCount > 0) {
                try {
                    this.m_syncObj.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.m_readCount = 1;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wlock() {
        Object object = this.m_syncObj;
        synchronized (object) {
            boolean interrupted = false;
            Thread t = Thread.currentThread();
            if (this.m_wlockHolder == null) {
                this.m_wlockHolder = t;
                while (this.m_readCount > 0) {
                    try {
                        this.m_syncObj.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                ++this.m_writeCount;
            } else if (this.m_wlockHolder == t) {
                ++this.m_writeCount;
            } else {
                while (this.m_wlockHolder != null) {
                    try {
                        this.m_syncObj.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                this.m_wlockHolder = t;
                this.m_writeCount = 1;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockr() {
        Object object = this.m_syncObj;
        synchronized (object) {
            --this.m_readCount;
            this.m_syncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockw() throws IllegalMonitorStateException {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_wlockHolder == Thread.currentThread()) {
                if (--this.m_writeCount == 0) {
                    this.m_wlockHolder = null;
                    this.m_syncObj.notifyAll();
                }
            } else {
                throw new IllegalMonitorStateException("unlock() without lock().");
            }
        }
    }
}

