/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.action.Encryption;
import com.sonicsw.ws.security.action.EncryptionSignatureBase;
import com.sonicsw.ws.security.action.Signature;
import com.sonicsw.ws.security.policy.Assertion;
import com.sonicsw.ws.security.policy.ConfidentialityAssertion;
import com.sonicsw.ws.security.policy.IntegrityAssertion;
import com.sonicsw.ws.security.policy.MessageAgeAssertion;
import com.sonicsw.ws.security.policy.SecurityPolicyAlternative;
import com.sonicsw.ws.security.policy.SecurityPolicyProcessor;
import com.sonicsw.ws.security.policy.SecurityTokenAssertion;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.processingresult.EncryptionSignatureResult;
import com.sonicsw.ws.security.processingresult.SignatureResult;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.SecurityPolicyException;
import com.sonicsw.wsp.WSPUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.ws.policy.Policy;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.model.RootPolicyEngineData;
import org.apache.ws.security.policy.model.X509Token;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.ws.x2002.x12.secext.ChallengeOrIntegrity;
import org.xmlsoap.schemas.ws.x2002.x12.secext.Confidentiality;
import org.xmlsoap.schemas.ws.x2002.x12.secext.ConfidentialityDocument;
import org.xmlsoap.schemas.ws.x2002.x12.secext.IntegrityDocument;
import org.xmlsoap.schemas.ws.x2002.x12.secext.MessageAgeDocument;
import org.xmlsoap.schemas.ws.x2002.x12.secext.MessageAgeType;
import org.xmlsoap.schemas.ws.x2002.x12.secext.SecurityHeaderDocument;
import org.xmlsoap.schemas.ws.x2002.x12.secext.SecurityTokenDocument;
import org.xmlsoap.schemas.ws.x2002.x12.secext.VisibilityDocument;
import org.xmlsoap.schemas.ws.x2004.x09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;

public class WSSPUtils {
    public static boolean match(QName type, String pattern, String value) {
        if (type.equals(WSSPConstants.QN_MATCHTYPE_REGEXP)) {
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(value);
            return m.matches();
        }
        if (type.equals(WSSPConstants.QN_MATCHTYPE_PREFIX)) {
            return value.startsWith(pattern);
        }
        if (type.equals(WSSPConstants.QN_MATCHTYPE_EXACT)) {
            return value.equals(pattern);
        }
        throw new IllegalArgumentException("Invalid match type: " + type);
    }

    public static IntegrityDocument[] getIntegrityAssertions(PolicyDocument pdoc) {
        IntegrityDocument[] integrityAssertions = null;
        if (WSPUtils.isSingleton(pdoc)) {
            integrityAssertions = (IntegrityDocument[])WSPUtils.getAssertions(WSPUtils.getSingletonAll(pdoc), IntegrityDocument.type.getName());
        }
        return integrityAssertions;
    }

    public static ConfidentialityDocument[] getConfidentialityAssertions(PolicyDocument pdoc) {
        ConfidentialityDocument[] confidentialityAssertions = null;
        if (WSPUtils.isSingleton(pdoc)) {
            confidentialityAssertions = (ConfidentialityDocument[])WSPUtils.getAssertions(WSPUtils.getSingletonAll(pdoc), ConfidentialityDocument.type.getName());
        }
        return confidentialityAssertions;
    }

    public static VisibilityDocument[] getVisibilityAssertions(PolicyDocument pdoc) {
        VisibilityDocument[] visibilityAssertions = null;
        if (WSPUtils.isSingleton(pdoc)) {
            visibilityAssertions = (VisibilityDocument[])WSPUtils.getAssertions(WSPUtils.getSingletonAll(pdoc), VisibilityDocument.type.getName());
        }
        return visibilityAssertions;
    }

    public static MessageAgeDocument[] getMessageAgeAssertions(PolicyDocument pdoc) {
        MessageAgeDocument[] messageAgeAssertions = null;
        if (WSPUtils.isSingleton(pdoc)) {
            messageAgeAssertions = (MessageAgeDocument[])WSPUtils.getAssertions(WSPUtils.getSingletonAll(pdoc), MessageAgeDocument.type.getName());
        }
        return messageAgeAssertions;
    }

    public static SecurityTokenDocument[] getSecurityTokenAssertions(PolicyDocument pdoc) {
        SecurityTokenDocument[] securityTokenAssertions = null;
        if (WSPUtils.isSingleton(pdoc)) {
            securityTokenAssertions = (SecurityTokenDocument[])WSPUtils.getAssertions(WSPUtils.getSingletonAll(pdoc), SecurityTokenDocument.type.getName());
        }
        return securityTokenAssertions;
    }

    public static XmlObject[] getAllSecurityAssertions(OperatorContentType content) {
        XmlObject[] assertions = null;
        assertions = content.selectPath(WSPUtils.childElementXPath("http://schemas.xmlsoap.org/ws/2002/12/secext"));
        return assertions;
    }

    public static boolean isIntegrityAssertion(XmlObject xobj) {
        SchemaType type;
        return xobj != null && (type = xobj.schemaType()) != null && type.getName() != null && type.getName().equals(WSSPConstants.QN_CHALLENGE_OR_INTEGRITY);
    }

    public static boolean isSecurityTokenAssertion(XmlObject xobj) {
        SchemaType type;
        return xobj != null && (type = xobj.schemaType()) != null && type.getName() != null && type.getName().equals(WSSPConstants.QN_SECURITY_TOKEN_TYPE);
    }

    public static boolean isUsernameTokenAssertion(SecurityTokenAssertion sta) {
        QName type;
        return sta != null && (type = sta.getTokenType()) != null && type.equals(WSSPConstants.QN_TOKENTYPE_USERNAME);
    }

    public static boolean isX509v3TokenAssertion(SecurityTokenAssertion sta) {
        QName type;
        return sta != null && (type = sta.getTokenType()) != null && type.equals(WSSPConstants.QN_TOKENTYPE_X509V3);
    }

    public static boolean isConfidentialityAssertion(XmlObject xobj) {
        SchemaType type;
        return xobj != null && (type = xobj.schemaType()) != null && type.getName() != null && type.getName().equals(WSSPConstants.QN_CONFIDENTIALITY);
    }

    public static boolean isVisibilityAssertion(XmlObject xobj) {
        SchemaType type;
        return xobj != null && (type = xobj.schemaType()) != null && type.getName() != null && type.getName().equals(VisibilityDocument.type);
    }

    public static boolean isSecurityHeaderAssertion(XmlObject xobj) {
        SchemaType type;
        return xobj != null && (type = xobj.schemaType()) != null && type.getName() != null && type.getName().equals(SecurityHeaderDocument.type);
    }

    public static boolean isMessageAgeAssertion(XmlObject xobj) {
        SchemaType type;
        return xobj != null && (type = xobj.schemaType()) != null && type.getName() != null && type.getName().equals(WSSPConstants.QN_MESSAGE_AGE);
    }

    public static Assertion createAssertionObject(String soapEnvNSUri, XmlObject xobj) throws PolicyException {
        if (WSSPUtils.isSecurityTokenAssertion(xobj)) {
            return new SecurityTokenAssertion(xobj);
        }
        if (WSSPUtils.isIntegrityAssertion(xobj)) {
            return new IntegrityAssertion(soapEnvNSUri, (ChallengeOrIntegrity)xobj);
        }
        if (WSSPUtils.isConfidentialityAssertion(xobj)) {
            return new ConfidentialityAssertion(soapEnvNSUri, (Confidentiality)xobj);
        }
        if (WSSPUtils.isMessageAgeAssertion(xobj)) {
            return new MessageAgeAssertion((MessageAgeType)xobj);
        }
        throw new IllegalArgumentException("Unsupported Assertion Type: " + xobj.schemaType().getName());
    }

    public static void buildActions(Policy policy, SecurityPolicyAlternative securityAlternative) throws PolicyException {
        if (policy == null) {
            return;
        }
        if (!policy.isNormalized()) {
            throw new RuntimeException("Policy is not in normalized format");
        }
        int numberOfPolicyAlternatives = WSPUtils.getNumberOfPolicyAlternatives(policy);
        if (numberOfPolicyAlternatives > 1) {
            throw new PolicyException("Policy contains " + numberOfPolicyAlternatives + " alternatives. Outbound policy must contain only one alternative.");
        }
        SecurityPolicyProcessor processor = new SecurityPolicyProcessor();
        try {
            processor.setup();
            WSSPUtils.buildActions(policy, securityAlternative, processor);
        }
        catch (Exception e) {
            if (e instanceof PolicyException) {
                throw (PolicyException)e;
            }
            throw new PolicyException(e);
        }
    }

    public static SecurityPolicyAlternative[] getPolicyAlternatives(Policy policy) throws PolicyException {
        if (policy == null) {
            return null;
        }
        Policy[] alternatives = WSPUtils.getPolicyAlternatives(policy);
        SecurityPolicyAlternative[] securityPolicies = new SecurityPolicyAlternative[alternatives.length];
        SecurityPolicyProcessor processor = new SecurityPolicyProcessor();
        try {
            processor.setup();
            for (int i = 0; i < alternatives.length; ++i) {
                securityPolicies[i] = new SecurityPolicyAlternative();
                WSSPUtils.buildActions(alternatives[i], securityPolicies[i], processor);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new PolicyException(nsme);
        }
        return securityPolicies;
    }

    private static void buildActions(Policy policy, SecurityPolicyAlternative securityAlternative, SecurityPolicyProcessor processor) throws PolicyException {
        processor.processPolicy(policy);
        PolicyEngineData rootPED = processor.secProcessorContext.readCurrentPolicyEngineData();
        if (!(rootPED instanceof RootPolicyEngineData)) {
            throw new PolicyException("Unexpected PolicyEngineData during processing of security assertions.  Expected RootPolicyEngineData, found " + rootPED);
        }
        securityAlternative.buildActions((RootPolicyEngineData)rootPED);
    }

    public static boolean isClient(MessageContext mc) {
        return mc.isClient();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getOutboundTokenRef(EncryptionSignatureBase action, MessageContext mc) throws SecurityPolicyException {
        boolean fromInitiator = WSSPUtils.isClient(mc);
        X509Token token = WSSPUtils.getToken(action, fromInitiator);
        String requiredTokenRef = WSSPUtils.getRequiredTokenRef(token);
        String includeTokenRef = WSSPUtils.getTokenInclusion(token, fromInitiator);
        String effectiveTokenRef = null;
        if ("Include token".equals(includeTokenRef)) {
            if (requiredTokenRef != null) throw new SecurityPolicyException("Inconsistent token reference models. Required external reference model " + requiredTokenRef + ", but token must be included.");
            return includeTokenRef;
        }
        if (requiredTokenRef == null) {
            if (action instanceof Signature) {
                if (action.getMustSupportRefIssuerSerial()) {
                    return "IssuerSerial";
                }
                if (action.getMustSupportRefKeyIdentifier()) {
                    return "KeyIdentifier";
                }
            } else {
                if (action.getMustSupportRefKeyIdentifier()) {
                    return "KeyIdentifier";
                }
                if (action.getMustSupportRefIssuerSerial()) {
                    return "IssuerSerial";
                }
            }
            if (effectiveTokenRef != null) return effectiveTokenRef;
            throw new SecurityPolicyException("Inconsistent token reference models. Token must not be included but there is no required or supported external token reference model.");
        }
        boolean supported = false;
        if ("IssuerSerial".equals(requiredTokenRef)) {
            supported = action.getMustSupportRefIssuerSerial();
        } else if ("KeyIdentifier".equals(requiredTokenRef)) {
            supported = action.getMustSupportRefKeyIdentifier();
        }
        if (!supported) throw new SecurityPolicyException("Inconsistent token reference models. Required external reference model " + requiredTokenRef + " is not supported. ");
        return requiredTokenRef;
    }

    public static boolean validateInboundTokenRef(EncryptionSignatureBase action, MessageContext mc, String tokenRefModel, EncryptionSignatureResult result) {
        boolean valid = true;
        boolean fromInitiator = !WSSPUtils.isClient(mc);
        X509Token token = WSSPUtils.getToken(action, fromInitiator);
        String requiredTokenRef = WSSPUtils.getRequiredTokenRef(token);
        String includeTokenRef = WSSPUtils.getTokenInclusion(token, fromInitiator);
        DebugObjects.getHandlerDebug().debug("WSSPUtils.validateInboundTokenRef():  action = " + (action instanceof Encryption ? "Encryption" : "Signature") + ", fromInitiator = " + fromInitiator + ", detected token ref = " + tokenRefModel + ", token inclusion =  " + includeTokenRef + ", required model = " + requiredTokenRef);
        if ("Include token".equals(includeTokenRef)) {
            if (!"Include token".equals(tokenRefModel)) {
                valid = false;
                result.setStatus("Invalid token reference model. Expected: " + includeTokenRef + ",  detected " + tokenRefModel);
            } else if (requiredTokenRef != null) {
                valid = false;
                result.setStatus("Invalid token reference model. Expected: " + includeTokenRef + ", detected: " + tokenRefModel);
            }
        } else if (requiredTokenRef == null) {
            if ("Include token".equals(tokenRefModel)) {
                valid = false;
                result.setStatus("Invalid token reference model. Expected: any supported external token reference model, detected: " + tokenRefModel);
            }
        } else if (!requiredTokenRef.equals(tokenRefModel)) {
            valid = false;
            result.setStatus("Invalid token reference model. Expected: " + requiredTokenRef + ", detected: " + tokenRefModel);
        }
        if (!valid) {
            DebugObjects.getPolicyDebug().debug((result instanceof SignatureResult ? "Signature" : "Encryption") + "Result: " + result.getStatus());
        }
        return valid;
    }

    private static X509Token getToken(EncryptionSignatureBase action, boolean fromInitiator) {
        X509Token token = null;
        token = action instanceof Signature && fromInitiator || action instanceof Encryption && !fromInitiator ? (X509Token)action.getInitiatorToken().getInitiatorToken() : (X509Token)action.getRecipientToken().getRecipientToken();
        return token;
    }

    private static String getRequiredTokenRef(X509Token token) {
        if (token.isRequireIssuerSerialReference()) {
            return "IssuerSerial";
        }
        if (token.isRequireKeyIdentifierReference()) {
            return "KeyIdentifier";
        }
        return null;
    }

    private static String getTokenInclusion(X509Token token, boolean toRecipient) {
        if (token.getInclusion().equals("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always")) {
            return "Include token";
        }
        if (toRecipient && token.getInclusion().equals("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient")) {
            return "Include token";
        }
        return null;
    }
}

