/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.wss4j;

import com.sonicsw.ws.security.policy.WSSPConstants;
import java.security.Provider;
import java.security.Security;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.Loader;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SonicWSSConfig
extends WSSConfig {
    public SonicWSSConfig() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public Processor getProcessor(QName el) throws WSSecurityException {
        String name = null;
        if (el.equals(WSSecurityEngine.SAML_TOKEN)) {
            name = "org.apache.ws.security.processor.SAMLTokenProcessor";
        } else if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
            name = "com.sonicsw.ws.security.wss4j.processor.EncryptedKeyProcessor";
        } else if (el.equals(WSSecurityEngine.SIGNATURE)) {
            name = "com.sonicsw.ws.security.wss4j.processor.SignatureProcessor";
        } else if (el.equals(WSSecurityEngine.timeStamp)) {
            name = "com.sonicsw.ws.security.wss4j.processor.TimestampProcessor";
        } else if (el.equals(WSSecurityEngine.usernameToken)) {
            name = "com.sonicsw.ws.security.wss4j.processor.UsernameTokenProcessor";
        } else if (el.equals(WSSecurityEngine.REFERENCE_LIST)) {
            name = "org.apache.ws.security.processor.ReferenceListProcessor";
        } else if (el.equals(WSSecurityEngine.signatureConfirmation)) {
            name = "org.apache.ws.security.processor.SignatureConfirmationProcessor";
        } else if (el.equals(WSSecurityEngine.DERIVED_KEY_TOKEN)) {
            name = "org.apache.ws.security.processor.DerivedKeyTokenProcessor";
        } else if (el.equals(WSSecurityEngine.SECURITY_CONTEXT_TOKEN)) {
            name = "org.apache.ws.security.processor.SecurityContextTokenProcessor";
        } else if (el.equals(WSSPConstants.QN_TRANSPORT_BINDING)) {
            name = "com.sonicsw.ws.security.wss4j.processor.TransportBindingProcessor";
        } else if (el.equals(WSSPConstants.QN_TRANSPORTTOKEN)) {
            name = "com.sonicsw.ws.security.wss4j.processor.TransportTokenProcessor";
        } else if (el.equals(WSSPConstants.QN_HTTPSTTOKEN)) {
            name = "com.sonicsw.ws.security.wss4j.processor.HttpsTokenProcessor";
        }
        if (name != null) {
            try {
                return (Processor)Loader.loadClass((String)name).newInstance();
            }
            catch (Throwable t) {
                throw new WSSecurityException(0, "unableToLoadClass", new Object[]{name});
            }
        }
        return null;
    }
}

