/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public class DeleteEndEvt
extends LogEvent {
    private long m_id;
    private long m_maxMessageId;

    DeleteEndEvt(long id, long maxMessageId) {
        this.m_id = id;
        this.m_maxMessageId = maxMessageId;
    }

    DeleteEndEvt() {
    }

    @Override
    public short type() {
        return 66;
    }

    @Override
    protected int memSizeBody() {
        return 16;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return this.memSizeBody();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        StreamUtil.writeLong(this.m_maxMessageId, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_maxMessageId = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().redoEndEvt(this.m_id, this.m_maxMessageId, this.isReplicateOnly());
    }

    @Override
    public String toString() {
        return super.toString() + "DeleteEnd cid: " + this.m_id + " MaxMessageId: " + this.m_maxMessageId;
    }
}

