/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerJob;
import progress.message.broker.Config;
import progress.message.broker.DurableCCTracker;
import progress.message.broker.DurableStatsEvent;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.INeighbor;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LogManager;
import progress.message.broker.durable.DurableBrokerJobReplyQueue;
import progress.message.broker.durable.DurableCountSizeRestorer;
import progress.message.broker.durable.DurableGetMgramOp;
import progress.message.broker.durable.DurableGetMgramReplyOp;
import progress.message.broker.durable.DurableInfoDelegator;
import progress.message.broker.durable.DurableOpProcessor;
import progress.message.broker.durable.DurableRemoveOp;
import progress.message.broker.durable.DurableRemoveReplyOp;
import progress.message.broker.durable.DurableSearchOp;
import progress.message.broker.durable.DurableSearchReplyOp;
import progress.message.broker.durable.DurableTrimOp;
import progress.message.broker.durable.DurableTrimReplyOp;
import progress.message.broker.durable.EDurableOperationException;
import progress.message.broker.durable.IDurableHeaderInfo;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyOperation;
import progress.message.interbroker.Interbroker;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;

public class DurableManager
extends DebugObject {
    private LongHashTable m_durableTrackersByCID = new LongHashTable();
    private Hashtable m_userDurableSubscriber = new Hashtable();
    private AgentRegistrar m_reg = null;
    private static int COUNT_BATCH_SIZE = 1000;
    private Hashtable m_neighborsToJobs = new Hashtable();
    private Hashtable m_jobsToNeighbors = new Hashtable();
    private long m_trackingIdentifier = -1L;
    private long m_trackingSeqNo = 0L;
    private Hashtable m_jobs = new Hashtable();
    private DurableCountSizeRestorer m_queryThread = null;
    private Object m_queryThreadSyncObject = new Object();
    private static final int CURRENT_DURABLE_TRACKING_MGRAM_VERSION = 0;
    private DurableOpProcessor m_durableOpProcessor = null;

    public DurableManager() {
        super("DurableManager");
        this.m_reg = AgentRegistrar.getAgentRegistrar();
    }

    void initialize() {
        this.m_durableOpProcessor = new DurableOpProcessor();
    }

    public void startCCSizeRestore(Vector v) {
        Vector<ICCSizeTracker> restoreTrackers = new Vector<ICCSizeTracker>();
        int numDurable = 0;
        long maxMessageId = AgentRegistrar.getAgentRegistrar().getBrokerDatabase().getMaxAddedMessageId();
        if (this.checkDebugFlags(64)) {
            this.debug("DurableManager.startCCSizeRestore: num trackers to check= " + v.size());
        }
        if (!v.isEmpty()) {
            Enumeration trackers = v.elements();
            while (trackers.hasMoreElements()) {
                ICCSizeTracker tracker = (ICCSizeTracker)trackers.nextElement();
                if (tracker.isRecovered()) continue;
                tracker.setQueryPending(true, maxMessageId);
                tracker.reset();
                restoreTrackers.add(tracker);
                if (!(tracker instanceof DurableCCTracker)) continue;
                ++numDurable;
            }
        }
        if (!restoreTrackers.isEmpty()) {
            if (this.checkDebugFlags(64)) {
                this.debug("DurableManager.startCCSizeRestore: numTrackersToRestore= " + restoreTrackers.size() + " numDurable= " + numDurable);
            }
            this.m_queryThread = new DurableCountSizeRestorer(maxMessageId, COUNT_BATCH_SIZE, restoreTrackers.elements());
            this.m_queryThread.start();
        } else if (this.checkDebugFlags(64)) {
            this.debug("DurableManager.startCCSizeRestore: no trackers to restore");
        }
    }

    public DurableOpProcessor getDurableOpProcessor() {
        return this.m_durableOpProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.m_queryThreadSyncObject;
        synchronized (object) {
            if (this.m_queryThread != null) {
                this.m_queryThread.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetQueryThread() {
        Object object = this.m_queryThreadSyncObject;
        synchronized (object) {
            this.m_queryThread = null;
        }
    }

    public DurableCCTracker register(IClientContext cc) {
        DurableCCTracker dcct = new DurableCCTracker(cc);
        this.m_durableTrackersByCID.put(cc.getId(), dcct);
        List<IClientContext> ll = (List<IClientContext>)this.m_userDurableSubscriber.get(cc.getCSC().getUid());
        if (ll == null) {
            ll = Collections.synchronizedList(new LinkedList());
            this.m_userDurableSubscriber.put(cc.getCSC().getUid(), ll);
        }
        ll.add(cc);
        return dcct;
    }

    public void unregister(IClientContext cc) {
        this.m_durableTrackersByCID.remove(cc.getId());
        List ll = (List)this.m_userDurableSubscriber.get(cc.getCSC().getUid());
        if (ll != null) {
            ll.remove(cc);
            if (ll.size() <= 0) {
                this.m_userDurableSubscriber.remove(cc.getCSC().getUid());
            }
        }
    }

    public Collection getDurableSubscriptions(String userId) {
        return (Collection)this.m_userDurableSubscriber.get(userId);
    }

    public Collection getDurableUids() {
        return this.m_userDurableSubscriber.keySet();
    }

    public Collection getAllDurableCCs() {
        Enumeration enu = ((LongHashTable)this.m_durableTrackersByCID.clone()).elements();
        LinkedList<IClientContext> list = new LinkedList<IClientContext>();
        while (enu.hasMoreElements()) {
            IClientContext cc = ((DurableCCTracker)enu.nextElement()).getCC();
            if (cc == null || cc.isGroupSubscription()) continue;
            list.add(cc);
        }
        return list;
    }

    public DurableCCTracker getDurableTracker(long cid) {
        return (DurableCCTracker)this.m_durableTrackersByCID.get(cid);
    }

    public IMgram getMgram(String JMSMessageID, long clientId, String brokerNameParam) throws EDurableOperationException, InterruptedException {
        String brokerName = brokerNameParam;
        if (brokerName == null) {
            IDurableHeaderInfo dhi = this.search(JMSMessageID, clientId, brokerName);
            brokerName = dhi.getOriginationBroker();
        }
        BrokerJob job = null;
        Collection result = null;
        if (Config.BROKER_NAME.equals(brokerName)) {
            job = new BrokerJob(1);
            result = this.performLocalDurableRequest(new DurableGetMgramOp(new DurableBrokerJobReplyQueue(job), clientId, JMSMessageID), job);
        } else {
            INeighbor target = this.retrieveNeighbor(brokerName);
            Vector<INeighbor> joblist = new Vector<INeighbor>();
            joblist.add(target);
            job = new BrokerJob(joblist);
            result = this.performRemoteDurableRequest(target, DurableGetMgramOp.getMgram(JMSMessageID, clientId), job);
        }
        Iterator iter = this.checkCancelledAndResult(job, result);
        DurableGetMgramReplyOp returnResult = null;
        while (iter.hasNext()) {
            DurableGetMgramReplyOp reply = (DurableGetMgramReplyOp)iter.next();
            this.checkError(reply);
            if (!reply.wasMessageFound()) {
                throw new EDurableOperationException(3);
            }
            returnResult = reply;
        }
        if (returnResult == null) {
            throw new NullPointerException("returnResult is null at " + DurableManager.class.getName() + ".getMgram( String JMSMessageID, long clientId, String brokerName )");
        }
        return returnResult.getResult();
    }

    public void remove(String JMSMessageID, long clientId, String brokerNameParam) throws EDurableOperationException, InterruptedException {
        String brokerName = brokerNameParam;
        if (brokerName == null) {
            IDurableHeaderInfo dhi = this.search(JMSMessageID, clientId, brokerName);
            brokerName = dhi.getOriginationBroker();
        }
        BrokerJob job = null;
        Collection result = null;
        if (Config.BROKER_NAME.equals(brokerName)) {
            job = new BrokerJob(1);
            result = this.performLocalDurableRequest(new DurableRemoveOp(new DurableBrokerJobReplyQueue(job), clientId, JMSMessageID), job);
        } else {
            INeighbor target = this.retrieveNeighbor(brokerName);
            Vector<INeighbor> joblist = new Vector<INeighbor>();
            joblist.add(target);
            job = new BrokerJob(joblist);
            result = this.performRemoteDurableRequest(target, DurableRemoveOp.getMgram(JMSMessageID, clientId), job);
        }
        Iterator iter = this.checkCancelledAndResult(job, result);
        while (iter.hasNext()) {
            DurableRemoveReplyOp reply = (DurableRemoveReplyOp)iter.next();
            this.checkError(reply);
            if (reply.wasMessageFound()) continue;
            throw new EDurableOperationException(3);
        }
    }

    private Iterator checkCancelledAndResult(BrokerJob job, Collection result) throws EAssertFailure, EDurableOperationException {
        this.checkCancelled(job);
        if (result.size() > 1) {
            throw new EAssertFailure("Too many responses for remove");
        }
        Iterator iter = result.iterator();
        return iter;
    }

    public Collection browse(long clientId, String tracking, int maxMessages) throws EDurableOperationException, InterruptedException {
        DurableCCTracker tracker;
        block8: {
            if (this.DEBUG) {
                this.debug("DurableManager.browse(" + clientId + ", " + tracking + ", " + maxMessages + ") invoked ");
            }
            tracker = this.retrieveAndCheckDurableCCTracker(clientId);
            try {
                IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(clientId);
                if (!cc.isDisconnected() || cc.isDisconnecting()) break block8;
                if (cc.isPendingReconnect()) {
                    AgentRegistrar.getAgentRegistrar().dropConnection(cc);
                }
                try {
                    if (cc.getPostponedMessageSaves() > 0L) {
                        AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().flush();
                        if (cc.getSavesInProgress() > 0) {
                            AgentRegistrar.getAgentRegistrar().getMsgSaver().flush();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (EClientNotRegistered e) {
                throw new EDurableOperationException(4);
            }
        }
        return tracker.browse(tracking, maxMessages);
    }

    public IDurableHeaderInfo search(String JMSMessageID, long clientId, String brokerName) throws EDurableOperationException, InterruptedException {
        Collection result = null;
        BrokerJob job = null;
        DurableCCTracker tracker = this.retrieveAndCheckDurableCCTracker(clientId);
        if (brokerName != null) {
            job = new BrokerJob(1);
            if (Config.BROKER_NAME.equals(brokerName)) {
                DurableSearchOp op = new DurableSearchOp(new DurableBrokerJobReplyQueue(job), clientId, JMSMessageID);
                result = this.performLocalDurableRequest(op, job);
            } else {
                INeighbor target = this.retrieveNeighbor(brokerName);
                Vector<INeighbor> joblist = new Vector<INeighbor>();
                joblist.add(target);
                job = new BrokerJob(joblist);
                result = this.performRemoteDurableRequest(target, DurableSearchOp.getMgram(JMSMessageID, clientId), job);
            }
        } else {
            Vector<Object> joblist = new Vector<Object>();
            INeighbor[] neighborArray = null;
            if (InterbrokerHook.isSet()) {
                neighborArray = Interbroker.getInterbroker().getAllNeighbors();
                for (int n = 0; n < neighborArray.length; ++n) {
                    if (neighborArray[n].getName().equals(Config.BROKER_NAME)) continue;
                    joblist.add(neighborArray[n]);
                }
            }
            joblist.add(this);
            job = new BrokerJob(joblist);
            DurableSearchOp op = new DurableSearchOp(new DurableBrokerJobReplyQueue(job, this), clientId, JMSMessageID);
            String tracking = this.createTracking();
            this.addBrokerJob(job, tracking, joblist);
            AgentRegistrar.getAgentRegistrar().getMsgSaver().performDurableOperation(op);
            result = this.performBroadcastDurableRequest(neighborArray, DurableSearchOp.getMgram(JMSMessageID, clientId), job, tracking);
        }
        Iterator iter = result.iterator();
        DurableInfoDelegator returnResult = null;
        while (iter.hasNext()) {
            DurableSearchReplyOp reply = (DurableSearchReplyOp)iter.next();
            this.checkError(reply);
            if (!reply.wasMessageFound() || returnResult != null) continue;
            returnResult = reply;
        }
        if (returnResult == null) {
            this.checkCancelled(job);
            throw new EDurableOperationException(3);
        }
        return returnResult.getReplyInformation();
    }

    private <T0 extends IDurableReplyOperation> void checkError(T0 reply) throws EDurableOperationException {
        if (reply.getErrorCode() != 0) {
            throw new EDurableOperationException(reply.getErrorCode());
        }
    }

    public void trimMessages(long clientId, long trimDateTime) throws EDurableOperationException, InterruptedException {
        block21: {
            Collection result = null;
            BrokerJob job = null;
            DurableTrimOp op = null;
            if (this.DEBUG) {
                DateFormat df = DateFormat.getDateInstance();
                this.debug("DurableManager.trimMessage(" + clientId + ", " + trimDateTime + ") invoked , datettime = " + new Date(trimDateTime).toString());
            }
            if (!new Date().after(new Date(trimDateTime))) {
                if (op == null) {
                    op = new DurableTrimOp(null, clientId, trimDateTime, -1L);
                }
                String msg = "trimMessage operation invoked with invalid future date ";
                op.sendTrimInvocationCancelled(msg);
                EDurableOperationException doe = new EDurableOperationException(1, msg);
                throw doe;
            }
            DurableCCTracker tracker = this.lookupDurableCCTracker(clientId);
            if (tracker == null || tracker.getCC() == null) {
                if (op == null) {
                    op = new DurableTrimOp(null, clientId, trimDateTime, -1L);
                }
                String msg = "Subscriber not found on this broker";
                op.sendTrimInvocationCancelled(msg);
                EDurableOperationException doe = new EDurableOperationException(4, msg);
                throw doe;
            }
            try {
                IClientContext cc = tracker.getCC();
                if (cc.isDisconnected() && !cc.isDisconnecting()) {
                    if (this.DEBUG) {
                        this.debug("DurableManager.trimMessage:clientId " + cc.getId() + " is for " + cc.getUid() + ":" + cc.getAppid());
                    }
                    Vector<Object> joblist = new Vector<Object>();
                    INeighbor[] neighborArray = null;
                    if (InterbrokerHook.isSet()) {
                        neighborArray = Interbroker.getInterbroker().getAllNeighbors();
                        for (int n = 0; n < neighborArray.length; ++n) {
                            if (neighborArray[n].getName().equals(Config.BROKER_NAME)) continue;
                            if (this.DEBUG) {
                                this.debug("DurableManager.trimMessage: adding " + neighborArray[n].getName() + " to the cluster broadcast list for the DurableTrimOp");
                            }
                            joblist.add(neighborArray[n]);
                        }
                    }
                    joblist.add(this);
                    job = new BrokerJob(joblist);
                    op = new DurableTrimOp(new DurableBrokerJobReplyQueue(job, this), cc.getId(), trimDateTime, -1L);
                    String tracking = this.createTracking();
                    this.addBrokerJob(job, tracking, joblist);
                    tracker.setSubscriptionTrimInProgress(true, op);
                    if (this.DEBUG) {
                        this.debug("DurableManager.trimMessage: added " + joblist.size() + " jobs  to DurableTrimOp calling msgSaver.performDurableOperation()");
                    }
                    AgentRegistrar.getAgentRegistrar().getMsgSaver().performDurableOperation(op);
                    result = this.performBroadcastDurableRequest(neighborArray, DurableTrimOp.getMgram(op.getClientID(), op.getTrimTimestamp(), -1L), job, tracking);
                    for (DurableTrimReplyOp reply : result) {
                        if (reply.getErrorCode() == 0) continue;
                        if (this.DEBUG) {
                            this.debug("DurableManager.trimMessage:  DurableTrimReplyOp contains no error");
                        }
                        IDurableHeaderInfo info = reply.getReplyInformation();
                        String msg = "Error returned from peer " + (info == null ? "" : info.getOriginationBroker());
                        throw new EDurableOperationException(reply.getErrorCode(), msg);
                    }
                    break block21;
                }
                if (op == null) {
                    op = new DurableTrimOp(null, cc.getId(), trimDateTime, -1L);
                }
                String msg = "Subscriber already active on this broker";
                op.sendTrimInvocationCancelled(msg);
                throw new EDurableOperationException(2, msg);
            }
            catch (EDurableOperationException e) {
                throw e;
            }
            catch (Exception e) {
                if (op == null) {
                    op = new DurableTrimOp(null, clientId, trimDateTime, -1L);
                }
                op.sendTrimInvocationCancelled(e.getMessage());
                throw new EDurableOperationException(1, e.getMessage());
            }
            finally {
                tracker.setSubscriptionTrimInProgress(false, op);
            }
        }
    }

    public String reserveBrowser(long clientId, boolean localParam) throws EDurableOperationException {
        boolean local = localParam;
        if (!InterbrokerHook.isSet()) {
            local = true;
        }
        DurableCCTracker tracker = this.retrieveAndCheckDurableCCTracker(clientId);
        String tracking = this.createTracking();
        tracker.createBrowser(tracking, clientId, local);
        return tracking;
    }

    public void setBrowserInactivityTimeout(String tracking, long clientId, int timeout) throws EDurableOperationException {
        DurableCCTracker tracker = this.retrieveAndCheckDurableCCTracker(clientId);
        tracker.setBrowseInactivityTimeout(tracking, timeout);
    }

    public void unreserveBrowser(String tracking, long clientId) throws EDurableOperationException {
        DurableCCTracker tracker = this.retrieveAndCheckDurableCCTracker(clientId);
        tracker.destroyBrowser(tracking);
    }

    private DurableCCTracker retrieveAndCheckDurableCCTracker(long clientId) throws EDurableOperationException {
        DurableCCTracker tracker = this.lookupDurableCCTracker(clientId);
        if (tracker == null) {
            throw new EDurableOperationException(4);
        }
        return tracker;
    }

    public BrokerJob getBrokerJob(String tracking) {
        return (BrokerJob)this.m_jobs.get(tracking);
    }

    public void addBrokerJob(BrokerJob job, String tracking) {
        this.m_jobs.put(tracking, job);
    }

    public synchronized void addBrokerJob(BrokerJob job, String tracking, INeighbor neighbor) {
        this.addBrokerJob(job, tracking);
        this.map(job, neighbor);
    }

    public synchronized void addBrokerJob(BrokerJob job, String tracking, Vector neighbors) {
        this.addBrokerJob(job, tracking);
        for (int i = 0; i < neighbors.size(); ++i) {
            this.map(job, neighbors.elementAt(i));
        }
    }

    public synchronized void cancelJobs(INeighbor neighbor) {
        Vector jobsForNeighbor;
        if (this.DEBUG) {
            this.debug("DurableManager cancelling jobs to " + neighbor);
        }
        if ((jobsForNeighbor = (Vector)this.m_neighborsToJobs.get(neighbor)) == null) {
            if (this.DEBUG) {
                this.debug("DurableManager has no jobs queued for " + neighbor);
            }
            return;
        }
        Enumeration entries = jobsForNeighbor.elements();
        while (entries.hasMoreElements()) {
            BrokerJob job = (BrokerJob)entries.nextElement();
            if (this.DEBUG) {
                this.debug("DurableManager job " + job + " cancelled for " + neighbor);
            }
            job.cancel(neighbor);
            this.unmap(job, neighbor);
        }
    }

    public synchronized void removeBrokerJob(String tracking) {
        BrokerJob job = (BrokerJob)this.m_jobs.remove(tracking);
        if (job != null) {
            this.unmap(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDurableStats(boolean waitForFlush) throws InterruptedException {
        int size = this.m_durableTrackersByCID.size();
        if (size > 0) {
            DurableStatsEvent stats = new DurableStatsEvent();
            Enumeration<Long> entries = this.m_durableTrackersByCID.keys();
            while (entries.hasMoreElements()) {
                DurableCCTracker tracker;
                Long key = entries.nextElement();
                DurableCCTracker durableCCTracker = tracker = (DurableCCTracker)this.m_durableTrackersByCID.get(key);
                synchronized (durableCCTracker) {
                    if (!tracker.isQueryPending()) {
                        tracker.freeze();
                        stats.addStat(key, tracker.getRestorableMessageCount(), tracker.getRestorableMessageSize());
                    }
                }
            }
            LogManager logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
            logMgr.addEvent(stats, true);
            if (waitForFlush) {
                logMgr.waitForFlush(stats);
            }
        }
    }

    private synchronized void map(BrokerJob job, Object neighbor) {
        Vector<BrokerJob> jobsForNeighbor = (Vector<BrokerJob>)this.m_neighborsToJobs.get(neighbor);
        if (jobsForNeighbor == null) {
            jobsForNeighbor = new Vector<BrokerJob>();
            this.m_neighborsToJobs.put(neighbor, jobsForNeighbor);
        }
        jobsForNeighbor.addElement(job);
        Vector<Object> neighborsForJob = (Vector<Object>)this.m_jobsToNeighbors.get(job);
        if (neighborsForJob == null) {
            neighborsForJob = new Vector<Object>();
            this.m_jobsToNeighbors.put(job, neighborsForJob);
        }
        neighborsForJob.addElement(neighbor);
    }

    private synchronized void unmap(BrokerJob job, Object neighbor) {
        Vector neighborsForJob;
        Vector jobsForNeighbor = (Vector)this.m_neighborsToJobs.get(neighbor);
        if (jobsForNeighbor != null) {
            jobsForNeighbor.remove(job);
        }
        if ((neighborsForJob = (Vector)this.m_jobsToNeighbors.get(job)) != null) {
            neighborsForJob.remove(neighbor);
            if (neighborsForJob.isEmpty()) {
                this.m_jobsToNeighbors.remove(job);
            }
        }
    }

    private synchronized void unmap(BrokerJob job) {
        Vector neighborsForJob = (Vector)this.m_jobsToNeighbors.get(job);
        if (neighborsForJob != null) {
            Vector neighbors = (Vector)neighborsForJob.clone();
            Enumeration entries = neighbors.elements();
            while (entries.hasMoreElements()) {
                this.unmap(job, entries.nextElement());
            }
        }
    }

    public static IMgram buildDurableTrackingMgram(String tracking, IMgram operationMgram) {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(12);
        try {
            ObjectOutput doutput = result.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeUTF(tracking);
            result.getOperationHandle().addMgram(operationMgram);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        result.setPriority(operationMgram.getPriority());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection performLocalDurableRequest(IDurableOperation op, BrokerJob brokerJob) throws InterruptedException {
        Collection result = null;
        String tracking = this.createTracking();
        this.addBrokerJob(brokerJob, tracking);
        try {
            BrokerJob brokerJob2 = brokerJob;
            synchronized (brokerJob2) {
                AgentRegistrar.getAgentRegistrar().getMsgSaver().performDurableOperation(op);
                result = brokerJob.join();
            }
        }
        finally {
            this.removeBrokerJob(tracking);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection performRemoteDurableRequest(INeighbor neighbor, IMgram durableOperationMgram, BrokerJob job) throws InterruptedException {
        Collection result = null;
        String tracking = this.createTracking();
        this.addBrokerJob(job, tracking, neighbor);
        try {
            if (neighbor.isConnected()) {
                IMgram trackingMgram = DurableManager.buildDurableTrackingMgram(tracking, durableOperationMgram);
                neighbor.sendThrough(trackingMgram);
                result = job.join();
            } else {
                job.cancel(neighbor);
                result = new Vector();
            }
        }
        finally {
            this.removeBrokerJob(tracking);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection performBroadcastDurableRequest(INeighbor[] neighbors, IMgram durableOperationMgram, BrokerJob job, String tracking) throws InterruptedException {
        Collection result = null;
        IMgram trackingMgram = DurableManager.buildDurableTrackingMgram(tracking, durableOperationMgram);
        try {
            BrokerJob brokerJob = job;
            synchronized (brokerJob) {
                if (neighbors != null) {
                    for (int i = 0; i < neighbors.length; ++i) {
                        if (Config.BROKER_NAME.equals(neighbors[i].getName())) continue;
                        if (this.DEBUG) {
                            this.debug("sending operation mgram to " + neighbors[i] + " isConnected() = " + neighbors[i].isConnected());
                        }
                        if (neighbors[i].isConnected()) {
                            neighbors[i].sendThrough(trackingMgram);
                            continue;
                        }
                        this.cancelJobs(neighbors[i]);
                    }
                }
                result = job.join();
            }
        }
        finally {
            this.removeBrokerJob(tracking);
        }
        return result;
    }

    public Collection performCWADSRequest(String brokerName, IMgram durableOperationMgram) throws EDurableOperationException, InterruptedException {
        Collection result = null;
        INeighbor target = this.retrieveNeighbor(brokerName);
        Vector<INeighbor> joblist = new Vector<INeighbor>();
        joblist.add(target);
        BrokerJob job = new BrokerJob(joblist);
        result = this.performRemoteDurableRequest(target, durableOperationMgram, job);
        this.checkCancelled(job);
        return result;
    }

    private void checkCancelled(BrokerJob job) throws EDurableOperationException {
        if (job.wasCancelled()) {
            throw new EDurableOperationException(1);
        }
    }

    private INeighbor retrieveNeighbor(String brokerName) throws EDurableOperationException {
        if (!InterbrokerHook.isSet()) {
            throw new EDurableOperationException(1);
        }
        INeighbor[] neighbors = Interbroker.getInterbroker().getAllNeighbors();
        INeighbor target = null;
        for (int n = 0; n < neighbors.length; ++n) {
            if (!neighbors[n].getName().equals(brokerName)) continue;
            target = neighbors[n];
        }
        if (target == null) {
            throw new EDurableOperationException(1);
        }
        return target;
    }

    public synchronized String createTracking() {
        if (this.m_trackingIdentifier == -1L) {
            this.m_trackingIdentifier = AgentRegistrar.getAgentRegistrar().getLogManager().getStartupSeqNo();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_trackingIdentifier);
        sb.append(":");
        sb.append(this.m_trackingSeqNo++);
        return sb.toString();
    }

    DurableCCTracker lookupDurableCCTracker(long clientId) {
        DurableCCTracker tracker = null;
        try {
            IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(clientId);
            tracker = cc.isGroupSubscriptionMember() ? (DurableCCTracker)this.m_durableTrackersByCID.get(cc.getGroupSubscriptionCC().getId()) : (DurableCCTracker)this.m_durableTrackersByCID.get(clientId);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        return tracker;
    }
}

