/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class QueueMsgGroupAssignEvt
extends LogEvent {
    private String m_queueName;
    private String m_groupName;
    private long m_receiverId;

    public QueueMsgGroupAssignEvt() {
        this.setReplicateOnly(true);
    }

    public QueueMsgGroupAssignEvt(String queueName, String groupName, long receiverId) {
        this.m_queueName = queueName;
        this.m_groupName = groupName;
        this.m_receiverId = receiverId;
        this.setReplicateOnly(true);
    }

    @Override
    public short type() {
        return 187;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoQueueMsgGroupAssign(this.m_queueName, this.m_groupName, this.m_receiverId);
    }

    @Override
    protected int memSizeBody() {
        return (this.m_queueName.length() << 1) + (this.m_groupName.length() << 1) + 8;
    }

    @Override
    protected int serializedSizeBody() {
        return this.streamSizeBody();
    }

    @Override
    protected void writeBodyToLog(OutputStream os, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(os);
    }

    @Override
    protected int streamSizeBody() {
        int size;
        block2: {
            size = 8;
            try {
                size += StringUtil.stringToUTF(this.m_queueName).length;
                size += StringUtil.stringToUTF(this.m_groupName).length;
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        return size;
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_queueName = StreamUtil.readUTF(in);
        this.m_groupName = StreamUtil.readUTF(in);
        this.m_receiverId = StreamUtil.readLong(in);
    }

    private void writeBody(OutputStream out) throws IOException {
        byte[] utfQueueName = StringUtil.stringToUTF(this.m_queueName);
        byte[] utfGroupName = StringUtil.stringToUTF(this.m_groupName);
        out.write(utfQueueName, 0, utfQueueName.length);
        out.write(utfGroupName, 0, utfGroupName.length);
        StreamUtil.writeLong(this.m_receiverId, out);
    }

    @Override
    public String toString() {
        return super.toString() + this.m_queueName + " group=\"" + this.m_groupName + "\" receiver=" + this.m_receiverId;
    }
}

