/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.wsp.OperationContextManager;
import java.io.IOException;
import java.util.Date;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.LogManager;
import progress.message.broker.MsgSaver;
import progress.message.broker.QMsgStateMgr;
import progress.message.broker.QueueMsgSaver;
import progress.message.broker.SyncBeginEvt;
import progress.message.broker.SyncEndEvt;
import progress.message.broker.SyncpointLoc;
import progress.message.broker.TransactionMgr;
import progress.message.ft.FTMgramFactory;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugThread;

class SyncpointThread
extends DebugThread {
    private LogManager m_lm;
    private AgentRegistrar m_reg;
    private MsgSaver m_msgSaver;
    private QueueMsgSaver m_queueMsgSaver;
    private TransactionMgr m_txnmgr;
    private QMsgStateMgr m_qMsgStateMgr;
    private int m_count;
    private Thread syncpointRequestor;
    private long m_lastPubSubSyncsize;
    private long m_lastQueueSyncsize;
    private boolean m_exiting;
    private boolean m_start;

    SyncpointThread(LogManager lm, AgentRegistrar reg) {
        super("SyncpointThread");
        this.m_lm = lm;
        this.m_reg = reg;
    }

    public int getCount() {
        return this.m_count;
    }

    public void resetCount() {
        this.m_count = 0;
    }

    public synchronized long getLastPubSubSyncsize() {
        return this.m_lastPubSubSyncsize;
    }

    private synchronized void setLastPubSubSyncsize(long size) {
        this.m_lastPubSubSyncsize = size;
    }

    public synchronized long getLastQueueSyncsize() {
        return this.m_lastQueueSyncsize;
    }

    private synchronized void setLastQueueSyncsize(long size) {
        this.m_lastQueueSyncsize = size;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void threadMain() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized void doSyncpoint() throws InterruptedException {
        this.doSyncpoint(false);
    }

    synchronized void doSyncpoint(boolean waitToStartAndComplete) throws InterruptedException {
        this.doSyncpoint(waitToStartAndComplete, waitToStartAndComplete);
    }

    synchronized void doSyncpoint(boolean waitToStart, boolean waitToComplete) throws InterruptedException {
        if (waitToStart) {
            while (this.syncpointRequestor != null) {
                if (this.m_exiting) {
                    throw new InterruptedException();
                }
                this.wait();
            }
            this.syncpointRequestor = Thread.currentThread();
        }
        this.m_start = true;
        this.notifyAll();
        if (waitToComplete) {
            while (this.syncpointRequestor == Thread.currentThread()) {
                if (this.m_exiting) {
                    throw new InterruptedException();
                }
                if (this.DEBUG) {
                    this.debug("Waiting for Syncpoint to complete: " + Thread.currentThread().getName());
                }
                this.wait();
            }
            if (this.DEBUG) {
                this.debug("Completed Syncpoint: " + Thread.currentThread().getName());
            }
        }
    }

    private synchronized void waitForStart() throws InterruptedException {
        while (!this.m_start) {
            this.wait();
        }
        if (this.syncpointRequestor == null) {
            this.syncpointRequestor = Thread.currentThread();
        }
        this.m_start = false;
    }

    private void doit() throws IOException, ECannotFlushEvents, InterruptedException {
        boolean replicateEndSyncpointOp;
        if (this.DEBUG) {
            this.debug("Beginning syncpoint, requestor= " + this.syncpointRequestor.getName() + " " + new Date());
        }
        SyncBeginEvt begin = new SyncBeginEvt();
        this.m_reg.getLogManager().addEvent(begin, true);
        if (this.CALLBACK) {
            this.callback("SyncBeginLogged", 0, null);
        }
        if (this.DEBUG) {
            this.debug("Completed flush of db threads " + new Date());
        }
        if (Config.REPLICATED) {
            this.m_reg.getReplicationManager().onSyncpointStart();
        }
        if (this.DEBUG) {
            this.debug("Writing last conn id to db, id = " + this.m_reg.getLastConnectionId());
        }
        this.m_reg.writeLastConnectionId();
        this.m_reg.getCounterManager().writeSyncRecords();
        this.m_txnmgr.writeSyncRecords();
        RMManager.getRMManager().writeSyncRecords();
        OperationContextManager.getOperationContextManager().writeSyncRecords();
        long bytes = AgentGuarMsgTracker.writeSyncEvents();
        this.setLastPubSubSyncsize(bytes);
        if (this.DEBUG) {
            this.debug("Wrote pubsub sync Events, bytesize= " + this.getLastPubSubSyncsize() + " " + new Date());
        }
        bytes = this.m_qMsgStateMgr.writeSyncEvents();
        this.setLastQueueSyncsize(bytes);
        if (this.DEBUG) {
            this.debug("Wrote queue sync Events, bytesize= " + this.getLastQueueSyncsize() + " " + new Date());
        }
        this.m_reg.getQueueProc().writeSyncTempQueues();
        this.m_reg.getQueueProc().writeSyncQueueMessageGroups();
        if (this.CALLBACK) {
            this.callback("SyncQueueInfoLogged", 1, null);
        }
        this.m_reg.getDeleteSubscriptionManager().writeSyncRecords();
        this.m_reg.getMsgRestoreMgr().writeSyncRecords();
        this.m_reg.getDeleteMsgManager().writeSyncRecords();
        this.m_reg.getGroupSubscriptions().writeSyncRecords();
        SyncEndEvt end = new SyncEndEvt();
        this.m_reg.getLogManager().addEvent(end, true);
        this.m_reg.getLogManager().waitForFlush(end);
        SyncpointLoc spl = this.m_lm.getSyncpointLoc();
        if (spl == null) {
            throw new EAssertFailure("Log SyncpointLoc is null");
        }
        this.m_reg.writeSyncSubscriptions(spl);
        if (this.DEBUG) {
            this.debug("Completed m_reg.writeSyncSubscriptions " + new Date());
        }
        this.m_lm.endSyncpoint();
        if (Config.REPLICATED && this.m_reg.getReplicationManager().okToReplicate() && (replicateEndSyncpointOp = this.m_reg.getReplicationManager().onSyncpointComplete())) {
            IMgram endSyncpoint = FTMgramFactory.createEndSyncpointOp();
            this.m_reg.getReplicationManager().replicateMgram(endSyncpoint);
        }
        ++this.m_count;
        if (this.DEBUG) {
            this.debug("Syncpoint complete, requestor= " + this.syncpointRequestor.getName() + ", syncsize= " + this.m_lm.getLastSyncsize() + ", numSyncpoints= " + this.m_count + " " + new Date());
        }
    }
}

