/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.DurableSubscriptionUtil;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.DurableTrimReplyOp;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyQueue;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class DurableTrimOp
implements IDurableOperation {
    private IDurableReplyQueue m_replyQueue;
    private long m_clientId;
    private long m_trimDateTime;
    private long m_invokerId;
    private AgentRegistrar m_reg = null;
    private static final byte CURRENT_VERSION = 0;

    public DurableTrimOp(IDurableReplyQueue queue, long clientId, long trimDateTime, long invokerId) {
        this.m_replyQueue = queue;
        this.m_clientId = clientId;
        this.m_trimDateTime = trimDateTime;
        this.m_invokerId = invokerId;
        this.m_reg = AgentRegistrar.getAgentRegistrar();
    }

    public DurableTrimOp(IDurableReplyQueue queue, IMgram mg, long invokerId) {
        this.m_replyQueue = queue;
        this.m_reg = AgentRegistrar.getAgentRegistrar();
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 28) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            ObjectInput dinput = mg.getPayloadInputStreamHandle();
            dinput.readByte();
            this.m_clientId = dinput.readLong();
            this.m_trimDateTime = dinput.readLong();
            this.m_invokerId = invokerId;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doit(BrokerDatabase db) throws IOException {
        DurableTrimReplyOp result = null;
        long maxTrimmedMessageId = -1L;
        IClientContext cc = null;
        try {
            cc = this.m_reg.lockContext(this.m_clientId);
            if (cc == null) {
                result = new DurableTrimReplyOp(Config.BROKER_NAME);
                result.setErrorCode(4);
                this.sendTrimInvocationCancelled("Subscriber not found on this broker");
            } else if (cc.isDisconnected() && !cc.isDisconnecting()) {
                maxTrimmedMessageId = this.m_reg.getDeleteSubscriptionManager().beginTrimDurableSubscription(this, cc);
                result = new DurableTrimReplyOp(Config.BROKER_NAME);
                result.setErrorCode(0);
            } else {
                result = new DurableTrimReplyOp(Config.BROKER_NAME);
                result.setErrorCode(2);
                this.sendTrimInvocationCancelled("Subscriber already active on this broker");
            }
        }
        catch (InterruptedException e) {
            result = new DurableTrimReplyOp(Config.BROKER_NAME);
            result.setErrorCode(1);
            this.sendTrimInvocationCancelled(e.getMessage());
        }
        catch (Exception e) {
            result = new DurableTrimReplyOp(Config.BROKER_NAME);
            result.setErrorCode(1);
            this.sendTrimInvocationCancelled(e.getMessage());
        }
        finally {
            if (cc != null) {
                cc.unlock();
            }
        }
        this.m_replyQueue.enqueue(result);
    }

    @Override
    public void postProcess() {
    }

    public static IMgram getMgram(long clientId, long trimDateTime, long invokerId) {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(28);
        try {
            ObjectOutput doutput = result.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeLong(clientId);
            doutput.writeLong(trimDateTime);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return result;
    }

    @Override
    public boolean isReplicateable() {
        return false;
    }

    public long getClientID() {
        return this.m_clientId;
    }

    public long getTrimTimestamp() {
        return this.m_trimDateTime;
    }

    public String getInvoker() {
        if (this.m_invokerId == -1L) {
            return "Management API invocation";
        }
        try {
            IClientContext cc = this.m_reg.getClient(this.m_invokerId);
            return cc.getUid() + ":" + cc.getAppid();
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            return Config.BROKER_NAME + " (DB Cleaner Background Thread)";
        }
    }

    public void sendDBMsgDeleteNotification(int totalDeleted) {
        try {
            IClientContext cc = this.m_reg.getClient(this.m_clientId);
            String topicName = null;
            String subscriptionName = null;
            String clientID = null;
            if (!cc.isGroupSubscription()) {
                BrokerSubscription dbs = cc.getDurableBrokerSubscription();
                topicName = dbs != null ? dbs.getSubject().getLookupName() : "Unavailable";
                subscriptionName = DurableSubscriptionUtil.getSubscriptionName(cc.getAppid());
                clientID = DurableSubscriptionUtil.getJMSClientID(cc.getAppid());
            } else {
                topicName = cc.getUid();
            }
            if (subscriptionName == null) {
                subscriptionName = "";
            }
            if (clientID == null) {
                clientID = "";
            }
            BrokerManagementNotificationsHelper.sendDurSubTrimDbMsgDeleteDoneNotification(this.getInvoker(), clientID, cc.getUid(), subscriptionName, topicName, this.m_trimDateTime, totalDeleted);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    public void sendTrimInvocationInitiated() {
        try {
            IClientContext cc = this.m_reg.getClient(this.m_clientId);
            String topicName = null;
            String subscriptionName = null;
            String clientID = null;
            if (!cc.isGroupSubscription()) {
                BrokerSubscription dbs = cc.getDurableBrokerSubscription();
                topicName = dbs != null ? dbs.getSubject().getLookupName() : "Unavailable";
                subscriptionName = DurableSubscriptionUtil.getSubscriptionName(cc.getAppid());
                clientID = DurableSubscriptionUtil.getJMSClientID(cc.getAppid());
            } else {
                topicName = cc.getUid();
            }
            if (subscriptionName == null) {
                subscriptionName = "";
            }
            if (clientID == null) {
                clientID = "";
            }
            BrokerManagementNotificationsHelper.sendDurSubTrimInitiatedNotification(this.getInvoker(), clientID, cc.getUid(), subscriptionName, topicName, this.m_trimDateTime);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    public void sendTrimInvocationCompleted() {
        try {
            IClientContext cc = this.m_reg.getClient(this.m_clientId);
            String topicName = null;
            String subscriptionName = null;
            String clientID = null;
            if (!cc.isGroupSubscription()) {
                BrokerSubscription dbs = cc.getDurableBrokerSubscription();
                topicName = dbs != null ? dbs.getSubject().getLookupName() : "Unavailable";
                subscriptionName = DurableSubscriptionUtil.getSubscriptionName(cc.getAppid());
                clientID = DurableSubscriptionUtil.getJMSClientID(cc.getAppid());
            } else {
                topicName = cc.getUid();
            }
            if (subscriptionName == null) {
                subscriptionName = "";
            }
            if (clientID == null) {
                clientID = "";
            }
            BrokerManagementNotificationsHelper.sendDurSubTrimCompletedNotification(this.getInvoker(), clientID, cc.getUid(), subscriptionName, topicName, this.m_trimDateTime);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    public void sendTrimInvocationCancelled(String reason) {
        try {
            IClientContext cc = this.m_reg.getClient(this.m_clientId);
            String topicName = null;
            String subscriptionName = null;
            String clientID = null;
            if (!cc.isGroupSubscription()) {
                BrokerSubscription dbs = cc.getDurableBrokerSubscription();
                topicName = dbs != null ? dbs.getSubject().getLookupName() : "Unavailable";
                subscriptionName = DurableSubscriptionUtil.getSubscriptionName(cc.getAppid());
                clientID = DurableSubscriptionUtil.getJMSClientID(cc.getAppid());
            } else {
                topicName = cc.getUid();
            }
            if (subscriptionName == null) {
                subscriptionName = "";
            }
            if (clientID == null) {
                clientID = "";
            }
            BrokerManagementNotificationsHelper.sendDurSubTrimCanceledNotification(this.getInvoker(), clientID, cc.getUid(), subscriptionName, topicName, this.m_trimDateTime, reason);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }
}

