/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.interceptor;

import com.sonicsw.interceptor.AdvisorRegistrar;
import com.sonicsw.interceptor.AgentMessageContext;
import com.sonicsw.interceptor.InterceptorException;
import com.sonicsw.interceptor.advisors.AgentAdvisor;
import com.sonicsw.interceptor.advisors.JMSAdvisor;
import com.sonicsw.net.http.HttpClientContext;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.broker.IRemoteBroker;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.net.ProgressInetAddress;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.SessionConfig;

public class InterceptorManager {
    private static JMSAdvisor s_jmsAdvisor;
    private static AgentAdvisor s_agentAdvisor;
    private static Properties s_interceptorProperties;
    private static boolean s_init;
    private static String s_host;
    private static AgentRegistrar s_reg;
    private static boolean s_legacyMode;
    private static String TOPIC_PREFIX;
    private static String QUEUE_PREFIX;
    private static String MULTITOPIC_PREFIX;
    private static boolean DEBUG;

    public static void initAgentAdvisors() {
        String mode = System.getProperty("sonic.mq.interceptor.legacyMode");
        if (mode != null && mode.equalsIgnoreCase("true")) {
            s_legacyMode = true;
        }
        if (!s_init) {
            block4: {
                s_interceptorProperties.setProperty("BROKER_NAME_ATTR", Config.BROKER_NAME);
                s_interceptorProperties.setProperty("ROUTING_NODE_NAME_ATTR", Config.ROUTING_NODE_NAME);
                AdvisorRegistrar.loadInterceptor(Config.LG_SERVER_INTERCEPTOR_CLASS, s_interceptorProperties);
                s_agentAdvisor = (AgentAdvisor)AdvisorRegistrar.getInstance(1);
                s_jmsAdvisor = (JMSAdvisor)AdvisorRegistrar.getInstance(101);
                try {
                    s_host = ProgressInetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException ex) {
                    s_host = ProgressInetAddress.getLocalHostName();
                    if (s_host != null) break block4;
                    s_host = "localhost";
                }
            }
            s_reg = AgentRegistrar.getAgentRegistrar();
            s_init = true;
        }
    }

    public static AgentAdvisor getAgentAdvisor() {
        return s_agentAdvisor;
    }

    public static JMSAdvisor getJMSAdvisor() {
        return s_jmsAdvisor;
    }

    public static void doActionalPubSubReceiveJointPoint(IMgram msg, IClientContext cc) {
        if (Config.LG_ENABLE && !InterceptorManager.isMessageLGInstrumented(msg) && s_jmsAdvisor != null) {
            try {
                if (msg.getSubject() == null || msg.getSubject().isAnySystem() || msg.getSubject().isSonicMQSubject()) {
                    return;
                }
                IMgram[] targetmgs = InterceptorManager.getInstrumentableMgrams(msg, false, true);
                for (int i = 0; i < targetmgs.length; ++i) {
                    AgentMessageContext ctx;
                    IMgram targetmg = targetmgs[i];
                    if (targetmg == null || !InterceptorManager.initAgentMessageContext(ctx = new AgentMessageContext(targetmg), cc, true)) continue;
                    s_jmsAdvisor.onTopicMessageReceived(ctx);
                }
            }
            catch (InterceptorException ie) {
                SessionConfig.logMessage(ie, SessionConfig.WARNING);
            }
            catch (Exception ex) {
                SessionConfig.logMessage(ex, SessionConfig.WARNING);
            }
        }
    }

    public static void doActionalP2PReceiveJointPoint(IMgram msg, IClientContext cc) {
        if (Config.LG_ENABLE && !InterceptorManager.isMessageLGInstrumented(msg) && s_jmsAdvisor != null) {
            try {
                if (msg.getSubject() == null || msg.getSubject().isAnySystem() || msg.getSubject().isSonicMQSubject()) {
                    return;
                }
                IMgram[] targetmgs = InterceptorManager.getInstrumentableMgrams(msg, false, true);
                for (int i = 0; i < targetmgs.length; ++i) {
                    AgentMessageContext ctx;
                    IMgram targetmg = targetmgs[i];
                    if (targetmg == null || !InterceptorManager.initAgentMessageContext(ctx = new AgentMessageContext(targetmg), cc, true)) continue;
                    s_jmsAdvisor.onQueueMessageReceived(ctx);
                }
            }
            catch (InterceptorException ie) {
                SessionConfig.logMessage(ie, SessionConfig.WARNING);
            }
            catch (Exception ex) {
                SessionConfig.logMessage(ex, SessionConfig.WARNING);
            }
        }
    }

    public static void doActionalPubSubSendJointPoint(IMgram msg, IClientContext cc) {
        block6: {
            try {
                if (Config.LG_ENABLE) {
                    if (!InterceptorManager.isMessageLGInstrumented(msg) || s_jmsAdvisor == null) break block6;
                    try {
                        IMgram[] targetmgs = InterceptorManager.getInstrumentableMgrams(msg, false, false);
                        for (int i = 0; i < targetmgs.length; ++i) {
                            AgentMessageContext ctx;
                            IMgram targetmg = targetmgs[i];
                            if (targetmg == null || !InterceptorManager.initAgentMessageContext(ctx = new AgentMessageContext(targetmg), cc, false)) continue;
                            s_jmsAdvisor.onTopicMessageSent(ctx);
                        }
                        break block6;
                    }
                    catch (InterceptorException ie) {
                        SessionConfig.logMessage(ie, SessionConfig.WARNING);
                        break block6;
                    }
                }
                InterceptorManager.removeTargetMgs(msg);
            }
            catch (Exception ex) {
                SessionConfig.logMessage(ex, SessionConfig.WARNING);
            }
        }
    }

    public static void doActionalP2PSendJointPoint(IMgram msg, IClientContext cc) {
        block6: {
            try {
                if (Config.LG_ENABLE) {
                    if (!InterceptorManager.isMessageLGInstrumented(msg) || s_jmsAdvisor == null) break block6;
                    try {
                        IMgram[] targetmgs = InterceptorManager.getInstrumentableMgrams(msg, false, false);
                        for (int i = 0; i < targetmgs.length; ++i) {
                            AgentMessageContext ctx;
                            IMgram targetmg = targetmgs[i];
                            if (targetmg == null || !InterceptorManager.initAgentMessageContext(ctx = new AgentMessageContext(targetmg), cc, false)) continue;
                            s_jmsAdvisor.onQueueMessageSent(ctx);
                        }
                        break block6;
                    }
                    catch (InterceptorException ie) {
                        SessionConfig.logMessage(ie, SessionConfig.WARNING);
                        break block6;
                    }
                }
                InterceptorManager.removeTargetMgs(msg);
            }
            catch (Exception ex) {
                SessionConfig.logMessage(ex, SessionConfig.WARNING);
            }
        }
    }

    private static void removeTargetMgs(IMgram msg) {
        IMgram[] targetmgs = InterceptorManager.getInstrumentableMgrams(msg, false, false);
        for (int i = 0; i < targetmgs.length; ++i) {
            IMgram targetmg = targetmgs[i];
            if (targetmg == null || !InterceptorManager.isMessageLGInstrumented(targetmg)) continue;
            InterceptorManager.removeParentStub(targetmg);
        }
    }

    private static boolean initAgentMessageContext(AgentMessageContext amc, IClientContext cc, boolean isPublisher) throws InterceptorException {
        IMgram msg = (IMgram)amc.getMessage();
        if (msg == null) {
            throw new InterceptorException("Cannot initialize AgentMessageContext for interceptor, message value not set");
        }
        if (cc == null) {
            return false;
        }
        AgentConnection connection = cc.getConnection();
        String uid = cc.getUid();
        boolean isHttpD = cc.isHTTPDirect();
        boolean isIB = cc.isInterbroker();
        boolean isRB = cc.isRemoteBroker();
        String acceptorURL = null;
        String remoteAddress = null;
        if (!isHttpD) {
            if (connection == null) {
                return false;
            }
            acceptorURL = connection.getAcceptorUrl();
            remoteAddress = connection.getSocket().getRemoteAddress();
        } else {
            remoteAddress = (String)msg.getSidebandData().getProperty("X-HTTP-UserAgentAddrress");
        }
        amc.setProperty("PAYLOAD_CAPTURE_ATTR", AdvisorRegistrar.getDynamicProperty("PAYLOAD_CAPTURE_ATTR"));
        if (isPublisher) {
            HttpClientContext httpcc;
            if (isHttpD && (httpcc = (HttpClientContext)cc).isHTTPDirectOutbound()) {
                return false;
            }
            String groupName = Config.ROUTING_NODE_NAME + "::" + Config.BROKER_NAME;
            amc.setProperty("NGSO_GROUP_ATTR", groupName);
            String serviceName = InterceptorManager.getServiceName(msg, true, -1L);
            amc.setProperty("NGSO_SERVICE_ATTR", serviceName);
            String path = s_host + "/" + groupName + "/" + serviceName;
            path = path.replace(':', '$').replace('|', '+');
            amc.setProperty("SERVICE_URL_ATTR", "sonic://" + path);
            String peerAddress = null;
            if (!s_legacyMode) {
                if (InterceptorManager.hasLGHeader(msg)) {
                    peerAddress = InterceptorManager.getLGProducerPeerAddress(msg);
                }
                if (peerAddress == null) {
                    peerAddress = remoteAddress;
                }
                amc.setProperty("PEER_ADDRESS_ATTR", peerAddress);
            } else if (!InterceptorManager.hasLGHeader(msg)) {
                if (isHttpD) {
                    peerAddress = "http_direct://" + uid + "@localhost";
                } else {
                    String protocol = InterceptorManager.useSonicProtocol(acceptorURL);
                    if (isIB) {
                        uid = Config.ROUTING_NODE_NAME + "::" + uid;
                    } else if (isRB) {
                        uid = cc.getNodeNameForRemoteBroker() + "::" + uid;
                    }
                    peerAddress = protocol + uid + "@" + remoteAddress;
                }
                amc.setProperty("PEER_ADDRESS_ATTR", peerAddress);
                amc.setProperty("PEER_TYPE_ATTR", "PEER_TYPE_QUEUE");
            } else {
                peerAddress = InterceptorManager.getLGProducerPeerAddress(msg);
                if (peerAddress == null) {
                    if (!isHttpD) {
                        peerAddress = remoteAddress;
                    }
                } else if (!isIB && !isRB) {
                    amc.setProperty("PEER_TYPE_ATTR", "PEER_TYPE_QUEUE");
                }
                amc.setProperty("PEER_ADDRESS_ATTR", peerAddress);
            }
            if (DEBUG) {
                System.out.println("DEBUG: SI setting group name = " + amc.getProperty("NGSO_GROUP_ATTR"));
                System.out.println("DEBUG: SI setting service name = " + amc.getProperty("NGSO_SERVICE_ATTR"));
                System.out.println("DEBUG: SI setting provider url = " + amc.getProperty("SERVICE_URL_ATTR"));
            }
        } else {
            AgentConnection conn = cc.getConnection();
            boolean isInstrumentedClient = false;
            boolean isJMSNodeRequired = false;
            if (conn != null) {
                isInstrumentedClient = conn.getLGInstrumentationEnabled();
                isJMSNodeRequired = conn.getLGDownStreamNodeType() == 1;
            }
            String protocol = InterceptorManager.useSonicProtocol(acceptorURL);
            String peerAddress = remoteAddress;
            String groupName = null;
            String serviceName = null;
            if (isIB || isRB) {
                amc.setProperty("PEER_ADDRESS_ATTR", peerAddress);
                if (isIB) {
                    groupName = Config.ROUTING_NODE_NAME + "::" + uid;
                } else if (isRB) {
                    IRemoteBroker rb = s_reg.getRouterManager().getRemoteBroker(cc.getId());
                    groupName = rb.getNodeName() + "::" + rb.getBrokerName();
                }
                amc.setProperty("NGSO_GROUP_ATTR", groupName);
                serviceName = InterceptorManager.getServiceName(msg, isIB, cc.getSubjectFilterId());
                amc.setProperty("NGSO_SERVICE_ATTR", serviceName);
            } else if (isInstrumentedClient) {
                if (isJMSNodeRequired) {
                    ISubject subject = msg.getSubject();
                    peerAddress = subject.isTemporary() ? (subject.isQueue() ? "TemporaryQueues" : "TemporaryTopics") : subject.getJMSName();
                    amc.setProperty("PEER_ADDRESS_ATTR", peerAddress);
                    amc.setProperty("PEER_TYPE_ATTR", msg.getSubject().isQueue() ? "PEER_TYPE_QUEUE" : "PEER_TYPE_TOPIC");
                    InterceptorManager.setLGProducerPeerAddress(msg, peerAddress);
                } else {
                    amc.setProperty("PEER_ADDRESS_ATTR", peerAddress);
                    groupName = uid;
                    amc.setProperty("NGSO_GROUP_ATTR", groupName);
                    serviceName = InterceptorManager.getServiceName(msg, false, cc.getSubjectFilterId());
                    amc.setProperty("NGSO_SERVICE_ATTR", serviceName);
                }
            } else if (!s_legacyMode) {
                amc.setProperty("PEER_ADDRESS_ATTR", peerAddress);
                groupName = uid;
                amc.setProperty("NGSO_GROUP_ATTR", groupName);
                serviceName = InterceptorManager.getServiceName(msg, false, cc.getSubjectFilterId());
                amc.setProperty("NGSO_SERVICE_ATTR", serviceName);
            } else {
                peerAddress = protocol + uid + "@" + peerAddress;
                amc.setProperty("PEER_ADDRESS_ATTR", peerAddress);
                amc.setProperty("PEER_TYPE_ATTR", "PEER_TYPE_QUEUE");
                InterceptorManager.setLGProducerPeerAddress(msg, peerAddress);
            }
            if (amc.getProperty("SERVICE_URL_ATTR") == null) {
                String path = peerAddress + "/" + groupName + "/" + serviceName;
                path = path.replace(':', '$').replace('|', '+');
                amc.setProperty("SERVICE_URL_ATTR", protocol + path);
            }
            if (DEBUG) {
                System.out.println("DEBUG: CI setting group name = " + amc.getProperty("NGSO_GROUP_ATTR"));
                System.out.println("DEBUG: CI setting service name = " + amc.getProperty("NGSO_SERVICE_ATTR"));
                System.out.println("DEBUG: CI setting provider url = " + amc.getProperty("SERVICE_URL_ATTR"));
            }
        }
        return true;
    }

    private static String useSonicProtocol(String acceptorURL) {
        String protocol = "sonic://";
        int idx = 0;
        if (acceptorURL != null && (idx = acceptorURL.indexOf("://")) != -1) {
            protocol = acceptorURL.substring(0, idx + 3);
        }
        return protocol;
    }

    public static void updateLGDynamicProperty(String property, Object value) {
        if (property.equals("INTERCEPTOR_DEBUG")) {
            AdvisorRegistrar.updateDynamicProperty("INTERCEPTOR_DEBUG_ATTR", value);
        } else if (property.equals("EVENTS_LOG_FILE")) {
            AdvisorRegistrar.updateDynamicProperty("EVENTS_LOG_FILE_ATTR", value);
        } else if (property.equals("PAYLOAD_CAPTURE")) {
            String type = (String)value;
            if (type == null || type.equalsIgnoreCase("NONE")) {
                type = "PAYLOAD_CAPTURE_ATTR_NONE";
            } else if (type.equalsIgnoreCase("HEADER")) {
                type = "PAYLOAD_CAPTURE_ATTR_HEADER";
            } else if (type.equalsIgnoreCase("BODY")) {
                type = "PAYLOAD_CAPTURE_ATTR_BODY";
            } else if (type.equalsIgnoreCase("ALL")) {
                type = "PAYLOAD_CAPTURE_ATTR_ALL";
            } else {
                return;
            }
            AdvisorRegistrar.updateDynamicProperty("PAYLOAD_CAPTURE_ATTR", type);
        } else if (property.equals("ACTIONAL_INTERCEPTOR")) {
            AdvisorRegistrar.updateDynamicProperty("ACTIONAL_INSTRUMENTATION_ATTR", value);
        }
    }

    public static boolean isMessageLGInstrumented(IMgram msg) {
        IMgram msgToCheck = InterceptorManager.getInstrumentableMgrams(msg, true, false)[0];
        return msgToCheck != null && msgToCheck.isInstrumented();
    }

    private static boolean hasLGHeader(IMgram msg) {
        return msg != null && msg.hasSidebandData() && msg.getSidebandDataReadOnly().getProperty("LG_Header") != null;
    }

    private static String getLGProducerPeerAddress(IMgram msg) {
        String ret = null;
        if (msg != null && msg.hasSidebandData()) {
            Hashtable props = msg.getSidebandData().getProperties();
            ret = (String)props.remove("LG_Header_Producer_PeerAddress");
            msg.getSidebandData().setProperties(props);
        }
        return ret;
    }

    private static void setLGProducerPeerAddress(IMgram msg, String peerAddress) {
        if (msg != null) {
            Hashtable props = msg.getSidebandData().getProperties();
            props.put("LG_Header_Producer_PeerAddress", peerAddress);
            msg.getSidebandData().setProperties(props);
        }
    }

    private static String getServiceName(IMgram msg, boolean needRemoteNodePrefix, long subjectFilterId) {
        String prefix = null;
        String serviceName = null;
        ISubject subject = msg.getSubject();
        if (DEBUG) {
            System.out.println("DEBUG: InterceptorManager.getServiceName(): un-filtered subject = " + subject.getJMSName() + ", is temp = " + subject.isTemporary());
        }
        if (subject.isMultiSubject()) {
            ISubjectFilter filter = null;
            ISubject filteredSubject = subject;
            if (subjectFilterId != -1L) {
                filter = msg.getBrokerHandle().getSubjectFilter(subjectFilterId);
            }
            if (filter != null) {
                filteredSubject = filter.filter(subject);
                if (DEBUG) {
                    System.out.println("DEBUG: InterceptorManager.getServiceName(): filtered subject = " + filteredSubject.getJMSName() + ", is temp = " + filteredSubject.isTemporary());
                }
            }
            prefix = filteredSubject.isMultiSubject() ? MULTITOPIC_PREFIX : TOPIC_PREFIX;
            if (filteredSubject.isTemporary() || filteredSubject.getJMSName().lastIndexOf("HttpProtocolHandlerResponse") > 0) {
                serviceName = "TemporaryTopics";
            } else {
                serviceName = filteredSubject.getJMSName();
                if (serviceName.startsWith("MULTITOPIC:")) {
                    serviceName = serviceName.substring("MULTITOPIC:".length());
                }
            }
        } else if (subject.isQueue()) {
            serviceName = subject.isTemporary() || subject.getJMSName().lastIndexOf("HttpProtocolHandlerResponse") > 0 ? "TemporaryQueues" : subject.getJMSName();
            prefix = QUEUE_PREFIX;
        } else {
            serviceName = subject.isTemporary() || subject.getJMSName().lastIndexOf("HttpProtocolHandlerResponse") > 0 ? "TemporaryTopics" : subject.getJMSName();
            prefix = TOPIC_PREFIX;
        }
        if (needRemoteNodePrefix && msg.forRemoteNode(Config.ROUTING_NODE_NAME)) {
            return msg.getRouting() + "::" + prefix + serviceName;
        }
        return prefix + serviceName;
    }

    public static void removeParentStub(IMgram msg) {
        if (msg.hasSidebandData()) {
            Hashtable properties = msg.getSidebandData().getProperties();
            properties.remove("LG_PARENT_SITE_STUB");
            msg.getSidebandData().setProperties(properties);
        }
        msg.setInstrumented(false);
    }

    private static IMgram[] getInstrumentableMgrams(IMgram msg, boolean firstOnly, boolean syncBatch) {
        IMgram[] targetMgrams = null;
        try {
            block1 : switch (msg.getType()) {
                case 27: {
                    IBatchHandle batch = msg.getBatchHandle();
                    if (syncBatch) {
                        batch.syncBatch();
                    }
                    targetMgrams = new IMgram[firstOnly ? 1 : batch.getBatchSize()];
                    Iterator iter = batch.getBatchIterator();
                    int i = 0;
                    while (iter.hasNext()) {
                        targetMgrams[i++] = (IMgram)iter.next();
                        if (!firstOnly) continue;
                        break block1;
                    }
                    break;
                }
                case 25: {
                    IOperationHandle iOpHandle = msg.getOperationHandle();
                    switch (iOpHandle.getOperationType()) {
                        case 3: 
                        case 13: 
                        case 14: {
                            targetMgrams = new IMgram[]{(IMgram)msg.getOperationHandle().getMgramList().getFirst()};
                            break block1;
                        }
                    }
                    break;
                }
                case 2: 
                case 12: {
                    targetMgrams = new IMgram[]{msg};
                    break;
                }
            }
        }
        catch (Throwable t) {
            SessionConfig.logMessage(t, SessionConfig.WARNING);
        }
        if (targetMgrams == null) {
            targetMgrams = new IMgram[]{null};
        }
        return targetMgrams;
    }

    static {
        s_interceptorProperties = new Properties();
        s_init = false;
        s_host = null;
        s_reg = null;
        s_legacyMode = false;
        TOPIC_PREFIX = "$Topic$";
        QUEUE_PREFIX = "$Queue$";
        MULTITOPIC_PREFIX = "$MultiTopic$";
        DEBUG = false;
    }
}

