/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.agent;

import com.sonicsw.mq.components.BrokerComponent;
import progress.message.broker.mqtt.MqttSession;
import progress.message.broker.mqtt.agent.MqttAgentSession;
import progress.message.broker.mqtt.proto.MessageIdMessage;
import progress.message.client.EGeneralException;
import progress.message.zclient.IJobCompletionListener;
import progress.message.zclient.Job;
import progress.message.zclient.Publication;
import progress.message.zclient.Subject;

public class MqttPublicationListener
implements IJobCompletionListener {
    private final MqttSession m_session;
    private final MessageIdMessage m_ackMessage;

    public MqttPublicationListener(MqttAgentSession session, MessageIdMessage ackMessage) {
        this.m_session = session;
        this.m_ackMessage = ackMessage;
    }

    @Override
    public void onJobComplete(Job job) {
        if (this.m_ackMessage != null) {
            Publication publication = (Publication)job;
            if (publication.getStatus() != 0) {
                Subject subject = new Subject(publication.getSubject());
                EGeneralException ex = Publication.buildException(publication.getStatus(), subject, publication.getMessage());
                String msg = "Failed to publish MQTT message id = " + this.m_ackMessage + ", error = " + ex.toString();
                BrokerComponent.getComponentContext().logMessage(msg, 2);
            } else {
                this.m_session.ackPublish(this.m_ackMessage);
            }
        }
    }
}

