/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.msg.IExtendedTXNRequestHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v25.DefaultPayload;
import progress.message.msg.v25.Mgram;
import progress.message.xa.XidImpl;
import progress.message.zclient.EMgramFormatError;

final class ExtendedTXNRequestPayload
extends DefaultPayload
implements IExtendedTXNRequestHandle {
    private static short EXTENDED_TX_REQUEST_MASK_CHAINED = 1;
    private static short EXTENDED_TX_REQUEST_MASK_XONCE = (short)2;
    boolean m_syncd = false;
    private short m_flags;
    private int m_op;
    private XidImpl m_xid;
    private int m_replyTracking = 0;
    private int m_tid = -1;
    private long m_clientId;

    public ExtendedTXNRequestPayload(Mgram m) {
        super(m);
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        super.initPayloadFromStream(is, sc);
        ObjectInput dis = this.getPayloadInputStreamHandle();
        this.m_op = dis.readInt();
        this.m_flags = dis.readShort();
        this.m_replyTracking = dis.readInt();
        this.m_tid = dis.readInt();
        this.m_clientId = dis.readLong();
        this.m_xid = new XidImpl();
        this.m_xid.readbody(dis);
    }

    @Override
    protected void sync() {
        if (this.m_syncd) {
            return;
        }
        try {
            ObjectOutput os = this.getPayloadOutputStreamHandle();
            os.writeInt(this.m_op);
            os.writeShort(this.m_flags);
            os.writeInt(this.m_replyTracking);
            os.writeInt(this.m_tid);
            os.writeLong(this.m_clientId);
            this.m_xid.writebody(os);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.m_syncd = true;
        super.sync();
    }

    @Override
    public int getOp() {
        return this.m_op;
    }

    @Override
    public void setOp(int op) {
        this.m_op = op;
    }

    @Override
    public boolean isChained() {
        return (this.m_flags & EXTENDED_TX_REQUEST_MASK_CHAINED) == EXTENDED_TX_REQUEST_MASK_CHAINED;
    }

    @Override
    public void setChained(boolean chained) {
        this.m_flags = chained ? (short)(this.m_flags | EXTENDED_TX_REQUEST_MASK_CHAINED) : (short)(this.m_flags & ~EXTENDED_TX_REQUEST_MASK_CHAINED);
    }

    @Override
    public String opStr() {
        switch (this.m_op) {
            case 0: {
                return "start";
            }
            case 1: {
                return "end";
            }
            case 2: {
                return "prepare";
            }
            case 3: {
                return "commit";
            }
            case 4: {
                return "join";
            }
            case 5: {
                return "resume";
            }
            case 6: {
                return "suspend";
            }
            case 7: {
                return "abort";
            }
        }
        return "??? " + this.m_op + " ???";
    }

    @Override
    public boolean isXonce() {
        return (this.m_flags & EXTENDED_TX_REQUEST_MASK_XONCE) == EXTENDED_TX_REQUEST_MASK_XONCE;
    }

    @Override
    public void setXonce(boolean xo) {
        this.m_flags = xo ? (short)(this.m_flags | EXTENDED_TX_REQUEST_MASK_XONCE) : (short)(this.m_flags & ~EXTENDED_TX_REQUEST_MASK_XONCE);
    }

    @Override
    public int getReplyTracking() {
        return this.m_replyTracking;
    }

    @Override
    public int getTID() {
        return this.m_tid;
    }

    @Override
    public long getClientId() {
        return this.m_clientId;
    }

    @Override
    public XidImpl getXid() {
        return this.m_xid;
    }

    @Override
    public void setReplyTracking(int replyTracking) {
        this.m_replyTracking = replyTracking;
    }

    @Override
    public void setTID(int tid) {
        this.m_tid = tid;
    }

    @Override
    public void setClientId(long clientId) {
        this.m_clientId = clientId;
    }

    @Override
    public void setXid(XidImpl xid) {
        this.m_xid = xid;
    }

    public IExtendedTXNRequestHandle getExtendedTXNRequestHandle() {
        return this;
    }

    @Override
    public String summaryString() {
        String chained = ",chained";
        if (!this.isChained()) {
            chained = "";
        }
        String xo = ",xo";
        if (!this.isXonce()) {
            xo = "";
        }
        return "tid=" + this.m_tid + ",cid=" + this.m_clientId + ",replyTracking=" + ((long)this.m_replyTracking & 0xFFFFFFFFL) + ",flags=" + this.m_flags + "(" + this.opStr() + chained + xo + ")";
    }
}

