/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IAckHandle;
import progress.message.msg.IAckListHandle;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IBrokerHandle;
import progress.message.msg.IConnectionSyncHandle;
import progress.message.msg.IErrorHandle;
import progress.message.msg.IExtendedTXNRequestHandle;
import progress.message.msg.IFailoverStatusNotificationHandle;
import progress.message.msg.IFlowControlHandle;
import progress.message.msg.IIDRHandle;
import progress.message.msg.IJMSClientHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.IOperationHandle;
import progress.message.msg.IPTPFlowControlHandle;
import progress.message.msg.IQueueFlowControlHandle;
import progress.message.msg.IReplicatedMgramHandle;
import progress.message.msg.IRoutingHandle;
import progress.message.msg.ISaverOpHandle;
import progress.message.msg.IStateEventHandle;
import progress.message.msg.ITXNRequestHandle;
import progress.message.msg.IWindowAckHandle;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v25.AckPayload;
import progress.message.msg.v25.DefaultDynamicHeader;
import progress.message.msg.v25.DefaultPayload;
import progress.message.msg.v25.DynamicHeader;
import progress.message.msg.v25.MgramCreator;
import progress.message.msg.v25.Payload;
import progress.message.msg.v25.SecureDynamicHeader;
import progress.message.msg.v25.SidebandData;
import progress.message.msg.v25.StaticHeader;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Connection;
import progress.message.zclient.CryptoInfoLinkedList;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.RejectionTracker;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

public final class Mgram
implements Cloneable,
IMgram,
IMgramConverterHandle,
IBrokerHandle,
IJMSClientHandle {
    private static final boolean DEBUG_TRACE_DATA = false;
    static final int PROTECTED_HEADER_LEN = 8;
    public static final int RRS_SEND = 0;
    public static final int RRS_REQUEST = 2;
    public static final int RRS_REPLY = 3;
    static final int AF_NONE = 0;
    static final int AF_STRING = 1;
    static final int AF_FIXED = 2;
    static final int AF_VAR = 3;
    static final int UNINITIALIZED_STATUS = 0;
    static final int STATIC_HEADER_INITIALIZED = 1;
    static final int DYNAMIC_HEADER_INITIALIZED = 2;
    static final int PAYLOAD_INITIALIZED = 3;
    static final int ID_LEN = 16;
    private int m_status = 0;
    private IMgramStatusListener m_listener = null;
    private byte[] m_staticHeader = null;
    private DynamicHeader m_dynamicHeader = null;
    private byte[] m_dynamicHeaderCache = null;
    private Payload m_payload = null;
    private byte[] m_payloadCache = null;
    private int m_dynamicHeaderMemLen = -1;
    private int m_payloadMemLen = -1;
    private boolean m_staticHeaderProtected = false;
    private long m_senderID = -1L;
    private long m_sequenceNumber;
    private Object m_logEvent;
    private boolean m_fromDb;
    private boolean m_ack_noreply;
    private int m_txnpublish_tid;
    private int m_txnpublish_tidseq;
    private boolean m_txnPublishFromLog;
    private boolean m_dbSaveRequested;
    private boolean m_dbSaved;
    private byte m_sessionVer = (byte)32;
    private boolean m_isTTE_TTL = false;
    private long m_tte = 0L;
    private IMgram m_nextInTxn;
    private boolean m_enqueuedSizeSet = false;
    private int m_enqueuedSize;
    public static final byte CURR_VERSION = 25;
    static final int s_mgramMemSize = MemoryUtil.estimateBaseSize(Mgram.class);
    private String m_localQName;
    private boolean m_targeted = false;
    private boolean m_fromRemoteBroker = false;
    private long m_redirectAckTarget = -1L;
    private LongHashTable m_proxyRecipsTable;
    private boolean m_isJMSAsynchronous = false;

    public Mgram(boolean initialize) {
        if (initialize) {
            this.m_staticHeader = StaticHeader.getDefaultByteArray();
            this.m_dynamicHeader = new DefaultDynamicHeader(this);
            this.m_payload = new DefaultPayload(this);
        }
        this.setStatus(3);
    }

    void setStatusListener(IMgramStatusListener listener) {
        this.m_listener = listener;
    }

    public void setStaticHeader(byte[] sh) {
        this.m_staticHeader = sh;
        this.m_staticHeaderProtected = false;
    }

    public void setDynamicHeader(DynamicHeader dh) {
        this.m_dynamicHeader = dh;
    }

    public void setPayload(Payload p) {
        this.m_payload = p;
        this.m_payloadCache = null;
    }

    Mgram(byte[] value) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.initMgramFromStream(new ByteArrayInputStream(value));
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        Mgram m = (Mgram)super.clone();
        if (this.m_dynamicHeader != null) {
            m.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(m);
        }
        if (this.m_payload != null) {
            m.m_payload = (Payload)this.m_payload.clone(m);
        }
        if (this.m_staticHeader != null) {
            m.m_staticHeader = new byte[this.m_staticHeader.length];
            System.arraycopy(this.m_staticHeader, 0, m.m_staticHeader, 0, this.m_staticHeader.length);
        }
        if (this.m_dynamicHeaderCache != null) {
            m.m_dynamicHeaderCache = new byte[this.m_dynamicHeaderCache.length];
            System.arraycopy(this.m_dynamicHeaderCache, 0, m.m_dynamicHeaderCache, 0, this.m_dynamicHeaderCache.length);
        }
        if (this.m_payloadCache != null) {
            m.m_payloadCache = new byte[this.m_payloadCache.length];
            System.arraycopy(this.m_payloadCache, 0, m.m_payloadCache, 0, this.m_payloadCache.length);
        }
        m.m_staticHeaderProtected = false;
        return m;
    }

    @Override
    public synchronized Object shallowClone() throws CloneNotSupportedException {
        Mgram m = (Mgram)super.clone();
        if (this.m_dynamicHeader != null) {
            m.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.shallowClone(m);
        }
        if (this.m_payload != null) {
            m.m_payload = (Payload)this.m_payload.shallowClone(m);
        }
        return m;
    }

    @Override
    public synchronized Object protectedClone() throws CloneNotSupportedException {
        Mgram m = (Mgram)super.clone();
        m.m_staticHeaderProtected = true;
        if (this.m_dynamicHeader != null) {
            m.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.protectedClone(m);
        }
        if (this.m_payload != null) {
            m.m_payload = (Payload)this.m_payload.protectedClone(m);
        }
        this.protect();
        return m;
    }

    @Override
    public synchronized void protect() {
        this.m_staticHeaderProtected = true;
        if (this.m_dynamicHeader != null) {
            this.m_dynamicHeader.protect();
        }
        if (this.m_payload != null) {
            this.m_payload.protect();
        }
    }

    private void unprotectStaticHeader() {
        if (this.m_staticHeaderProtected) {
            if (this.m_staticHeader != null) {
                byte[] staticHeader = new byte[this.m_staticHeader.length];
                System.arraycopy(this.m_staticHeader, 0, staticHeader, 0, this.m_staticHeader.length);
                this.m_staticHeader = staticHeader;
            }
            this.m_staticHeaderProtected = false;
        }
    }

    @Override
    public synchronized void unprotectSuccessor() {
        this.unprotectStaticHeader();
    }

    @Override
    public void initMgramFromStream(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.initMgramFromStream(is, null, null, null, false, null);
    }

    @Override
    public void initMgramFromStream(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert, StreamUtilCounter sc) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (sc != null) {
            sc.resetCounter();
        }
        this.initStaticHeaderFromStream(is, this.m_listener, tteTTLConvert);
        if (this.getType() == 4) {
            return;
        }
        this.initRemainingMgram(is, sis, mp, csc, sc);
    }

    public void initMgramFromStream(byte version, InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert, StreamUtilCounter sc) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (sc != null) {
            sc.resetCounter();
        }
        this.initStaticHeaderFromStream(version, is, this.m_listener, tteTTLConvert);
        if (this.getType() == 4) {
            return;
        }
        this.initRemainingMgram(is, sis, mp, csc, sc);
    }

    public void initMgramFromStreamNonSecure(byte version, InputStream is, boolean tteTTLConvert, StreamUtilCounter sc) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (sc != null) {
            sc.resetCounter();
        }
        this.initStaticHeaderFromStream(version, is, this.m_listener, tteTTLConvert);
        if (this.getType() == 4) {
            return;
        }
        this.initRemainingMgramNonSecure(is, sc);
    }

    private void initRemainingMgram(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, StreamUtilCounter sc) throws EMgramVersionMismatch, EMgramFormatError, IOException {
        boolean isSecure = StaticHeader.isSecure(this.m_staticHeader);
        this.m_dynamicHeader = Mgram.initDynamicHeaderFromStream(is, isSecure, mp, this);
        this.m_payload = Mgram.initPayloadFromStream(is, sis, mp, csc, this.m_staticHeader, this.m_dynamicHeader, this, sc);
    }

    private void initRemainingMgramNonSecure(InputStream is, StreamUtilCounter sc) throws EMgramVersionMismatch, EMgramFormatError, IOException {
        boolean isSecure = StaticHeader.isSecure(this.m_staticHeader);
        this.m_dynamicHeader = Mgram.initDynamicHeaderFromStream(is, isSecure, null, this);
        this.m_payload = Mgram.initPayloadFromStream(is, null, null, null, this.m_staticHeader, this.m_dynamicHeader, this, sc);
    }

    public void initStaticHeaderFromStream(InputStream is, IMgramStatusListener ml, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch {
        this.initStaticHeaderFromStream((byte)-1, is, ml, tteTTLConvert);
    }

    private void initStaticHeaderFromStream(byte version, InputStream is, IMgramStatusListener ml, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch {
        int offset = 0;
        this.m_staticHeader = new byte[20];
        this.readDataUpdateStatusVersion(is, ml, offset, version);
        this.validateVersion();
        if (StaticHeader.getType(this.m_staticHeader) == 4) {
            if (StaticHeader.hasSessionVer(this.m_staticHeader)) {
                this.m_sessionVer = StreamUtil.readByte(is);
            }
            return;
        }
        this.populateTTE(tteTTLConvert);
    }

    private void readDataUpdateStatusVersion(InputStream is, IMgramStatusListener ml, int offsetParam, byte version) throws IOException {
        int offset = offsetParam;
        if (version == -1) {
            if (ml != null) {
                ml.setStatus((byte)0);
            }
            StreamUtil.readBytes(is, this.m_staticHeader, offset, 1);
        }
        ++offset;
        if (ml != null) {
            ml.setStatus((byte)1);
        }
        StreamUtil.readBytes(is, this.m_staticHeader, offset, 20 - offset);
        if (version != -1) {
            StaticHeader.setVersion(version, this.m_staticHeader);
        }
    }

    private void populateTTE(boolean tteTTLConvert) {
        if (StaticHeader.hasTTE(this.m_staticHeader) && tteTTLConvert) {
            long ttl = StaticHeader.getTTE(this.m_staticHeader);
            StaticHeader.setTTE(ttl += System.currentTimeMillis(), this.m_staticHeader);
            this.m_isTTE_TTL = false;
        }
    }

    private void validateVersion() throws EMgramVersionMismatch {
        if (StaticHeader.getType(this.m_staticHeader) != 4 && StaticHeader.getVersion(this.m_staticHeader) != 25) {
            throw new EMgramVersionMismatch(StaticHeader.getVersion(this.m_staticHeader));
        }
    }

    public static DynamicHeader initDynamicHeaderFromStream(InputStream is, boolean isSecure, IMessageProtection mp, Mgram m) throws IOException, EMgramVersionMismatch {
        DynamicHeader result = null;
        if (isSecure) {
            result = new SecureDynamicHeader(m, mp);
            result.initDynamicHeaderFromStream(is);
        } else {
            result = new DefaultDynamicHeader(m);
            result.initDynamicHeaderFromStream(is);
        }
        return result;
    }

    private Payload getPayloadObject(byte type) {
        return MgramCreator.getPayloadObject(type, this);
    }

    public static Payload initPayloadFromStream(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, byte[] staticHeader, DynamicHeader dh, Mgram m, StreamUtilCounter sc) throws EMgramFormatError, IOException {
        Payload result = MgramCreator.getPayloadObject(StaticHeader.getType(staticHeader), m);
        if (StaticHeader.isSecure(staticHeader) && sis != null && mp != null && csc != null) {
            Mgram.decryptSecurePayload(is, dh, result, sis, mp, csc, sc);
            Mgram.verifyMacs(mp, csc, staticHeader, dh, result);
        } else {
            result.initPayloadFromStream(is, sc);
        }
        return result;
    }

    private static Payload decryptSecurePayload(InputStream is, DynamicHeader dh, Payload p, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, StreamUtilCounter sc) throws ESecurityGeneralException, IOException, EMgramFormatError {
        byte security = dh.getSecurity();
        if (SecurityLogic.isMKeyDigest(security) || SecurityLogic.isMKeyMacHeader(security)) {
            Mgram.populateMessageKey(dh, mp);
            if (SecurityLogic.isMKeyEncryption(security)) {
                Mgram.populateMessageKey(dh, sis);
                return Mgram.initPayLoad(dh, p, sc, sis);
            }
        } else if (SecurityLogic.isSKeyEncryption(security)) {
            return Mgram.updateInputStreamAndInitPayLoad(dh, p, sc, sis);
        }
        p.initPayloadFromStream(is, sc);
        return p;
    }

    private static Payload initPayLoad(DynamicHeader dh, Payload p, StreamUtilCounter sc, ISecureInputStream sis) throws EMgramFormatError, IOException {
        sis.bytesExpected(dh.getMessageLength() + dh.getMessagePad());
        InputStream ip = sis.getInputStream();
        p.initPayloadFromStream(ip, sc);
        return p;
    }

    private static void populateMessageKey(DynamicHeader dh, IMessageProtection mp) throws ESecurityGeneralException {
        int mKeyLen = mp.getSecretKeyLength();
        byte[] mKey = new byte[mKeyLen];
        byte[] encryptedMKey = dh.getMessageKey();
        mp.decryptWithSessionKey(encryptedMKey, 0, encryptedMKey.length, mKey, 0);
        dh.setMessageKey(mKey);
    }

    private static Payload updateInputStreamAndInitPayLoad(DynamicHeader dh, Payload p, StreamUtilCounter sc, ISecureInputStream sis) throws EMgramFormatError, IOException {
        sis.useSessionKey();
        sis.bytesExpected(dh.getMessageLength() + dh.getMessagePad());
        p.initPayloadFromStream(sis.getInputStream(), sc);
        return p;
    }

    private static void populateMessageKey(DynamicHeader dh, ISecureInputStream sis) {
        int keyLen = dh.getMessageKey().length;
        byte[] copyKey = new byte[keyLen];
        System.arraycopy(dh.getMessageKey(), 0, copyKey, 0, keyLen);
        sis.setMessageKey(copyKey);
    }

    private static void verifyMacs(IMessageProtection mp, ClientSecurityContext csc, byte[] staticHeader, DynamicHeader dh, Payload p) throws ESecurityGeneralException, EIntegrityCompromised {
        boolean verified;
        byte[] DigestKey;
        boolean verified2;
        CryptoInfoLinkedList macLinkedList = null;
        byte security = dh.getSecurity();
        if (SecurityLogic.isSKeyDigest(security) || SecurityLogic.isMKeyDigest(security)) {
            macLinkedList = Mgram.createMacInfoLinkedList(p);
        }
        if (SecurityLogic.isSKeyDigest(security) ? !(verified2 = mp.verifyMac(DigestKey = csc.getDigestKey(), 0, DigestKey.length, macLinkedList, dh.getDigest(), 0, dh.getDigest().length)) : (SecurityLogic.isMKeyDigest(security) ? !(verified = mp.verifyMac(dh.getMessageKey(), 0, dh.getMessageKey().length, macLinkedList, dh.getDigest(), 0, dh.getDigest().length)) : SecurityLogic.isMKeyMacHeader(security) && !(verified = mp.verifyMac(dh.getMessageKey(), 0, dh.getMessageKey().length, staticHeader, 0, 8, dh.getDigest(), 0, dh.getDigest().length)))) {
            throw new EIntegrityCompromised();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] calculateMac(byte[] key, IMessageProtection mp) throws ESecurityGeneralException {
        this.createPayload();
        CryptoInfoLinkedList macLinkedList = Mgram.createMacInfoLinkedList(this.m_payload);
        IMessageProtection iMessageProtection = mp;
        synchronized (iMessageProtection) {
            byte[] result = new byte[mp.getHashSize()];
            mp.mac(key, 0, key.length, macLinkedList, result, 0, result.length);
            return result;
        }
    }

    @Override
    public synchronized void recalculatePad(IMessageProtection mp) {
        this.createPayload();
        int length = this.m_payload.length();
        int newSize = mp.getOutputSize(length);
        this.createDynamicHeader();
        this.m_dynamicHeader.setMessagePad(newSize - length);
    }

    private static CryptoInfoLinkedList createMacInfoLinkedList(Payload p) {
        return p.createMacInfoLinkedList();
    }

    @Override
    public synchronized IQueueFlowControlHandle getQueueFlowControlHandle() {
        this.createPayload();
        return this.m_payload.getQueueFlowControlHandle();
    }

    @Override
    public synchronized IFlowControlHandle getFlowControlHandle() {
        this.createPayload();
        return this.m_payload.getFlowControlHandle();
    }

    @Override
    public IPTPFlowControlHandle getPTPFlowControlHandle() {
        return null;
    }

    @Override
    public IBrokerHandle getBrokerHandle() {
        return this;
    }

    @Override
    public synchronized IAckHandle getAckHandle() {
        this.createPayload();
        return this.m_payload.getAckHandle();
    }

    @Override
    public synchronized IAckListHandle getAckListHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized IWindowAckHandle getWindowAckHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized IFailoverStatusNotificationHandle getFailoverStatusNotificationHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized IIDRHandle getIDRHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized IExtendedTXNRequestHandle getExtendedTXNRequestHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized IErrorHandle getErrorHandle() {
        this.createPayload();
        return this.m_payload.getErrorHandle();
    }

    @Override
    public IRoutingHandle getRoutingHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IReplicatedMgramHandle getReplicatedMgramHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean contains(Object obj) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean supportsRouting() {
        return false;
    }

    @Override
    public boolean supportsOperationHandle() {
        return this.getType() == 25;
    }

    @Override
    public final IMgramConverterHandle getMgramConverterHandle() {
        return this;
    }

    @Override
    public final synchronized IStateEventHandle getStateEventHandle() {
        this.createPayload();
        return this.m_payload.getStateEventHandle();
    }

    @Override
    public final synchronized IMgramConverterHandle.IDynamicHeader getInternalDynamicHeader() {
        this.createDynamicHeader();
        return this.m_dynamicHeader;
    }

    @Override
    public final byte[] getInternalStaticHeader() {
        return this.m_staticHeader;
    }

    @Override
    public final synchronized IMgramConverterHandle.IPayload getInternalPayload() {
        this.createPayload();
        return this.m_payload;
    }

    @Override
    public boolean isSecure() {
        return StaticHeader.isSecure(this.m_staticHeader);
    }

    @Override
    public boolean isGuarenteed() {
        return StaticHeader.isGuarenteed(this.m_staticHeader);
    }

    @Override
    public synchronized long getGuarenteedTrackingNum() {
        this.createPayload();
        return this.m_payload.getGuarenteedTrackingNum();
    }

    @Override
    public synchronized void setSuccessor(boolean value) {
        this.unprotectStaticHeader();
        StaticHeader.setSucessor(value, this.m_staticHeader);
    }

    @Override
    public synchronized byte getSecurity() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getSecurity();
    }

    @Override
    public synchronized int getMessageLength() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getMessageLength();
    }

    @Override
    public synchronized int getBodyLength() {
        this.createPayload();
        return this.m_payload.getBodyLength();
    }

    @Override
    public synchronized int getMessagePad() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getMessagePad();
    }

    @Override
    public synchronized byte[] getMessageKey() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getMessageKey();
    }

    @Override
    public IMessageProtection getMessageProtection() {
        this.createDynamicHeader();
        return this.m_dynamicHeader.getMessageProtection();
    }

    public synchronized int getDestinationAddressFormat() {
        return StaticHeader.getDestinationAddressFormat(this.m_staticHeader);
    }

    public synchronized byte[] getDestinationAddress() {
        this.createPayload();
        return this.m_payload.getDestinationAddress();
    }

    public synchronized void setDestinationAddress(byte[] address, int daf) {
        this.setDestinationAddressFormat(daf);
        this.createPayload();
        this.m_payload.setDestinationAddress(address);
    }

    synchronized void setDestinationAddressFormat(int daf) {
        this.unprotectStaticHeader();
        StaticHeader.setDestinationAddressFormat(daf, this.m_staticHeader);
    }

    @Override
    public int getRequestReplyFieldType() {
        return StaticHeader.getRequestReplyFieldType(this.m_staticHeader);
    }

    @Override
    public byte getType() {
        return StaticHeader.getType(this.m_staticHeader);
    }

    @Override
    public synchronized void setType(byte type) {
        this.unprotectStaticHeader();
        StaticHeader.setType(type, this.m_staticHeader);
    }

    @Override
    public synchronized void sync() {
        this.unprotectStaticHeader();
        if (this.m_dynamicHeader != null) {
            this.m_dynamicHeader.sync();
        }
        if (this.m_payload != null) {
            this.m_payload.sync();
        }
    }

    @Override
    public boolean hasTxn() {
        return StaticHeader.hasTxn(this.m_staticHeader);
    }

    @Override
    public synchronized int getChannel() {
        return StaticHeader.getChannel(this.m_staticHeader);
    }

    @Override
    public synchronized void setChannel(int channel) {
        this.unprotectStaticHeader();
        StaticHeader.setChannel(channel, this.m_staticHeader);
    }

    @Override
    public boolean isPostSV22() {
        return StaticHeader.isPostSV22(this.m_staticHeader);
    }

    @Override
    public boolean hasSessionVer() {
        return StaticHeader.hasSessionVer(this.m_staticHeader);
    }

    @Override
    public synchronized void setSessionVer(byte version) {
        this.m_sessionVer = version;
        StaticHeader.setSessionVer(version, this.m_staticHeader);
    }

    @Override
    public void setSenderID(long id) {
        this.m_senderID = id;
    }

    @Override
    public long getSenderID() {
        return this.m_senderID;
    }

    @Override
    public boolean isTargeted() {
        return this.m_targeted;
    }

    @Override
    public void setTargeted(boolean val) {
        this.m_targeted = val;
    }

    @Override
    public void setRedirectAckTarget(long clientId) {
        this.m_redirectAckTarget = clientId;
    }

    @Override
    public long getRedirectAckTarget() {
        return this.m_redirectAckTarget;
    }

    @Override
    public void setProxyRecipsTable(LongHashTable table) {
        this.m_proxyRecipsTable = table;
    }

    @Override
    public LongHashTable getProxyRecipsTable() {
        return this.m_proxyRecipsTable;
    }

    @Override
    public void setAckNoReply(boolean value) {
        this.m_ack_noreply = value;
    }

    @Override
    public boolean isAckNoReply() {
        return this.m_ack_noreply;
    }

    @Override
    public boolean isFromDB() {
        return this.m_fromDb;
    }

    @Override
    public void setFromDB(boolean value) {
        this.m_fromDb = value;
    }

    @Override
    public boolean isDBSaveRequested() {
        return this.m_dbSaveRequested;
    }

    @Override
    public void setDBSaveRequested(boolean value) {
        this.m_dbSaveRequested = value;
    }

    @Override
    public boolean wasDBSaved() {
        return this.m_dbSaved;
    }

    @Override
    public void setDBSaved(boolean value) {
        this.m_dbSaved = value;
    }

    @Override
    public void addMsgHeaderSaved(long cid) {
    }

    @Override
    public void addMsgHeadersSaved(long[] cids) {
    }

    @Override
    public boolean isMsgHeaderSaved(long cid) {
        return false;
    }

    @Override
    public void clearMsgHeader(long cid) {
    }

    @Override
    public void setLocalQueueName(String name) {
        this.m_localQName = name;
    }

    @Override
    public String getLocalQueueName() {
        return this.m_localQName;
    }

    @Override
    public boolean isQueueMessage() {
        return this.m_localQName != null;
    }

    @Override
    public boolean isReply() {
        return StaticHeader.isReply(this.m_staticHeader);
    }

    @Override
    public boolean isRequest() {
        return StaticHeader.isRequest(this.m_staticHeader);
    }

    @Override
    public boolean isSend() {
        return StaticHeader.isSend(this.m_staticHeader);
    }

    @Override
    public byte getPriority() {
        return StaticHeader.getPriority(this.m_staticHeader);
    }

    public synchronized byte[] getPayload() {
        if (this.m_payload != null) {
            return this.m_payload.toByteArray();
        }
        if (this.m_payloadCache != null) {
            return this.m_payloadCache;
        }
        return null;
    }

    public synchronized byte[] getDynamicHeader() {
        if (this.m_dynamicHeader != null) {
            return this.m_dynamicHeader.toByteArray();
        }
        if (this.m_dynamicHeaderCache != null) {
            return this.m_dynamicHeaderCache;
        }
        return null;
    }

    @Override
    public int getRouteLimit() {
        return StaticHeader.getRouteLimit(this.m_staticHeader);
    }

    @Override
    public synchronized void setRouteLimit(int routeLimit) {
        this.unprotectStaticHeader();
        StaticHeader.setRouteLimit(routeLimit, this.m_staticHeader);
    }

    @Override
    public boolean isSuccessor() {
        return StaticHeader.isSucessor(this.m_staticHeader);
    }

    @Override
    public boolean isJMSPersistent() {
        return StaticHeader.isJMSPersistent(this.m_staticHeader);
    }

    @Override
    public boolean isPubSub() {
        return this.getType() == 2;
    }

    @Override
    public boolean isPTP() {
        return this.getType() == 12;
    }

    @Override
    public synchronized int getReplyPriority() {
        this.createPayload();
        return this.m_payload.getReplyPriority();
    }

    @Override
    public synchronized void setReplyPriority(int priority) {
        this.createPayload();
        this.m_payload.setReplyPriority(priority);
    }

    @Override
    public boolean isTTE() {
        return StaticHeader.hasTTE(this.m_staticHeader);
    }

    @Override
    public synchronized long getTTE() {
        this.convertTTE();
        return this.m_tte;
    }

    private synchronized void convertTTE() {
        boolean hasTTE = StaticHeader.hasTTE(this.m_staticHeader);
        if (hasTTE && this.m_tte == 0L || hasTTE && this.m_isTTE_TTL) {
            this.m_tte = StaticHeader.getTTE(this.m_staticHeader);
            if (this.m_isTTE_TTL) {
                this.m_tte = System.currentTimeMillis() + this.m_tte;
                this.m_isTTE_TTL = false;
                StaticHeader.setTTE(this.m_tte, this.m_staticHeader);
            }
        }
    }

    public void setTTE_TTL(boolean value) {
        this.m_isTTE_TTL = value;
    }

    @Override
    public synchronized void setTTE(long time) {
        this.unprotectStaticHeader();
        StaticHeader.setTTE(time, this.m_staticHeader);
        this.m_tte = time;
        this.m_isTTE_TTL = false;
    }

    @Override
    public synchronized void removeTTE() {
        this.unprotectStaticHeader();
        StaticHeader.enableTTE(false, this.m_staticHeader);
        this.m_tte = 0L;
    }

    @Override
    public synchronized void setDiscardable(boolean value) {
        this.unprotectStaticHeader();
        StaticHeader.setDiscardable(value, this.m_staticHeader);
    }

    @Override
    public boolean isDiscardable() {
        return StaticHeader.isDiscardable(this.m_staticHeader);
    }

    @Override
    public final void setRejectable(boolean rejectable) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public final synchronized void setInstrumented(boolean instrumented) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public final synchronized boolean isInstrumented() {
        return false;
    }

    @Override
    public final boolean isRejectable() {
        return false;
    }

    @Override
    public synchronized void setJMSPersistent(boolean value) {
        this.unprotectStaticHeader();
        StaticHeader.setJMSPersistent(value, this.m_staticHeader);
    }

    @Override
    public synchronized void setSecurityAttribute(byte value) {
        this.createDynamicHeader();
        this.m_dynamicHeader.setSecurityAttributeByte(value);
    }

    @Override
    public synchronized void setMgramSecure(IMessageProtection mp) {
        this.unprotectStaticHeader();
        this.createDynamicHeader();
        StaticHeader.setMgramSecure(true, this.m_staticHeader);
        this.createDynamicHeader();
        this.m_dynamicHeader = this.m_dynamicHeader.getSecureDynamicHeader(mp);
    }

    @Override
    public synchronized void setMessageKey(byte[] messageKey) {
        this.createDynamicHeader();
        this.m_dynamicHeader.setMessageKey(messageKey);
    }

    @Override
    public synchronized void setMgramNonSecure() {
        this.unprotectStaticHeader();
        this.createDynamicHeader();
        StaticHeader.setMgramSecure(false, this.m_staticHeader);
        this.createDynamicHeader();
        this.m_dynamicHeader = this.m_dynamicHeader.getNonSecureDynamicHeader();
    }

    @Override
    public synchronized void setPriority(byte value) {
        this.unprotectStaticHeader();
        StaticHeader.setPriority(value, this.m_staticHeader);
    }

    @Override
    public synchronized boolean hasSubject() {
        this.createPayload();
        return this.m_payload.hasSubject();
    }

    @Override
    public synchronized ISubject getSubject() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int getSubjectFormat() {
        return StaticHeader.getDestinationAddressFormat(this.m_staticHeader);
    }

    synchronized String getSubjectString() {
        this.createPayload();
        return this.m_payload.getSubject();
    }

    public synchronized void setSubject(String subject) {
        this.createPayload();
        this.m_payload.setSubject(subject);
    }

    public synchronized void setSubject(String subject, int format) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized boolean hasBody() {
        this.createPayload();
        return this.m_payload.hasBody();
    }

    @Override
    public void setBody(byte[] body) {
        if (body != null) {
            this.setBody(body, body.length);
        } else {
            this.setBody(body, 0);
        }
    }

    @Override
    public synchronized void setBody(byte[] body, int length) {
        this.createPayload();
        this.m_payload.setBody(body, length);
    }

    @Override
    public synchronized int getPayloadLength() {
        if (this.m_payload == null) {
            return this.m_payloadCache.length;
        }
        return this.m_payload.length();
    }

    @Override
    public synchronized void setSidebandData(ISidebandData sd) {
        this.createPayload();
        this.m_payload.setSidebandData(sd);
    }

    @Override
    public synchronized ISidebandData getSidebandData() {
        this.createPayload();
        return this.m_payload.getSidebandData();
    }

    @Override
    public ISidebandData getSidebandDataReadOnly() {
        return this.getSidebandData();
    }

    @Override
    public synchronized boolean hasSidebandData() {
        this.createPayload();
        return this.m_payload.hasSidebandData();
    }

    @Override
    public synchronized void createSidebandDataIfNeeded() {
        this.createPayload();
        this.m_payload.createSidebandDataIfNeeded();
    }

    @Override
    public synchronized String getRouting() {
        SidebandData sd = (SidebandData)this.getSidebandData();
        if (sd != null) {
            return sd.getRouting();
        }
        return null;
    }

    @Override
    public synchronized boolean forRemoteNode(String localNodeName) {
        String node = this.getRouting();
        return node != null && !node.equals(localNodeName) && !node.equals("");
    }

    @Override
    public String getCorrectedRemoteNode(String localNodeName) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized byte[] getRawBody() {
        this.createPayload();
        return this.m_payload.getRawBodyBuffer();
    }

    @Override
    public boolean hasID() {
        return StaticHeader.hasID(this.m_staticHeader);
    }

    @Override
    public synchronized void setID(byte[] value) {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.enableID(this.m_staticHeader);
        this.m_payload.setID(value);
    }

    @Override
    public synchronized byte[] getID() {
        this.createPayload();
        return this.m_payload.getID();
    }

    @Override
    public synchronized long getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    @Override
    public void setSequenceNumber(long sequence_number) {
        this.m_sequenceNumber = sequence_number;
    }

    @Override
    public synchronized void clearID() {
        this.createPayload();
        this.m_payload.clearID();
    }

    public synchronized void clearAddresses() {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.clearAddresses(this.m_staticHeader);
        this.m_payload.clearAddresses();
    }

    @Override
    public synchronized void setRequestReplySend() {
        this.unprotectStaticHeader();
        StaticHeader.setRequestReplyType(0, this.m_staticHeader);
    }

    @Override
    public synchronized void setRequestReplyReply() {
        this.unprotectStaticHeader();
        StaticHeader.setRequestReplyType(3, this.m_staticHeader);
    }

    @Override
    public synchronized void setGuarenteed(long tracking) {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.setGuarenteed(true, this.m_staticHeader);
        this.m_payload.setGuarenteed(tracking);
    }

    @Override
    public synchronized void setReliable() {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.setGuarenteed(false, this.m_staticHeader);
        this.m_payload.setGuarenteed(0L);
    }

    @Override
    public synchronized void setTxn(int tid) {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.setTxn(true, this.m_staticHeader);
        this.m_payload.setTxn(tid);
    }

    @Override
    public synchronized void setTxnPublish(int tid, int txnseq) {
        this.unprotectStaticHeader();
        StaticHeader.setTxnPublish(true, this.m_staticHeader);
        this.m_txnpublish_tid = tid;
        this.m_txnpublish_tidseq = txnseq;
    }

    @Override
    public int getTxnPublishTid() {
        return this.m_txnpublish_tid;
    }

    @Override
    public int getTxnPublishTidSeqNo() {
        return this.m_txnpublish_tidseq;
    }

    @Override
    public synchronized int getTxnId() {
        this.createPayload();
        return this.m_payload.getTxnId();
    }

    @Override
    public synchronized void removeTxn() {
        this.unprotectStaticHeader();
        this.createPayload();
        StaticHeader.setTxn(false, this.m_staticHeader);
        this.m_payload.removeTxn();
    }

    @Override
    public synchronized void setRequest(long tracking, String subject) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized int memoryLength() {
        boolean isDHDirty = false;
        boolean isPayloadDirty = false;
        if (this.m_dynamicHeader != null) {
            isDHDirty = this.m_dynamicHeader.isDirty();
        }
        if (this.m_payload != null) {
            isPayloadDirty = this.m_payload.isDirty();
        }
        this.populateHeaderMemLen(isDHDirty);
        this.populatePayloadMemLen(isPayloadDirty);
        return this.calculateSize();
    }

    private int calculateSize() {
        LinkedList ll;
        int operationLength = 0;
        if (this.getType() == 25 && (ll = this.getOperationHandle().getMgramList()) != null) {
            for (int count = 0; count < ll.size(); ++count) {
                operationLength += ((IMgram)ll.get(count)).memoryLength();
            }
        }
        int result = s_mgramMemSize + 20 + this.m_dynamicHeaderMemLen + this.m_payloadMemLen + operationLength;
        return result;
    }

    private void populateHeaderMemLen(boolean isDHDirty) {
        this.sync();
        if (this.m_dynamicHeader != null && (isDHDirty || this.m_dynamicHeaderMemLen == -1)) {
            this.m_dynamicHeaderMemLen = this.m_dynamicHeader.memoryLength();
        } else if (this.m_dynamicHeaderMemLen == -1 && this.m_dynamicHeaderCache != null) {
            this.m_dynamicHeaderMemLen = this.m_dynamicHeaderCache.length;
        }
    }

    private void populatePayloadMemLen(boolean isPayloadDirty) {
        if (this.m_payload != null && (isPayloadDirty || this.m_payloadMemLen == -1)) {
            this.m_payloadMemLen = this.m_payload.memoryLength();
        } else if (this.m_payloadMemLen == -1 && this.m_payloadCache != null) {
            this.m_payloadMemLen = this.m_payloadCache.length;
        }
    }

    @Override
    public void saveMemory() {
    }

    @Override
    public synchronized int networkLength() {
        LinkedList ll;
        int result = 20 + (this.m_dynamicHeader != null ? this.m_dynamicHeader.length() : this.m_dynamicHeaderCache.length) + (this.m_payload != null ? this.m_payload.length() : this.m_payloadCache.length);
        int operationLength = 0;
        if (this.getType() == 25 && (ll = this.getOperationHandle().getMgramList()) != null) {
            for (int count = 0; count < ll.size(); ++count) {
                operationLength += ((IMgram)ll.get(count)).networkLength();
            }
        }
        return result + operationLength;
    }

    @Override
    public synchronized void macMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.createDynamicHeader();
        byte[] messageKey = this.m_dynamicHeader.getMessageKey();
        byte[] result = this.calculateMac(messageKey, mp);
        this.m_dynamicHeader.setMessageDigest(result);
    }

    @Override
    public ISubject getReplySubject() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public synchronized byte[] getReplyToAddress() {
        this.createPayload();
        return this.m_payload.getReplyToAddress();
    }

    public synchronized int getReplyToAddressFormat() {
        this.createPayload();
        return this.m_payload.getReplyToAddressFormat();
    }

    public synchronized void setReplyToAddressFormat(int type) {
        this.createPayload();
        this.m_payload.setReplyToAddressFormat(type);
    }

    public synchronized String getReplyToAddressString() {
        this.createPayload();
        return this.m_payload.getReplyToAddressString();
    }

    public synchronized void setReplyToString(String value) {
        this.createPayload();
        this.m_payload.setReplyToString(value);
    }

    @Override
    public synchronized void setReply(IMgram nm) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized void setRequestReplyType(int type) {
        this.unprotectStaticHeader();
        StaticHeader.setRequestReplyType(type, this.m_staticHeader);
    }

    @Override
    public synchronized int getReplyTracking() throws ENoTrackingNum {
        this.createPayload();
        if (!StaticHeader.canHaveReplyTracking(this.m_staticHeader) || !this.m_payload.canHaveReplyTracking()) {
            throw new ENoTrackingNum();
        }
        byte[] address = this.m_payload.getDestinationAddress();
        int p = address.length - 4;
        return ArrayUtil.readInt(address, p);
    }

    public synchronized int getReplyToAddressTracking() {
        this.createPayload();
        byte[] address = this.m_payload.getReplyToAddress();
        int p = address.length - 4;
        return ArrayUtil.readInt(address, p);
    }

    @Override
    public int getReplyFormat() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setReplyFormat(int format) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void writeMgramToNetworkStream(OutputStream os, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        this.writeMgramToStream(os, csc, sos, mp, true);
    }

    @Override
    public void writeMgramToNetworkStream(OutputStream os, int channel, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        this.writeMgramToStream(os, channel, csc, sos, mp, true);
    }

    @Override
    public void writeMgramToStream(OutputStream os) throws IOException {
        this.writeMgramToStream(os, null, null, null, false);
    }

    @Override
    public void writeMgramToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeMgramToStream(os, null, null, null, tteTTLConvert);
    }

    @Override
    public void writeMgramToStream(OutputStream os, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, boolean tteTTLConvert) throws IOException {
        this.writeMgramToStream(os, -1, csc, sos, mp, tteTTLConvert);
    }

    public void writeMgramToStream(OutputStream os, int channel, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, boolean tteTTLConvert) throws IOException {
        this.writeStaticHeaderToStream(os, channel, tteTTLConvert);
        if (this.m_staticHeader != null && StaticHeader.getType(this.m_staticHeader) == 4) {
            return;
        }
        this.writeDynamicHeaderToStream(os, csc, mp, null);
        this.writePayloadToStream(os, sos);
    }

    @Override
    public void writeMgramToStreamNonSecure(OutputStream os, boolean tteTTLConvert, MgramDeliveryContext ctx) throws IOException {
        this.writeStaticHeaderToStream(os, -1, tteTTLConvert);
        if (this.m_staticHeader != null && StaticHeader.getType(this.m_staticHeader) == 4) {
            return;
        }
        this.writeDynamicHeaderToStream(os, null, null, ctx);
        if (this.isSecure()) {
            this.m_dynamicHeader.setMessagePad(0);
        }
        this.writePayloadToStream(os, null);
    }

    @Override
    public void writeMgramToNetworkStreamNonSecure(OutputStream os, int channel, boolean tteTTLConvert, MgramDeliveryContext ctx) throws IOException {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void writeStaticHeaderToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeStaticHeaderToStream(os, -1, tteTTLConvert);
    }

    public void writeStaticHeaderToStream(OutputStream os, int channel, boolean tteTTLConvert) throws IOException {
        this.convertTTE();
        StaticHeader.writeToStream(os, this.m_staticHeader, channel, tteTTLConvert);
        if (this.getType() == 4 && StaticHeader.hasSessionVer(this.m_staticHeader)) {
            os.write(this.m_sessionVer);
        }
    }

    @Override
    public void writeDynamicHeaderToStream(OutputStream os, ClientSecurityContext csc, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        byte[] digestKey = csc == null ? null : csc.getDigestKey();
        this.writeDynamicHeaderToStream(os, digestKey, mp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDynamicHeaderToStream(OutputStream os, byte[] digestKey, IMessageProtection mp) throws IOException {
        if (this.isSecure() && mp != null) {
            this.createDynamicHeader();
            if (SecurityLogic.isSKeyDigest(this.getSecurity())) {
                byte[] mac = this.calculateMac(digestKey, mp);
                this.m_dynamicHeader.setMessageDigest(mac);
            }
            this.recalculatePad(mp);
            this.m_dynamicHeader.writeToStream(os, mp);
        } else {
            byte[] dhCache;
            DynamicHeader dh;
            Mgram mgram = this;
            synchronized (mgram) {
                dh = this.m_dynamicHeader;
                dhCache = this.m_dynamicHeaderCache;
            }
            if (dh != null) {
                dh.writeToStream(os);
            } else {
                os.write(dhCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePayloadToStream(OutputStream os, ISecureOutputStream sos) throws IOException {
        if (this.isSecure()) {
            this.createPayload();
            if (SecurityLogic.isSKeyEncryption(this.getSecurity()) && sos != null) {
                OutputStream ios = sos.getOutputStream();
                this.m_payload.writeToStream(ios);
                ios.flush();
            } else {
                this.m_payload.writeToStream(os);
            }
        } else {
            byte[] payloadCache;
            Payload payload;
            Mgram mgram = this;
            synchronized (mgram) {
                payload = this.m_payload;
                payloadCache = this.m_payloadCache;
            }
            if (payload != null) {
                payload.writeToStream(os);
            } else {
                os.write(payloadCache);
            }
        }
    }

    @Override
    public synchronized int serializedLength() {
        this.sync();
        this.createDynamicHeader();
        this.createPayload();
        int result = this.calcSerializedHeaderLength();
        result += this.isEncrypted() ? this.calcEncryptedSerializedLength() : this.calcUnencryptedSerializedLength();
        result += this.isTransactionalPublish() ? 8 : 0;
        return result += this.isEnqueuedSizeSet() ? 4 : 0;
    }

    private int calcSerializedHeaderLength() {
        int result = 4 + this.m_staticHeader.length + this.m_dynamicHeader.length();
        if (this.isSecure()) {
            result += 4;
        }
        return result;
    }

    private int calcEncryptedSerializedLength() {
        int result = 24 + StringUtil.lengthUTF(this.getSubjectString()) + (this.isGuarenteed() ? 8 : 0) + (this.getSidebandData() == null ? 4 : this.m_payload.getSidebandData().getSerializedLength() * 2 + 4 + 4) + 4 + this.m_payload.getPreBodyLength() + 4 + this.m_payload.getBodyLength() + 4 + (this.m_payload.getPadBuffer() == null ? 0 : this.m_payload.getPadBuffer().length);
        return result;
    }

    private int calcUnencryptedSerializedLength() {
        int result = this.m_payload.length();
        if (this.isSecure()) {
            result += this.getMessagePad();
        }
        return result;
    }

    @Override
    public synchronized void serialize(OutputStream os, boolean tteTTLConvert) throws IOException {
        int pad = this.writeData2(os);
        if (this.m_payload.isEncrypted()) {
            this.writeData3(os);
            this.writeData(os);
            this.writeData(os, pad);
            return;
        }
        this.writeData4(os);
    }

    private void writeData(OutputStream os) throws IOException {
        byte[] buffer;
        ISidebandData sidebandData = this.m_payload.getSidebandData();
        if (sidebandData != null) {
            buffer = sidebandData.getNewByteArray();
            int bufferLength = ArrayUtil.readInt(buffer, 0);
            StreamUtil.writeInt(bufferLength, os);
            os.write(buffer, 0, bufferLength);
            buffer = this.m_payload.getRawSidebandBuffer();
            int length = this.m_payload.getSidebandData().getSerializedLength();
            StreamUtil.writeInt(length, os);
            os.write(buffer, 0, length);
        } else {
            StreamUtil.writeInt(-1, os);
        }
        buffer = this.m_payload.getRawPreBody();
        StreamUtil.writeInt(this.m_payload.getPreBodyLength(), os);
        os.write(buffer);
        if (this.m_payload.hasBody()) {
            buffer = this.m_payload.getRawBodyBuffer();
            StreamUtil.writeInt(this.m_payload.getBodyLength(), os);
            os.write(buffer);
        } else {
            StreamUtil.writeInt(0, os);
        }
    }

    private int writeData2(OutputStream os) throws IOException {
        this.createDynamicHeader();
        this.createPayload();
        this.sync();
        os.write(25);
        StreamUtil.writeBoolean(this.isSecure(), os);
        StreamUtil.writeBoolean(this.m_payload.isEncrypted(), os);
        StreamUtil.writeBoolean(this.isEnqueuedSizeSet(), os);
        if (this.isEnqueuedSizeSet()) {
            StreamUtil.writeInt(this.m_enqueuedSize, os);
        }
        int pad = 0;
        if (this.isSecure()) {
            pad = this.getMessagePad();
            StreamUtil.writeInt(pad, os);
        }
        os.write(this.m_staticHeader);
        this.m_dynamicHeader.writeToStream(os, null);
        return pad;
    }

    private void writeData3(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.getSenderID(), os);
        StreamUtil.writeLong(this.getSequenceNumber(), os);
        StreamUtil.writeInt(this.getReplyToAddressFormat(), os);
        StreamUtil.writeInt(this.getReplyPriority(), os);
        StreamUtil.writeUTF(this.getSubjectString(), os);
        if (this.isGuarenteed()) {
            StreamUtil.writeLong(this.getGuarenteedTrackingNum(), os);
        }
    }

    private void writeData(OutputStream os, int pad) throws IOException {
        if (pad > 0) {
            os.write(this.m_payload.getPadBuffer(), 0, pad);
        }
        this.checkAndWriteData(os);
    }

    private void writeData4(OutputStream os) throws IOException {
        this.m_payload.writeToStream(os);
        this.checkAndWriteData(os);
    }

    private void checkAndWriteData(OutputStream os) throws IOException {
        if (this.isTransactionalPublish()) {
            StreamUtil.writeInt(this.getTxnPublishTid(), os);
            StreamUtil.writeInt(this.getTxnPublishTidSeqNo(), os);
        }
    }

    public static IMgram unserialize(InputStream is) throws IOException {
        Mgram result = new Mgram(false);
        try {
            boolean isSecure = StreamUtil.readBoolean(is);
            boolean isEncrypted = StreamUtil.readBoolean(is);
            int pad = Mgram.readData(is, isSecure, result);
            Payload payload = Mgram.initDynamicHeaderAndRetrievePayload(is, isSecure, pad, result);
            if (isEncrypted) {
                DefaultPayload dp = Mgram.retrieveDefaultPayloadPopulateMgram(is, payload, result);
                int bufferLength = Mgram.populateSideBand(dp, is, result);
                Mgram.populatePayloadBodyAndSetEncrypted(bufferLength, dp, is, pad, payload);
            } else {
                payload.initPayloadFromStream(is);
            }
            Mgram.populateTxnPublishAndTTE_TTL(is, result);
        }
        catch (EMgramVersionMismatch e) {
            e.printStackTrace();
        }
        catch (EMgramFormatError e) {
            e.printStackTrace();
        }
        return result;
    }

    private static int populateSideBand(DefaultPayload dp, InputStream is, Mgram result) throws IOException {
        int bufferLength = StreamUtil.readInt(is);
        if (bufferLength != -1) {
            byte[] sidebandBytes = new byte[bufferLength];
            StreamUtil.readBytes(is, sidebandBytes, 0, bufferLength);
            SidebandData sidebandData = new SidebandData();
            sidebandData.fromByteArray(sidebandBytes, 0);
            result.setSidebandData(sidebandData);
            bufferLength = StreamUtil.readInt(is);
            sidebandBytes = new byte[bufferLength];
            StreamUtil.readBytes(is, sidebandBytes, 0, bufferLength);
            dp.setSidebandBuffer(sidebandBytes);
        }
        bufferLength = StreamUtil.readInt(is);
        byte[] preBodyBuffer = new byte[bufferLength];
        StreamUtil.readBytes(is, preBodyBuffer, 0, bufferLength);
        dp.setPreBodyBuffer(preBodyBuffer);
        return StreamUtil.readInt(is);
    }

    private static Payload initDynamicHeaderAndRetrievePayload(InputStream is, boolean isSecure, int pad, Mgram result) throws IOException, EMgramVersionMismatch {
        DynamicHeader dh = new DefaultDynamicHeader(result);
        if (isSecure) {
            dh = dh.getSecureDynamicHeader(null);
            dh.setMessagePad(pad);
        }
        result.setDynamicHeader(dh);
        result.initStaticHeaderFromStream(is, null, false);
        dh.initDynamicHeaderFromStream(is);
        byte type = result.getType();
        Payload payload = null;
        switch (type) {
            case 3: 
            case 14: {
                payload = new AckPayload(result);
                break;
            }
            default: {
                payload = new DefaultPayload(result);
            }
        }
        result.setPayload(payload);
        return payload;
    }

    private static void populatePayloadBodyAndSetEncrypted(int bufferLength, DefaultPayload dp, InputStream is, int pad, Payload payload) throws IOException {
        byte[] body = null;
        if (bufferLength > 0) {
            body = new byte[bufferLength];
            StreamUtil.readBytes(is, body, 0, bufferLength);
        }
        payload.setBody(body, bufferLength);
        if (pad > 0) {
            byte[] padArray = new byte[pad];
            StreamUtil.readBytes(is, padArray, 0, pad);
            dp.setPadBuffer(padArray);
        }
        dp.setEncrypted();
    }

    private static DefaultPayload retrieveDefaultPayloadPopulateMgram(InputStream is, Payload payload, Mgram result) throws IOException {
        DefaultPayload dp = (DefaultPayload)payload;
        result.setSenderID(StreamUtil.readLong(is));
        result.setSequenceNumber(StreamUtil.readLong(is));
        result.setReplyToAddressFormat(StreamUtil.readInt(is));
        result.setReplyPriority(StreamUtil.readInt(is));
        result.setSubject(StreamUtil.readUTF(is));
        if (result.isGuarenteed()) {
            result.setGuarenteed(StreamUtil.readLong(is));
        }
        return dp;
    }

    private static int readData(InputStream is, boolean isSecure, Mgram result) throws IOException {
        boolean isEnqueuedSizeSet = StreamUtil.readBoolean(is);
        if (isEnqueuedSizeSet) {
            result.setEnqueuedSize(StreamUtil.readInt(is));
        }
        int pad = 0;
        if (isSecure) {
            pad = StreamUtil.readInt(is);
        }
        return pad;
    }

    private static void populateTxnPublishAndTTE_TTL(InputStream is, Mgram result) throws IOException {
        if (result.isTransactionalPublish()) {
            result.setTxnPublish(StreamUtil.readInt(is), StreamUtil.readInt(is));
        }
        result.setTTE_TTL(false);
    }

    @Override
    public synchronized byte[] toByteArray() {
        this.createDynamicHeader();
        this.createPayload();
        byte[] staticHeader = this.m_staticHeader;
        byte[] dynamicHeader = this.m_dynamicHeader.toByteArray();
        byte[] payload = this.m_payload.toByteArray();
        int staticLength = staticHeader.length;
        int dynamicLength = dynamicHeader.length;
        int payloadLength = payload.length;
        int totalLength = staticLength + dynamicLength + payloadLength;
        byte[] newByteArray = new byte[totalLength];
        System.arraycopy(staticHeader, 0, newByteArray, 0, staticLength);
        System.arraycopy(dynamicHeader, 0, newByteArray, staticLength, dynamicLength);
        System.arraycopy(payload, 0, newByteArray, staticLength + dynamicLength, payloadLength);
        return newByteArray;
    }

    @Override
    public byte getVersion() {
        return StaticHeader.getVersion(this.m_staticHeader);
    }

    @Override
    public byte getSessionVersion() {
        return this.m_sessionVer;
    }

    public void setPostV22() {
        StaticHeader.setPostV22(true, this.m_staticHeader);
    }

    @Override
    public Object getLogEvent() {
        return this.m_logEvent;
    }

    @Override
    public void setLogEvent(Object event) {
        this.m_logEvent = event;
    }

    @Override
    public boolean isFromLog() {
        return this.m_logEvent != null;
    }

    synchronized void setVersion(byte version) {
        this.unprotectStaticHeader();
        StaticHeader.setVersion(version, this.m_staticHeader);
    }

    @Override
    public void setStatus(int value) {
        this.m_status = value;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    public void setDynamicHeaderCache(byte[] cache) {
        this.m_dynamicHeaderCache = cache;
    }

    public void setPayloadCache(byte[] cache) {
        this.m_payloadCache = cache;
    }

    synchronized void createDynamicHeader() {
        if (this.m_dynamicHeader == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.m_dynamicHeaderCache);
            if (this.isSecure()) {
                throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
            }
            this.m_dynamicHeader = new DefaultDynamicHeader(this);
            try {
                this.m_dynamicHeader.initDynamicHeaderFromStream(bis);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_dynamicHeader.sync();
            this.m_dynamicHeaderCache = null;
        }
    }

    synchronized void createPayload() {
        if (this.m_payload == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.m_payloadCache);
            this.m_payload = this.getPayloadObject(this.getType());
            try {
                this.m_payload.initPayloadFromStream(bis);
            }
            catch (EMgramFormatError e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_payload.sync();
            this.m_payloadCache = null;
        }
    }

    @Override
    public boolean isFromRemoteBroker() {
        return this.m_fromRemoteBroker;
    }

    @Override
    public void setFromRemoteBroker(boolean fromRemoteBroker) {
        this.m_fromRemoteBroker = fromRemoteBroker;
    }

    @Override
    public synchronized void clearTransactionPublish() {
        this.unprotectStaticHeader();
        StaticHeader.setTxnPublish(false, this.m_staticHeader);
    }

    @Override
    public boolean isTransactionalPublish() {
        return StaticHeader.isTxnPublish(this.m_staticHeader);
    }

    @Override
    public boolean isTxnPublishFromLog() {
        return this.m_txnPublishFromLog;
    }

    @Override
    public void setTxnPublishFromLog(boolean value) {
        this.m_txnPublishFromLog = value;
    }

    @Override
    public void setBatchedPublish(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isBatchedPublish() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setBatchId(long value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public long getBatchId() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized void placeMessageKey(IMessageProtection mp, byte[] tempBuffer) {
        ProgressSecureRandom.theSecureRandom().nextBytes(tempBuffer);
        byte[] mk = new byte[mp.getSecretKeyLength()];
        System.arraycopy(tempBuffer, 0, mk, 0, mp.getSecretKeyLength());
        this.setMessageKey(mk);
    }

    @Override
    public synchronized void macHeaderWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.createDynamicHeader();
        byte[] header = this.m_staticHeader;
        byte[] messageKey = this.m_dynamicHeader.getMessageKey();
        byte[] result = this.macByteArray(header, 8, messageKey, messageKey.length, mp);
        this.m_dynamicHeader.setMessageDigest(result);
    }

    @Override
    public synchronized byte[] macByteArray(byte[] buffer, int bufferLength, byte[] key, int keyLength, IMessageProtection mp) throws ESecurityGeneralException {
        int macLength = mp.getHashSize();
        byte[] result = new byte[macLength];
        mp.mac(key, 0, keyLength, buffer, 0, bufferLength, result, 0, macLength);
        return result;
    }

    @Override
    public boolean isTxnEOFMarker() {
        return this.getType() == -2;
    }

    @Override
    public boolean isTxnSavePointMarker() {
        return this.getType() == -3;
    }

    @Override
    public synchronized boolean isEncrypted() {
        this.createPayload();
        return this.m_payload.isEncrypted();
    }

    @Override
    public synchronized void encryptMessageKey(byte[] buffer, IMessageProtection mp) throws ESecurityGeneralException {
        System.arraycopy(this.getMessageKey(), 0, buffer, 0, this.getMessageKey().length);
        mp.encryptWithSessionKey(buffer, 0, this.getMessageKey().length, buffer, 0);
    }

    @Override
    public synchronized void encryptMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.createPayload();
        this.m_payload.encryptMessageWithMessageKey(mp);
    }

    @Override
    public synchronized void decryptMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.createPayload();
        this.m_payload.decryptMessageWithMessageKey(mp);
    }

    @Override
    public void setNextInTxn(IMgram m) {
        this.m_nextInTxn = m;
    }

    @Override
    public IMgram getNextInTxn() {
        return this.m_nextInTxn;
    }

    @Override
    public synchronized void setEnqueuedSize(int size) {
        this.m_enqueuedSizeSet = true;
        this.m_enqueuedSize = size;
    }

    @Override
    public boolean isEnqueuedSizeSet() {
        return this.m_enqueuedSizeSet;
    }

    @Override
    public synchronized void removeEnqueuedSize() {
        this.m_enqueuedSizeSet = false;
    }

    @Override
    public synchronized int getEnqueuedSize() {
        if (this.m_enqueuedSizeSet) {
            return this.m_enqueuedSize;
        }
        return this.memoryLength();
    }

    @Override
    public void setTrackedSize(int value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int getTrackedSize() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isTrackedSizeSet() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setDbTracking(long dbTracking) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public long getDbTracking() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isDbTrackingSet() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isGuarFormatIncorrect() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setGuarFormatIncorrect(boolean guarFormatIncorrect) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized void acknowledgeAndForward(IMessageProtection mp, IMgram ackForwardRequest) {
        this.setType((byte)12);
        ((SidebandData)this.getSidebandData()).setGSAPublication(false);
        this.setPriority(ackForwardRequest.getPriority());
        this.setJMSPersistent(ackForwardRequest.isJMSPersistent());
        if (ackForwardRequest.isTTE()) {
            this.setTTE(ackForwardRequest.getTTE());
        }
        if (this.isSecure()) {
            this.setSecurityAttribute(ackForwardRequest.getSecurity());
        }
        this.setSubject(ackForwardRequest.getSubject().protectedClone(), ackForwardRequest.getSubjectFormat());
        ((SidebandData)this.getSidebandData()).setRouting(((SidebandData)ackForwardRequest.getSidebandData()).getRouting());
    }

    @Override
    public synchronized void acknowledgeAndForward(IMgram ackForwardRequest) {
        this.setLogEvent(null);
        this.setSenderID(ackForwardRequest.getBrokerHandle().getSenderID());
        this.setGuarenteed(ackForwardRequest.getGuarenteedTrackingNum());
    }

    public static Mgram createMgram(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(is, sis, mp, csc, null, null, tteTTLConvert);
    }

    public static Mgram createMgram(byte version, InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(version, is, sis, mp, csc, null, null, tteTTLConvert);
    }

    public static Mgram createMgram(byte version, InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, StreamUtilCounter sc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(version, is, sis, mp, csc, null, sc, tteTTLConvert);
    }

    public static Mgram createMgram(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, IMgramStatusListener listener, StreamUtilCounter sc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.setStatusListener(listener);
        mgram.initMgramFromStream(is, sis, mp, csc, tteTTLConvert, sc);
        return mgram;
    }

    public static Mgram createMgram(byte version, InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, IMgramStatusListener listener, StreamUtilCounter sc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.setStatusListener(listener);
        mgram.initMgramFromStream(version, is, sis, mp, csc, tteTTLConvert, sc);
        return mgram;
    }

    public static Mgram createMgramNonSecure(byte version, InputStream is, IMgramStatusListener listener, StreamUtilCounter sc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.setStatusListener(listener);
        mgram.initMgramFromStream(version, is, null, null, null, tteTTLConvert, sc);
        return mgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() {
        PrintStream log = SessionConfig.getLog();
        try {
            PrintStream printStream = log;
            synchronized (printStream) {
                log.println("==========");
                log.println("Mgram Dump");
                log.println("==========");
                StaticHeader.dump(this.m_staticHeader);
                if (this.getType() != 4) {
                    this.createDynamicHeader();
                    this.m_dynamicHeader.dump();
                    this.createPayload();
                    this.m_payload.dump();
                    if (this.m_isTTE_TTL) {
                        log.println("TTE value is TTL");
                    } else {
                        log.println("TTE value is TTE");
                    }
                }
                log.println("==========");
            }
        }
        catch (Throwable e) {
            log.println("Error dumping mgram: " + e.toString());
        }
    }

    @Override
    public synchronized ObjectInput getPayloadInputStreamHandle() {
        this.createPayload();
        return this.m_payload.getPayloadInputStreamHandle();
    }

    @Override
    public synchronized ObjectOutput getPayloadOutputStreamHandle() {
        this.createPayload();
        return this.m_payload.getPayloadOutputStreamHandle();
    }

    @Override
    public final synchronized IOperationHandle getOperationHandle() {
        this.checkOperationType();
        this.createPayload();
        return this.m_payload.getOperationHandle();
    }

    @Override
    public final synchronized IBatchHandle getBatchHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public final synchronized ISaverOpHandle getSaverOpHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public final synchronized ITXNRequestHandle getTXNRequestHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public final synchronized IConnectionSyncHandle getConnectionSyncHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    void checkOperationType() {
        if (this.getType() != 25) {
            throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
        }
    }

    @Override
    public IJMSClientHandle getJMSClientHandle() {
        return this;
    }

    @Override
    public boolean isJMSAsynchronous() {
        return this.m_isJMSAsynchronous;
    }

    @Override
    public void setJMSAsynchronous(boolean value) {
        this.m_isJMSAsynchronous = value;
    }

    @Override
    public void setPerMsgEncrypted(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isPerMsgEncrypted() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setConnection(Connection c) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public Connection getConnection() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized void setLimiterSizeIncrement(int size) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void markLimiterSize() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int getLimiterSize() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setSubject(ISubject subject, int format) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isNonPersistentReplicated() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean requiresXOnceDelivery() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setNonPersistentReplicated(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean hasUndeliveredDestination() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setUndeliveredDestination(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void addSubjectFilter(long id, ISubjectFilter filter) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public ISubjectFilter getSubjectFilter(long id) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public LongHashTable getSubjectFilters() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setSubjectFilters(LongHashTable table) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void assignSubjectTrackingNumbers(long trk) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean hasStreamVersion() {
        return false;
    }

    @Override
    public byte getStreamVersion() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public byte getStreamFlags() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setStreamVersion(byte vers) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setStreamFlags(byte flags) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setCompressionEnabled(boolean b) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isCompressionEnabled() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public byte getCompressionId() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setCompressionId(byte vers) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setNoOutqueueExpire(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean getNoOutqueueExpire() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public RejectionTracker getRejectionTracker() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setRejectionTracker(RejectionTracker tracker) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setGroupSubscriptionCC(long id) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public long getGroupSubscriptionCC() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public long getPtpEnqueueTime() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setPtpEnqueueTime(long tm) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public byte getReenqueueCount() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setReenqueueCount(byte reenqueues) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setDeliveryCancelled() {
    }

    @Override
    public boolean isDeliveryCancelled() {
        return false;
    }
}

