/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsafe;

import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.ssl.SSLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.Set;
import java.util.Vector;
import progress.message.net.ssl.jsafe.jsafeKeyStore;
import progress.message.security.cert.ECertificateException;
import progress.message.zclient.ProgressPasswordUser;

public final class jsafeX509Certificate
extends progress.message.security.cert.X509Certificate {
    private X509Certificate m_impl = null;

    protected jsafeX509Certificate(X509Certificate x509cert) {
        this.m_impl = x509cert;
    }

    protected X509Certificate getX509CertificateImpl() {
        return this.m_impl;
    }

    @Override
    public Principal getIssuerDN() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getIssuerDN");
        }
        try {
            String uid = this.m_impl.getIssuerName().toString();
            ProgressPasswordUser p = new ProgressPasswordUser(uid, new byte[0]);
            return p;
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getIssuerCommonName() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getIssuerCommonName");
        }
        try {
            return this.m_impl.getIssuerName().getAttribute(0).getStringAttribute();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public Principal getSubjectDN() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getSubjectDN");
        }
        try {
            String uid = this.m_impl.getSubjectName().toString();
            ProgressPasswordUser p = new ProgressPasswordUser(uid, new byte[0]);
            return p;
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getSubjectCommonName() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getSubjectCommonName");
        }
        try {
            return this.m_impl.getSubjectName().getAttribute(0).getStringAttribute();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public int getVersion() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getVersion");
        }
        try {
            return this.m_impl.getVersion();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public BigInteger getSerialNumber() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getSerialNumber");
        }
        try {
            return new BigInteger(this.m_impl.getSerialNumber());
        }
        catch (Exception e) {
            throw new ECertificateException(e.getMessage(), e);
        }
    }

    @Override
    public Date getNotBefore() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getNotBefore");
        }
        try {
            return this.m_impl.getStartDate();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public Date getNotAfter() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getNotAfter");
        }
        try {
            return this.m_impl.getEndDate();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] getTBSCertificate() throws ECertificateException, CertificateEncodingException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getTBSCertificate");
        }
        try {
            byte[] ret = new byte[this.m_impl.getInnerDERLen()];
            this.m_impl.getInnerDER(ret, 0);
            return ret;
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] getSignature() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("getSignature");
        }
        try {
            return this.m_impl.getSignature();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getSigAlgName() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getSigAlgName");
    }

    @Override
    public String getSigAlgOID() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getSigAlgName");
    }

    @Override
    public boolean[] getIssuerUniqueID() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getIssuerUniqueID");
    }

    @Override
    public boolean[] getSubjectUniqueID() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getSubjectUniqueID");
    }

    @Override
    public boolean[] getKeyUsage() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getKeyUsage");
    }

    @Override
    public int getBasicConstraints() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getBasicConstraints");
    }

    @Override
    public void checkValidity() throws ECertificateException, CertificateExpiredException, CertificateNotYetValidException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("checkValidity");
        }
        try {
            this.m_impl.checkValidityDate(new Date());
        }
        catch (Exception e) {
            throw new ECertificateException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getSigAlgParams() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getSigAlgParams");
    }

    @Override
    public void checkValidity(Date date) throws ECertificateException, CertificateExpiredException, CertificateNotYetValidException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("checkValidity");
        }
        try {
            this.m_impl.checkValidityDate(date);
        }
        catch (Exception e) {
            throw new ECertificateException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getEncoded() throws ECertificateException, CertificateEncodingException {
        throw jsafeX509Certificate.getECertificateException("getEncoded");
    }

    @Override
    public String toString() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsafeX509Certificate.getECertificateException("toString");
        }
        try {
            return this.m_impl.toString();
        }
        catch (Exception e) {
            throw new ECertificateException(e.getMessage(), e);
        }
    }

    @Override
    public PublicKey getPublicKey() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getPublicKey");
    }

    @Override
    public void verify(PublicKey key) throws ECertificateException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw jsafeX509Certificate.getECertificateException("verify");
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws ECertificateException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw jsafeX509Certificate.getECertificateException("verify");
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("hasUnsupportedCriticalExtension");
    }

    @Override
    public byte[] getExtensionValue(String oid) throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getExtensionValue");
    }

    public Set getCriticalExtensionOIDs() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getCriticalExtensionOIDs");
    }

    public Set getNonCriticalExtensionOIDs() throws ECertificateException {
        throw jsafeX509Certificate.getECertificateException("getNonCriticalExtensionOIDs");
    }

    public static Vector loadCertificateChain(String file) throws PKCS7Exception, IOException {
        FileInputStream fis = new FileInputStream(file);
        Vector certvector = jsafeX509Certificate.loadCertificateChain(fis);
        fis.close();
        return certvector;
    }

    public static Vector loadCertificateChain(InputStream file) throws PKCS7Exception, IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
        byte[] filedata = new byte[1024];
        while ((len = file.read(filedata)) >= 0) {
            bos.write(filedata, 0, len);
        }
        filedata = bos.toByteArray();
        bos.close();
        try {
            ByteArrayInputStream bufis = new ByteArrayInputStream(filedata);
            byte[] pembuf = jsafeKeyStore.doReadPEM(bufis);
            filedata = pembuf;
        }
        catch (IOException bufis) {
            // empty catch block
        }
        SignedData pkcs7data = (SignedData)ContentInfo.getInstance((int)2, null, null);
        String contentstr = "No content.";
        ContentInfo content = ContentInfo.getInstance((int)1, null, null);
        ((Data)content).setContent(contentstr.getBytes(), 0, contentstr.length());
        pkcs7data.setContentInfo(content);
        int filelen = filedata.length;
        pkcs7data.readInit(filedata, 0, filelen);
        pkcs7data.readFinal();
        return pkcs7data.getCertificates();
    }

    public static jsafeX509Certificate loadX509Certificate(String file) {
        try {
            return new jsafeX509Certificate(SSLUtils.loadCertificate((String)file));
        }
        catch (Exception ex) {
            try {
                Vector certVector = jsafeX509Certificate.loadCertificateChain(file);
                if (!certVector.isEmpty()) {
                    return new jsafeX509Certificate((X509Certificate)certVector.elementAt(0));
                }
            }
            catch (Exception ex_p7c) {
                return null;
            }
            return null;
        }
    }

    public static jsafeX509Certificate loadX509Certificate(File file) {
        return jsafeX509Certificate.loadX509Certificate(file.getAbsolutePath());
    }
}

