/*
 * Decompiled with CFR 0.152.
 */
package progress.message.strm.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class CRCOutputStream
extends FilterOutputStream {
    private Checksum cksum;
    private boolean doCheck;
    private DebugObject m_debugObj;
    private boolean DEBUG;

    public CRCOutputStream(OutputStream out, Checksum cksum) {
        this(out, cksum, true);
    }

    public CRCOutputStream(OutputStream out, Checksum cksum, boolean doCheck) {
        super(out);
        this.cksum = cksum;
        this.doCheck = doCheck;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.m_debugObj = new DebugObject("CRCOutputStream ");
            this.DEBUG = this.m_debugObj.getDebug();
        }
    }

    public void setChecked(boolean value) {
        if (this.DEBUG) {
            this.debug("setChecked called: value= " + value + " Thread= " + Thread.currentThread());
        }
        this.doCheck = value;
    }

    public boolean isChecked() {
        return this.doCheck;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.doCheck) {
            this.cksum.update(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.doCheck) {
            this.cksum.update(b, off, len);
        }
    }

    public Checksum getChecksum() {
        return this.cksum;
    }

    private void debug(String str) {
        this.m_debugObj.debug(str);
    }
}

