/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.jclient;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import progress.message.jimpl.MapMessage;
import progress.message.jimpl.Message;

public class MessageUtil {
    public static Message copyMessage(javax.jms.Message srcMsg, Session aSession) throws JMSException {
        Message destMessage = null;
        if (srcMsg instanceof TextMessage) {
            progress.message.jimpl.TextMessage destTextMsg = (progress.message.jimpl.TextMessage)((Object)aSession.createTextMessage());
            TextMessage srcTextMessage = (TextMessage)srcMsg;
            destTextMsg.setText(srcTextMessage.getText());
            destMessage = destTextMsg;
        } else if (srcMsg instanceof javax.jms.MapMessage) {
            MapMessage destMapMsg = (MapMessage)((Object)aSession.createMapMessage());
            javax.jms.MapMessage srcMapMessage = (javax.jms.MapMessage)srcMsg;
            Enumeration mapNames = srcMapMessage.getMapNames();
            while (mapNames.hasMoreElements()) {
                String mapName = (String)mapNames.nextElement();
                destMapMsg.setObject(mapName, srcMapMessage.getObject(mapName));
            }
            destMessage = destMapMsg;
        } else if (srcMsg instanceof StreamMessage) {
            progress.message.jimpl.StreamMessage destStreamMsg = (progress.message.jimpl.StreamMessage)((Object)aSession.createStreamMessage());
            StreamMessage srcStreamMessage = (StreamMessage)srcMsg;
            Object obj = null;
            srcStreamMessage.reset();
            try {
                while (true) {
                    obj = srcStreamMessage.readObject();
                    destStreamMsg.writeObject(obj);
                }
            }
            catch (MessageEOFException e) {
                destMessage = destStreamMsg;
            }
        } else if (srcMsg instanceof ObjectMessage) {
            progress.message.jimpl.ObjectMessage destObjectMsg = (progress.message.jimpl.ObjectMessage)((Object)aSession.createObjectMessage());
            ObjectMessage srcObjectMessage = (ObjectMessage)srcMsg;
            destObjectMsg.setObject(srcObjectMessage.getObject());
            destMessage = destObjectMsg;
        } else if (srcMsg instanceof BytesMessage) {
            int numBytesRead;
            progress.message.jimpl.BytesMessage destBytesMsg = (progress.message.jimpl.BytesMessage)((Object)aSession.createBytesMessage());
            BytesMessage srcBytesMessage = (BytesMessage)srcMsg;
            byte[] buffer = new byte[2048];
            byte[] body = new byte[]{};
            srcBytesMessage.reset();
            while ((numBytesRead = srcBytesMessage.readBytes(buffer)) != -1) {
                byte[] tmp = new byte[body.length + numBytesRead];
                System.arraycopy(body, 0, tmp, 0, body.length);
                System.arraycopy(buffer, 0, tmp, body.length, numBytesRead);
                body = tmp;
            }
            destBytesMsg.writeBytes(body);
            destMessage = destBytesMsg;
        } else {
            destMessage = (Message)((Object)aSession.createMessage());
        }
        destMessage.setJMSCorrelationID(srcMsg.getJMSCorrelationID());
        destMessage.setJMSType(srcMsg.getJMSType());
        destMessage.setJMSReplyTo(srcMsg.getJMSReplyTo());
        Enumeration propertyNames = srcMsg.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propName = (String)propertyNames.nextElement();
            destMessage.setObjectProperty(propName, srcMsg.getObjectProperty(propName));
        }
        if (srcMsg.getClass().getName().startsWith("com.sun.cts.tests.jms.common")) {
            destMessage.setBooleanProperty("JMS_SonicMQ_CTS_Message", true);
        } else if (srcMsg.getClass().getName().startsWith("com.sun.ts.tests.jms.common")) {
            destMessage.setBooleanProperty("JMS_SonicMQ_CTS_Message", true);
        }
        return destMessage;
    }
}

