/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.IHTTPResponse;
import com.sonicsw.blackbird.http.impl.HTTPConnection;
import com.sonicsw.blackbird.http.impl.HTTPMessage;
import com.sonicsw.blackbird.http.impl.HTTPResponse;
import com.sonicsw.blackbird.http.impl.prAccessor;
import java.net.URI;
import progress.message.resources.prMessageFormat;

public class HTTPRequest
extends HTTPMessage
implements IHTTPRequest {
    private String m_method;
    private URI m_requestURI;
    private HTTPResponse m_response;

    public HTTPRequest(HTTPConnection connection, int transportMode) {
        super(connection, transportMode);
    }

    @Override
    protected final void writeStartLine(EvsNetworkLinkResult result) throws EEvsIOException {
        this.writeLine(this.m_method + " " + this.m_requestURI.toASCIIString() + " " + "HTTP/1.1", result);
    }

    @Override
    protected final boolean readStartLine(EvsNetworkLinkResult result) throws EEvsIOException {
        int SP;
        String requestLine = this.readLine(result);
        if (requestLine == null) {
            if (DEBUG) {
                System.out.println("Unable to read request line: " + requestLine);
            }
            return false;
        }
        if (DEBUG) {
            System.out.println("Read request line: " + requestLine);
        }
        if ((SP = requestLine.indexOf(32)) == -1) {
            throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Malformed HTTP request line: Missing request path! {0}"), new Object[]{requestLine}), null);
        }
        this.m_method = requestLine.substring(0, SP).trim();
        if ((SP = (requestLine = requestLine.substring(SP).trim()).indexOf(32)) == -1) {
            throw new EEvsIOException(prAccessor.getString("Malformed HTTP Response status line: Missing http version!"), null);
        }
        this.m_requestURI = URI.create(requestLine.substring(0, SP));
        try {
            this.setHTTPVersion(requestLine.substring(SP));
        }
        catch (IllegalArgumentException iae) {
            throw new EEvsIOException(iae.getMessage(), (Exception)iae);
        }
        return true;
    }

    @Override
    public final String getMethod() {
        return this.m_method;
    }

    @Override
    public final void setMethod(String method) {
        this.m_method = method;
    }

    @Override
    public final void setRequestURI(URI uri) {
        this.m_requestURI = uri;
    }

    @Override
    public final URI getRequestURI() {
        return this.m_requestURI;
    }

    public void setHTTPResponse(HTTPResponse response) {
        this.m_response = response;
        if (this.m_response.getHTTPRequest() != this) {
            this.m_response.setHTTPRequest(this);
        }
    }

    @Override
    public final IHTTPResponse getResponse() {
        return this.m_response;
    }

    @Override
    public String toString() {
        return this.debugString();
    }

    String debugString() {
        return "HTTP Request: " + this.m_method + " " + this.m_requestURI + " " + this.m_version + "\n" + super.toString();
    }
}

