/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.dstriggers;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.ITriggerDSContext;
import com.sonicsw.mf.common.config.IValidationDSContext;
import com.sonicsw.mf.common.config.IValidationElementChange;
import com.sonicsw.mf.common.config.IValidator;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.util.ReferentialIntegrity;
import java.util.HashMap;
import java.util.Iterator;

public class DeleteTrigger80
implements IValidator {
    private static final String[] TYPES_VALIDATED = new String[]{"MQ_BROKER", "MQ_BACKUP_BROKER", "MQ_AUTHORIZATION_ACL"};
    private static final String RELEASE_VERSION = "104";
    private static final String RELEASE_VERSION_5 = "5.0";
    private static final String RELEASE_VERSION_99 = "99";
    private static final String CLUSTERS_DIR = "/mq/clusters";

    public String getReleaseVersion() {
        return RELEASE_VERSION;
    }

    public String[] getElementTypesValidated() {
        return TYPES_VALIDATED;
    }

    public void onDelete(ITriggerDSContext dsContext, IDirElement[] beforeImages) throws DirectoryServiceException {
        for (int i = 0; i < beforeImages.length; ++i) {
            try {
                String type = beforeImages[i].getIdentity().getType();
                if ("MQ_BROKER".equals(type) || "MQ_BACKUP_BROKER".equals(type)) {
                    ReferentialIntegrity.removeComponent((ITriggerDSContext)dsContext, (String)beforeImages[i].getIdentity().getName());
                }
                if (!"MQ_BROKER".equals(type)) continue;
                this.onDeleteOfBroker(dsContext, beforeImages[i].getIdentity().getName(), beforeImages[i].getIdentity().getReleaseVersion());
                continue;
            }
            catch (ReadOnlyException e) {
                e.printStackTrace();
                throw new RuntimeException(e.toString());
            }
            catch (ConfigException e) {
                e.printStackTrace();
                throw new RuntimeException(e.toString());
            }
        }
    }

    public void onUpdate(ITriggerDSContext dsContext, IDirElement[] beforeImages, IDeltaElement[] afterImages) throws DirectoryServiceException {
    }

    public void onCreate(ITriggerDSContext dsContext, IDirElement[] afterImages) throws DirectoryServiceException {
    }

    public void validate(IValidationDSContext dsContext, IValidationElementChange[] changes) throws Exception {
        for (int i = 0; i < changes.length; ++i) {
            String type;
            IDirElement beforeImage;
            if (changes[i].skipValidation() || changes[i].getChangeType() != 2 || (beforeImage = (IDirElement)changes[i].getBeforeImage()) == null || !"MQ_AUTHORIZATION_ACL".equals(type = beforeImage.getIdentity().getType())) continue;
            this.onValidateDeleteOfACL(beforeImage);
        }
    }

    private void onDeleteOfBroker(ITriggerDSContext dsContext, String brokerName, String version) throws DirectoryServiceException, ReadOnlyException, ConfigException {
        if (dsContext.directoryExists(CLUSTERS_DIR)) {
            this.cleanAllClusters(dsContext, brokerName);
        }
    }

    private void onValidateDeleteOfACL(IDirElement beforeImage) throws DirectoryServiceException {
        String principalName;
        String resourceType;
        IAttributeSet aclAttrs = beforeImage.getAttributes();
        String resourceName = (String)aclAttrs.getAttribute("RESOURCE_NAME");
        if ("SonicMQ.mf".equals(resourceName) && "topic".equals(resourceType = (String)aclAttrs.getAttribute("RESOURCE_TYPE")) && "Administrators".equals(principalName = (String)aclAttrs.getAttribute("PRINCIPAL_NAME"))) {
            throw new DirectoryServiceException("Failed to delete ACL (topic=\"SonicMQ.mf\", principal=\"Administrators\"; deleting of this ACL is not allowed");
        }
    }

    private void cleanAllClusters(ITriggerDSContext dsContext, String brokerName) throws DirectoryServiceException, ReadOnlyException, ConfigException {
        IElementIdentity[] allClusters = dsContext.listElements(CLUSTERS_DIR);
        for (int i = 0; i < allClusters.length; ++i) {
            IDirElement clusterElement = dsContext.getElement(allClusters[i].getName());
            String version = clusterElement.getIdentity().getReleaseVersion();
            if (version.equals(RELEASE_VERSION_5) || version.equals(RELEASE_VERSION_99)) {
                this.cleanCluster5(dsContext, clusterElement, brokerName);
                continue;
            }
            this.cleanCluster6(dsContext, clusterElement, brokerName);
        }
    }

    private void cleanCluster5(ITriggerDSContext dsContext, IDirElement cluster, String brokerName) throws DirectoryServiceException, ReadOnlyException {
        IAttributeSet clusterAttributes = cluster.getAttributes();
        IAttributeList clusterMembers = (IAttributeList)clusterAttributes.getAttribute("CLUSTER_MEMBERS");
        if (clusterMembers == null) {
            return;
        }
        boolean itemDeleted = false;
        for (int j = 0; j < clusterMembers.getCount(); ++j) {
            Reference r = (Reference)clusterMembers.getItem(j);
            if (!r.getElementName().equals(brokerName)) continue;
            clusterMembers.deleteAttributeItem(j);
            itemDeleted = true;
        }
        if (itemDeleted) {
            dsContext.setElement((IDeltaElement)cluster.doneUpdate());
        }
    }

    private void cleanCluster6(ITriggerDSContext dsContext, IDirElement clusterElement, String brokerName) throws DirectoryServiceException, ReadOnlyException, ConfigException {
        IAttributeSet clusterAttributes = clusterElement.getAttributes();
        IAttributeSet clusterMembers = (IAttributeSet)clusterAttributes.getAttribute("CLUSTER_MEMBERS");
        if (clusterMembers == null) {
            return;
        }
        HashMap membersTable = clusterMembers.getAttributes();
        Iterator membersIterator = membersTable.keySet().iterator();
        boolean itemDeleted = false;
        while (membersIterator.hasNext()) {
            String key = (String)membersIterator.next();
            Reference brokerReference = (Reference)membersTable.get(key);
            if (!brokerReference.getElementName().equals(brokerName)) continue;
            clusterMembers.deleteAttribute(key);
            itemDeleted = true;
        }
        if (itemDeleted) {
            dsContext.setElement((IDeltaElement)clusterElement.doneUpdate());
        }
    }
}

