/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.HttpRemoteBroker;
import com.sonicsw.net.http.TimedUrlConnection;
import java.util.ArrayList;
import progress.message.broker.Config;
import progress.message.gr.RemoteBrokerHelper;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;

public class HttpDirectDispatchThreadPool
extends DebugObject {
    RemoteBrokerHelper m_rbh = null;
    ArrayList m_httpRemoteBrokers = null;
    int m_hrbIndex = 0;
    ArrayList m_dispatchThreads = null;
    private int m_dispatchThreadId;
    private int m_configMaxPoolSize;
    private int m_currentPoolSize;
    private int m_configMinReservedPoolSize;
    private int m_numNonReservedThreads = 0;
    private int m_numLowPriorityDestinations = 0;
    private boolean m_selectNewDestinationForDispatch = true;
    private int m_numHRBAdded = 0;
    private int m_numHRBRemoved = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectNewDestinationForDispatch() {
        ArrayList arrayList = this.m_httpRemoteBrokers;
        synchronized (arrayList) {
            boolean prevSelectNewDestinationForDispatch = this.m_selectNewDestinationForDispatch;
            this.m_selectNewDestinationForDispatch = this.m_httpRemoteBrokers.size() > this.m_configMaxPoolSize ? true : this.m_numLowPriorityDestinations > this.m_configMaxPoolSize - this.m_configMinReservedPoolSize;
            if (this.m_selectNewDestinationForDispatch != prevSelectNewDestinationForDispatch) {
                for (HttpDispatchThread dispatchThread : this.m_dispatchThreads) {
                    dispatchThread.setSelectNewDestination(this.m_selectNewDestinationForDispatch, this.m_configMaxPoolSize < this.m_currentPoolSize);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpDirectDispatchThreadPool(RemoteBrokerHelper rbh) {
        super("HttpDirectDispatchThreadPool");
        this.setCallback();
        this.m_rbh = rbh;
        ArrayList arrayList = this.m_httpRemoteBrokers = this.m_rbh.getHttpRemoteBrokers();
        synchronized (arrayList) {
            this.m_numLowPriorityDestinations = 0;
            for (int ii = 0; ii < this.m_httpRemoteBrokers.size(); ++ii) {
                if (!((HttpRemoteBroker)this.m_httpRemoteBrokers.get(ii)).isLowPriorityDestination()) continue;
                ++this.m_numLowPriorityDestinations;
            }
        }
        this.m_configMaxPoolSize = Config.HTTP_DIRECT_OUTBOUND_DISPATCH_THREADS;
        this.m_configMinReservedPoolSize = Config.HTTP_DIRECT_OUTBOUND_RESERVED_FOR_GROUPED_REQUESTS_THREADS;
    }

    private void setCallback() {
        if (this.CALLBACK) {
            this.callback("HttpDirectDispatchThreadPool", 0, new Long(5000L));
        }
    }

    public void start() {
        this.m_dispatchThreads = new ArrayList(this.m_configMaxPoolSize);
        for (int ii = 0; ii < this.m_configMaxPoolSize; ++ii) {
            this.createNewDispatchThread();
        }
        this.setSelectNewDestinationForDispatch();
    }

    public void stopThreads() {
        for (HttpDispatchThread dispatchThread : this.m_dispatchThreads) {
            if (dispatchThread == null || !dispatchThread.isAlive()) continue;
            dispatchThread.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigMaxPoolSize(int newSize) {
        ArrayList arrayList = this.m_httpRemoteBrokers;
        synchronized (arrayList) {
            if (this.m_configMaxPoolSize == newSize) {
                return;
            }
            if (this.m_configMaxPoolSize < newSize) {
                for (int ii = 0; ii < newSize - this.m_configMaxPoolSize; ++ii) {
                    this.createNewDispatchThread();
                }
            } else {
                this.m_httpRemoteBrokers.notifyAll();
            }
            this.m_configMaxPoolSize = newSize;
            this.setSelectNewDestinationForDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigMinReservedPoolSize(int newSize) {
        ArrayList arrayList = this.m_httpRemoteBrokers;
        synchronized (arrayList) {
            int increment = newSize - this.m_configMinReservedPoolSize;
            if (increment == 0) {
                return;
            }
            this.m_configMinReservedPoolSize = newSize;
            this.setSelectNewDestinationForDispatch();
            if (increment > 0) {
                this.m_httpRemoteBrokers.notifyAll();
            }
        }
    }

    public void onHttpRemoteBrokerRemove(HttpRemoteBroker hrb) {
        HttpDispatchThread t;
        if (hrb.isLowPriorityDestination()) {
            --this.m_numLowPriorityDestinations;
        }
        ++this.m_numHRBRemoved;
        if (this.DEBUG) {
            this.debug("onHttpRemoteBrokerRemove: hrb for " + hrb.getPendingQueueName() + ", low-prio dest " + hrb.isLowPriorityDestination() + ", new # of low-prio destinations " + this.m_numLowPriorityDestinations + ", m_numHRBRemoved = " + this.m_numHRBRemoved);
        }
        if ((t = (HttpDispatchThread)hrb.getDispatchThread()) != null) {
            if (this.DEBUG) {
                this.debug("onHttpRemoteBrokerRemove, wake up the thread: " + hrb.getPendingQueueName());
            }
            t.setWakeUpIfWaitingOnEmpty(true);
        }
        this.setSelectNewDestinationForDispatch();
    }

    public void onHttpRemoteBrokerAdd(HttpRemoteBroker hrb) {
        if (hrb.isLowPriorityDestination()) {
            ++this.m_numLowPriorityDestinations;
        }
        ++this.m_numHRBAdded;
        if (this.DEBUG) {
            this.debug("onHttpRemoteBrokerAdd: hrb for " + hrb.getPendingQueueName() + ", low-prio dest " + hrb.isLowPriorityDestination() + ", new # of low-prio destinations " + this.m_numLowPriorityDestinations + ", m_numHRBAdded = " + this.m_numHRBAdded);
        }
        this.setSelectNewDestinationForDispatch();
    }

    private void createNewDispatchThread() {
        HttpDispatchThread newThread = new HttpDispatchThread(++this.m_dispatchThreadId);
        ++this.m_currentPoolSize;
        this.m_dispatchThreads.add(newThread);
        newThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRemoteBroker selectDestinationForDispatch(HttpDispatchThread dispatchThread) throws InterruptedException {
        HttpRemoteBroker result = null;
        ArrayList arrayList = this.m_httpRemoteBrokers;
        synchronized (arrayList) {
            while (true) {
                Thread.currentThread();
                if (Thread.interrupted() || dispatchThread.isShuttingDown() || this.m_currentPoolSize > this.m_configMaxPoolSize) break;
                int limit = this.m_httpRemoteBrokers.size();
                result = null;
                for (int count = 0; count < limit; ++count) {
                    if (this.m_hrbIndex >= limit) {
                        this.m_hrbIndex = 0;
                    }
                    if (!(result = (HttpRemoteBroker)this.m_httpRemoteBrokers.get(this.m_hrbIndex++)).isDispatching() && !result.isEmpty()) {
                        if (!result.isLowPriorityDestination()) break;
                        if (this.m_numNonReservedThreads < this.m_configMaxPoolSize - this.m_configMinReservedPoolSize) {
                            ++this.m_numNonReservedThreads;
                            break;
                        }
                    }
                    result = null;
                }
                if (result != null) {
                    result.setDispatchThread(dispatchThread, !this.m_selectNewDestinationForDispatch);
                    break;
                }
                if (this.DEBUG) {
                    this.debug("Waiting for work ..");
                }
                this.m_httpRemoteBrokers.wait();
            }
            if (dispatchThread.isShuttingDown() || this.m_currentPoolSize > this.m_configMaxPoolSize) {
                return null;
            }
        }
        if (this.DEBUG && result != null) {
            this.debug("Selected " + result.getPendingQueueName() + " for dispatching ");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void needDispatch(boolean lowPriorityDestination) {
        ArrayList arrayList = this.m_httpRemoteBrokers;
        synchronized (arrayList) {
            if (!lowPriorityDestination || this.m_numNonReservedThreads < this.m_configMaxPoolSize - this.m_configMinReservedPoolSize) {
                this.m_httpRemoteBrokers.notifyAll();
            }
        }
    }

    class HttpDispatchThread
    extends DebugThread
    implements TimedUrlConnection.ITimedUrlConnectionUserHandle {
        private int m_threadId;
        private HttpRemoteBroker m_hrb;
        private boolean m_selectNewDestination;
        private TimedUrlConnection.ResponseInfoThread m_responseThread;

        @Override
        public int getThreadId() {
            return this.m_threadId;
        }

        @Override
        public TimedUrlConnection.ResponseInfoThread getResponseThread() {
            return this.m_responseThread;
        }

        @Override
        public void setResponseThread(TimedUrlConnection.ResponseInfoThread responseThread) {
            this.m_responseThread = responseThread;
        }

        public HttpDispatchThread(int threadId) {
            super("HttpDispatchThread " + threadId);
            this.m_hrb = null;
            this.m_selectNewDestination = true;
            this.m_responseThread = null;
            this.m_threadId = threadId;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSelectNewDestination(boolean selectNewDestination, boolean wakeUpIfWaitingOnEmpty) {
            HttpDispatchThread httpDispatchThread = this;
            synchronized (httpDispatchThread) {
                if (this.m_hrb != null) {
                    this.m_hrb.setWaitForNextMessageIfEmpty(!wakeUpIfWaitingOnEmpty && !selectNewDestination);
                }
                this.m_selectNewDestination = selectNewDestination;
                if (this.DEBUG) {
                    String hrbText = "";
                    hrbText = this.m_hrb != null ? ", HRB for " + this.m_hrb.getPendingQueueName() + " was notified" : ", no HRB";
                    this.debug("m_selectNewDestination set to " + this.m_selectNewDestination + hrbText);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setWakeUpIfWaitingOnEmpty(boolean wakeUpIfWaitingOnEmpty) {
            if (this.DEBUG) {
                this.debug("setWakeUpIfWaitingOnEmpty = " + wakeUpIfWaitingOnEmpty);
            }
            HttpDispatchThread httpDispatchThread = this;
            synchronized (httpDispatchThread) {
                if (this.m_hrb != null) {
                    this.m_hrb.setWaitForNextMessageIfEmpty(!wakeUpIfWaitingOnEmpty);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            if (this.DEBUG) {
                this.debug("Starting");
            }
            try {
                while (!Thread.currentThread().isInterrupted() && !this.isShuttingDown()) {
                    ArrayList arrayList = HttpDirectDispatchThreadPool.this.m_httpRemoteBrokers;
                    synchronized (arrayList) {
                        HttpDispatchThread httpDispatchThread = this;
                        synchronized (httpDispatchThread) {
                            if (this.m_hrb != null) {
                                this.m_hrb.setDispatchThread(null, false);
                                if (this.m_hrb.isLowPriorityDestination()) {
                                    HttpDirectDispatchThreadPool.this.m_numNonReservedThreads--;
                                }
                                this.m_hrb = null;
                            }
                        }
                        HttpRemoteBroker newHRB = HttpDirectDispatchThreadPool.this.selectDestinationForDispatch(this);
                        if (newHRB == null) {
                            if (this.DEBUG) {
                                this.debug("Exiting - too many dispatch threads");
                            }
                            break;
                        }
                        httpDispatchThread = this;
                        synchronized (httpDispatchThread) {
                            this.m_hrb = newHRB;
                        }
                    }
                    this.dispatch(1);
                }
            }
            catch (InterruptedException ie) {
                if (this.DEBUG) {
                    this.debug("Returning after interrupt");
                }
                return;
            }
            finally {
                ArrayList arrayList = HttpDirectDispatchThreadPool.this.m_httpRemoteBrokers;
                synchronized (arrayList) {
                    --HttpDirectDispatchThreadPool.this.m_currentPoolSize;
                }
                if (this.m_responseThread != null) {
                    this.m_responseThread.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatch(int numMessages) throws InterruptedException {
            IMgram mgram = null;
            int ii = 0;
            while (true) {
                HttpDispatchThread httpDispatchThread = this;
                synchronized (httpDispatchThread) {
                    if (this.m_selectNewDestination && ii >= numMessages) {
                        break;
                    }
                }
                if (this.DEBUG) {
                    this.debug("About to dequeue a message for " + this.m_hrb.getPendingQueueName());
                }
                if ((mgram = this.m_hrb.dequeueAndNotify()) == null) {
                    if (!this.DEBUG) break;
                    this.debug("End of messages for " + this.m_hrb.getPendingQueueName());
                    break;
                }
                this.m_hrb.getHandler().sendMgram(mgram, this);
                if (this.DEBUG) {
                    String trkNum = String.valueOf(mgram.getGuarenteedTrackingNum());
                    this.debug("Dispatched a message with tracking # " + trkNum + " for " + this.m_hrb.getPendingQueueName());
                }
                ++ii;
            }
        }
    }
}

