/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.cert;

import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;

public class BrokerKeyStore {
    private static boolean DEBUG = false;
    private static BrokerKeyStore s_keyStore = null;
    private static Object _sync = new Object();
    private KeyStore m_keyStore = null;
    private String m_keyStoreType = null;
    private String m_url = null;
    private char[] m_pwd = null;
    private String m_defaultAlias = null;
    private char[] m_defaultKeyPassword = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerKeyStore getInstance(String type) {
        if (s_keyStore == null) {
            Object object = _sync;
            synchronized (object) {
                if (s_keyStore == null) {
                    s_keyStore = new BrokerKeyStore(type);
                }
            }
        }
        return s_keyStore;
    }

    private BrokerKeyStore(String type) {
        this.m_keyStoreType = type;
    }

    public synchronized void load(String url, char[] password) throws Exception {
        this.setURL(url);
        this.setPassword(password);
        this.loadInternal();
    }

    private void loadInternal() throws Exception {
        this.m_keyStore = null;
        if (this.m_url == null || this.m_url.length() == 0) {
            throw new KeyStoreException("invalid path.");
        }
        if (this.m_pwd == null || this.m_pwd.length == 0) {
            throw new KeyStoreException("invalid password.");
        }
        this.m_keyStore = KeyStore.getInstance("JKS");
        try {
            this.m_keyStore.load(new URL(this.m_url).openConnection().getInputStream(), this.m_pwd);
        }
        catch (Exception ex) {
            this.m_keyStore = null;
            throw ex;
        }
    }

    public void setDefaultCertificate(String alias, String pwd) throws KeyStoreException {
        this.m_defaultAlias = alias;
        this.m_defaultKeyPassword = pwd.toCharArray();
        this.verifyDefaultCertificateAndPrivateKey();
    }

    public synchronized void resetDefaultCertificate(String alias, String pwd) throws KeyStoreException {
        if (alias != null) {
            this.m_defaultAlias = alias;
        }
        if (pwd != null) {
            this.m_defaultKeyPassword = pwd.toCharArray();
        }
        this.verifyDefaultCertificateAndPrivateKey();
    }

    private void verifyDefaultCertificateAndPrivateKey() throws KeyStoreException {
        X509Certificate cert = this.getCertificate(this.m_defaultAlias);
        Key key = this.getKey(this.m_defaultAlias, this.m_defaultKeyPassword);
        if (cert == null || key == null) {
            throw new KeyStoreException("Unable to retrieve the certificate and/or private for " + this.m_defaultAlias);
        }
        if (DEBUG) {
            System.out.println("Default X.509 V3 token : " + cert);
        }
    }

    public synchronized KeyStore getKeyStore() {
        return this.m_keyStore;
    }

    public X509Certificate getDefaultCertificate() {
        return this.getCertificate(this.m_defaultAlias);
    }

    public Key getDefaultPrivateKey() {
        return this.getKey(this.m_defaultAlias, this.m_defaultKeyPassword);
    }

    public synchronized X509Certificate getCertificate(String alias) {
        X509Certificate cert = null;
        try {
            if (this.m_keyStore != null && alias != null) {
                cert = (X509Certificate)this.m_keyStore.getCertificate(alias);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return cert;
    }

    public synchronized Key getKey(String alias, char[] pwd) {
        Key key = null;
        try {
            if (this.m_keyStore != null && alias != null && pwd != null) {
                key = this.m_keyStore.getKey(alias, pwd);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return key;
    }

    public void setURL(String url) {
        this.m_url = url;
        if (this.m_url == null) {
            return;
        }
        int index = url.indexOf(":");
        if (index < 0 || !url.substring(0, index).equalsIgnoreCase("sonicfs")) {
            this.m_url = "file:///" + url;
        }
    }

    public void setPassword(char[] pwd) {
        this.m_pwd = pwd;
    }

    public synchronized void reload() throws Exception {
        this.loadInternal();
    }

    public synchronized void reset() {
        this.m_keyStore = null;
    }

    public String getDefaultAlias() {
        return this.m_defaultAlias;
    }

    public char[] getDefaultKeyPassword() {
        return this.m_defaultKeyPassword;
    }
}

