/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.model.KeyStoreEntry;
import com.sonicsw.ws.security.policy.model.X509Token;
import com.sonicsw.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class KeyStoreEntryProcessor {
    private boolean m_initialized;

    private void initializeKeyStoreEntry(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.alias.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.privateKeyPassword.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
    }

    public Object doKeyStoreEntry(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.m_initialized) break;
                try {
                    this.initializeKeyStoreEntry(spt);
                    KeyStoreEntry keyStoreEntry = (KeyStoreEntry)spc.readCurrentPolicyEngineData();
                    ((X509Token)spc.readPreviousPolicyEngineData()).setKeyStoreEntry(keyStoreEntry);
                    this.m_initialized = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doAlias(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        if (spc.getAction() == 1) {
            ((KeyStoreEntry)spc.readCurrentPolicyEngineData()).setAlias(spc.getAssertion().getStrValue());
        }
        return new Boolean(true);
    }

    public Object doPrivateKeyPassword(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        if (spc.getAction() == 1) {
            ((KeyStoreEntry)spc.readCurrentPolicyEngineData()).setPrivateKeyPassword(spc.getAssertion().getStrValue());
        }
        return new Boolean(true);
    }
}

