/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.wss4j;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.wss4j.SonicWSOutboundCallback;
import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;

class SonicWSOutboundCallbackImpl
implements CallbackHandler,
SonicWSOutboundCallback {
    HashMap userInfoMap = new HashMap();
    byte[] m_key;

    SonicWSOutboundCallbackImpl() {
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                if (DebugObjects.getHandlerDebug().getDebug()) {
                    String s = null;
                    int usage = pc.getUsage();
                    s = usage == 0 ? "WSPasswordCallback.UNKNOWN" : (usage == 1 ? "WSPasswordCallback.DECRYPT" : (usage == 2 ? "WSPasswordCallback.USERNAME_TOKEN" : (usage == 3 ? "WSPasswordCallback.SIGNATURE" : (usage == 4 ? "WSPasswordCallback.KEY_NAME" : "WSPasswordCallback.???"))));
                    DebugObjects.getHandlerDebug().debug(s + ": Identifer = " + pc.getIdentifer());
                }
                if (pc.getUsage() == 4) {
                    pc.setKey(this.m_key);
                    continue;
                }
                String user = pc.getIdentifer();
                String password = (String)this.userInfoMap.get(user);
                pc.setPassword(password);
                DebugObjects.getHandlerDebug().debug("User: " + user + ", psw: " + password);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "WSSOutboundHandler: Unrecognized Callback");
        }
    }

    @Override
    public void setPassword(String userName, String password) {
        this.userInfoMap.put(userName, password);
    }

    @Override
    public void setKey(byte[] password) {
        this.m_key = password;
    }
}

