/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentSubjectSpace;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.GroupSubscription;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.parser.ParseException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectUtil;

public class GroupMultiTopicSubscription
extends GroupSubscription {
    private Hashtable<ISubject, SubjectCounts> m_allSubjects = new Hashtable();
    private AgentRegistrar m_reg = null;

    GroupMultiTopicSubscription(ISubject groupSubject, AgentRegistrar reg) {
        super(groupSubject, reg);
        this.m_reg = reg;
        Iterator<ISubject> iter = groupSubject.getMultiSubjects();
        while (iter.hasNext()) {
            ISubject subject = iter.next();
            this.m_allSubjects.put(subject, new SubjectCounts());
        }
        this.setGroupName(SubjectUtil.wrapSubjectGroupPrefix(groupSubject.getGroupName()));
    }

    @Override
    public String getGroupAppid() {
        return "$GROUPSUBSCRIPTION$MULTITOPIC$";
    }

    @Override
    public void subjectModified(ISubject added, ISubject removed) throws EInvalidSubjectSyntax {
        if (added != null) {
            this.recalculateIntersection(added, true);
        }
        if (removed != null) {
            this.recalculateIntersection(removed, false);
        }
    }

    @Override
    public void addSubscription(BrokerSubscription bs) throws EInvalidSubjectSyntax, ParseException {
        if (this.DEBUG) {
            this.debug("add GroupMultiTopicSubscription: " + bs);
        }
        super.addSubscription(bs);
        this.recalculateIntersection(bs.getSubject(), true);
    }

    @Override
    public void removeSubscription(BrokerSubscription bs) {
        if (this.DEBUG) {
            this.debug("removeSubscription: " + bs);
        }
        super.removeSubscription(bs);
        try {
            this.recalculateIntersection(bs.getSubject(), false);
        }
        catch (EInvalidSubjectSyntax eInvalidSubjectSyntax) {
            // empty catch block
        }
    }

    @Override
    public boolean okToSend(LBSTrackingInfo groups) {
        boolean ok = super.okToSend(groups);
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recalculateIntersection(ISubject groupSubject, boolean addSubject) throws EInvalidSubjectSyntax {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            Iterator<ISubject> iter = groupSubject.getMultiSubjects();
            while (iter.hasNext()) {
                ISubject subject = iter.next();
                SubjectCounts counter = this.m_allSubjects.get(subject);
                if (counter == null) {
                    counter = new SubjectCounts();
                    this.m_allSubjects.put(subject, counter);
                }
                if (addSubject) {
                    ++counter.m_count;
                    continue;
                }
                --counter.m_count;
            }
            Subject gsSubject = new Subject();
            Enumeration<ISubject> keys = this.m_allSubjects.keys();
            int numMembers = this.m_subs.size();
            while (keys.hasMoreElements()) {
                ISubject key = keys.nextElement();
                SubjectCounts counter = this.m_allSubjects.get(key);
                if (counter.m_count != numMembers) continue;
                gsSubject.addSubject(key);
            }
            if (!this.getSubject().equals(gsSubject)) {
                AgentSubjectSpace agentSubjectSpace = this.m_reg.getSubjectSpace();
                synchronized (agentSubjectSpace) {
                    ISubject oldSubject = this.getSubject();
                    if (oldSubject.isSubjectSet()) {
                        this.m_reg.getSubjectSpace().removeSubjectObject(this.getSubject(), (ISubjectMatchObject)this);
                    }
                    this.setSubject(gsSubject);
                    if (numMembers > 0 && gsSubject.isSubjectSet()) {
                        this.m_reg.getSubjectSpace().put(gsSubject, (ISubjectMatchObject)this);
                    }
                }
            }
        }
    }

    private static class SubjectCounts {
        int m_count = 0;

        private SubjectCounts() {
        }
    }
}

