/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.EOFException;
import java.io.IOException;
import progress.message.broker.ELogOutOfSequence;
import progress.message.broker.EProtectedBlockReached;
import progress.message.broker.ILogRandomAccessFile;
import progress.message.broker.LogBuffer;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public final class LogBlockBuffer
extends DebugObject {
    private LogBuffer m_logBuffer;
    private boolean m_isReadBuffer = false;
    private static int m_ControlSize = 8;
    private int m_BlockSize;
    private int m_DataSize;
    private long m_block;
    private int m_pos;
    private int m_end;
    private boolean m_cleared;
    private long m_protectPos;
    private long m_sequenceNumber = -1L;
    private boolean m_dirty;

    public LogBlockBuffer(String name, LogBuffer lbuf, int BlockSize, boolean isReadBuffer) {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogBlockBuffer " + name : null);
        this.m_BlockSize = BlockSize;
        this.m_isReadBuffer = isReadBuffer;
        this.m_logBuffer = lbuf;
        this.m_DataSize = BlockSize - m_ControlSize;
        this.writeLongInternal(-1L, this.m_DataSize);
        this.m_block = -1L;
        this.m_dirty = false;
        this.m_protectPos = -1L;
    }

    public int getBlockSize() {
        return this.m_BlockSize;
    }

    public int getDataSize() {
        return this.m_DataSize;
    }

    public long LogicalSize(long physicalsize) {
        long size = physicalsize / (long)this.m_BlockSize;
        return size *= (long)this.m_DataSize;
    }

    public boolean setBlockPos(ILogRandomAccessFile rfile, long pos) throws IOException, EOFException, ELogOutOfSequence {
        return this.setBlockPos(rfile, pos, this.m_isReadBuffer);
    }

    public synchronized boolean setBlockPos(ILogRandomAccessFile rfile, long pos, boolean fRead) throws IOException, EOFException, ELogOutOfSequence, EProtectedBlockReached {
        boolean ret = false;
        long previousBlock = this.m_block;
        long block = pos / (long)this.m_DataSize;
        int newpos = (int)(pos % (long)this.m_DataSize);
        if (block != this.m_block) {
            long previousSequenceNumber = this.readLong(this.m_DataSize);
            this.prepareForWrite(!this.m_isReadBuffer);
            this.m_dirty = false;
            this.m_end = 0;
            this.m_block = block;
            this.m_pos = newpos;
            this.m_cleared = false;
            if (fRead) {
                int result = this.m_logBuffer.setCurrentBlock(block, true);
                if (result == -1) {
                    this.m_end = 0;
                    ret = true;
                } else {
                    this.m_end = result;
                }
                if (this.m_end > this.m_DataSize) {
                    this.m_end = this.m_DataSize;
                }
                long currentSequenceNumber = this.readLong(this.m_DataSize);
                if (previousSequenceNumber > -1L && currentSequenceNumber > -1L && this.m_isReadBuffer) {
                    if (previousBlock > this.m_block && previousSequenceNumber < currentSequenceNumber) {
                        throw this.debugSequenceAndBlock(currentSequenceNumber, previousBlock, previousSequenceNumber);
                    }
                    if (previousBlock < this.m_block && this.m_sequenceNumber > currentSequenceNumber) {
                        throw this.debugSequenceAndBlock(currentSequenceNumber, previousBlock, previousSequenceNumber);
                    }
                }
                if (currentSequenceNumber > this.m_sequenceNumber) {
                    this.m_sequenceNumber = currentSequenceNumber;
                }
            } else {
                this.m_logBuffer.setCurrentBlock(block, false);
            }
            if (!this.m_isReadBuffer && block == this.m_protectPos) {
                throw new EProtectedBlockReached();
            }
        }
        this.m_pos = newpos;
        return ret;
    }

    private ELogOutOfSequence debugSequenceAndBlock(long currentSequenceNumber, long previousBlock, long previousSequenceNumber) {
        if (this.DEBUG) {
            this.debug("Log event out of sequence");
            this.debug("Previous sequence number: " + previousSequenceNumber);
            this.debug("Current sequence number: " + currentSequenceNumber);
            this.debug("Previous block number: " + previousBlock);
            this.debug("Current block number: " + this.m_block);
        }
        return new ELogOutOfSequence();
    }

    private synchronized void prepareForWrite(boolean updateSequenceNumber) throws IOException {
        if (this.m_dirty) {
            int nodata = this.m_DataSize - this.m_pos;
            if (nodata > 0 && !this.m_cleared) {
                this.m_logBuffer.clear(this.m_pos, nodata);
                this.m_cleared = true;
            }
            if (updateSequenceNumber) {
                this.writeSequenceNumber();
            }
            this.m_dirty = false;
        }
    }

    public synchronized void flush(ILogRandomAccessFile rfile) throws IOException {
        this.prepareForWrite(true);
        this.m_logBuffer.flushBuffer();
    }

    public synchronized int read() throws EOFException {
        if (this.DEBUG) {
            this.debug("reading byte at pos " + this.m_pos);
        }
        if (this.m_pos >= this.m_end) {
            throw new EOFException("reading byte at pos " + this.m_pos);
        }
        int result = this.m_logBuffer.read(this.m_pos);
        ++this.m_pos;
        return result;
    }

    public synchronized int read(byte[] b, int off, int len) throws EOFException {
        if (this.DEBUG) {
            this.debug("reading " + len + " bytes");
        }
        if (len == 0) {
            return 0;
        }
        byte x = b[off];
        x = b[off + len - 1];
        int rlen = this.m_end - this.m_pos < len ? this.m_end - this.m_pos : len;
        this.m_logBuffer.read(this.m_pos, b, off, rlen);
        this.m_pos += rlen;
        if (rlen != len && this.m_end != this.m_DataSize) {
            throw new EOFException();
        }
        return rlen;
    }

    public synchronized void write(int b) throws IOException {
        if (this.DEBUG) {
            this.debug("writing byte at pos " + this.m_pos + " byte: " + b);
        }
        this.m_dirty = true;
        if (this.m_pos >= this.m_DataSize) {
            throw new IOException("writing byte at pos " + this.m_pos);
        }
        this.m_logBuffer.write(this.m_pos, b);
        ++this.m_pos;
        this.configEndPointerWhenWritingPastIt();
    }

    public synchronized int write(byte[] b, int off, int len) {
        if (len == 0) {
            return 0;
        }
        this.m_dirty = true;
        if (this.DEBUG) {
            this.debug("writing buffer at pos " + this.m_pos);
        }
        byte x = b[off];
        x = b[off + len - 1];
        int rlen = this.m_DataSize - this.m_pos < len ? this.m_DataSize - this.m_pos : len;
        this.m_logBuffer.write(this.m_pos, b, off, rlen);
        this.m_pos += rlen;
        this.configEndPointerWhenWritingPastIt();
        return rlen;
    }

    public synchronized int readInt() {
        int result = this.m_logBuffer.readInt(this.m_pos);
        this.m_pos += 4;
        return result;
    }

    public synchronized long readLong(int positionParam) {
        int position = positionParam;
        long result = this.m_logBuffer.readLong(position);
        position += 8;
        return result;
    }

    private synchronized void writeLongInternal(long i, int positionParam) {
        int position = positionParam;
        position = this.writeLongIncrementPosition(position, i);
        if (this.m_pos > this.m_end) {
            this.m_end = position;
        }
    }

    private synchronized void writeSequenceNumber() {
        this.writeLongInternal(this.m_sequenceNumber, this.m_DataSize);
    }

    public synchronized void protectFilePos(long pos) {
        this.m_protectPos = pos / (long)this.m_DataSize;
    }

    public synchronized void unprotect() {
        this.m_protectPos = -1L;
    }

    public synchronized void setSequenceNumber(long number) {
        this.m_sequenceNumber = number;
    }

    public synchronized long getCurrentSequenceNumber() {
        return this.m_sequenceNumber;
    }

    public synchronized boolean tryWriteInt(int i) {
        if (this.m_pos + 4 > this.m_DataSize) {
            return false;
        }
        this.m_dirty = true;
        this.m_logBuffer.writeInt(this.m_pos, i);
        this.m_pos += 4;
        this.configEndPointerWhenWritingPastIt();
        return true;
    }

    public synchronized boolean tryWriteLong(long i) {
        if (this.m_pos + 8 > this.m_DataSize) {
            return false;
        }
        this.m_pos = this.writeLongIncrementPosition(this.m_pos, i);
        this.configEndPointerWhenWritingPastIt();
        return true;
    }

    private int writeLongIncrementPosition(int positionParam, long i) {
        int position = positionParam;
        this.m_dirty = true;
        this.m_logBuffer.writeLong(position, i);
        return position += 8;
    }

    private void configEndPointerWhenWritingPastIt() {
        if (this.m_pos > this.m_end) {
            this.m_end = this.m_pos;
        }
    }
}

