/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public class SyncSubscriptionDeleteEvt
extends LogEvent {
    private HashMap m_deletions;

    SyncSubscriptionDeleteEvt(HashMap deletions) {
        this.m_deletions = deletions;
    }

    SyncSubscriptionDeleteEvt() {
    }

    @Override
    public short type() {
        return 67;
    }

    @Override
    protected int memSizeBody() {
        int result = 4;
        return result += this.m_deletions.size() * 64;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return this.memSizeBody();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        int size = this.m_deletions.size();
        StreamUtil.writeInt(size, os);
        if (size > 0) {
            for (Long ID : this.m_deletions.keySet()) {
                StreamUtil.writeLong((long)ID, os);
                StreamUtil.writeLong((long)((Long)this.m_deletions.get(ID)), os);
            }
        }
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        int size = StreamUtil.readInt(in);
        if (size > 0) {
            this.m_deletions = new HashMap();
            for (int count = 0; count < size; ++count) {
                long id = StreamUtil.readLong(in);
                long maxMessageId = StreamUtil.readLong(in);
                this.m_deletions.put(new Long(id), new Long(maxMessageId));
            }
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().redoSyncSubscriptionDelete(this.m_deletions, this.isReplicateOnly());
    }

    @Override
    public String toString() {
        return super.toString() + "SyncDeleteBeginEvt";
    }
}

