/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.fc;

import java.util.ArrayList;
import java.util.Hashtable;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.IClientContext;
import progress.message.broker.IIntervalCheck;
import progress.message.broker.fc.FCEvent;
import progress.message.broker.fc.FlowControlMonitor;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IPTPFlowControlHandler;

public abstract class CCFlowControlTracker
extends DebugObject
implements IIntervalCheck {
    private boolean m_blocked = false;
    private boolean m_reportedBlocked = false;
    private long m_blockedTime;
    private int m_blockedAtPriority;
    private Hashtable m_previousBlocked = new Hashtable();
    private Hashtable m_reportedBlockedDests = new Hashtable();
    protected IClientContext m_cc;

    public CCFlowControlTracker(String name, IClientContext cc) {
        super(name);
        this.m_cc = cc;
    }

    public IClientContext getCC() {
        return this.m_cc;
    }

    public void startFCMonitor() {
        FlowControlMonitor fcm;
        if (this.isFCMonitoringEnabled() && (fcm = AgentRegistrar.getAgentRegistrar().getFCMonitor()) != null) {
            fcm.register(this);
        }
    }

    public void stopFCMonitor() {
        FlowControlMonitor fcm = AgentRegistrar.getAgentRegistrar().getFCMonitor();
        if (fcm != null) {
            fcm.unregister(this);
        }
    }

    @Override
    public void onEndInterval() {
        this.preMonitorFC();
        this.monitorFC();
    }

    @Override
    public String toString() {
        return "CCFlowControlTracker for : " + this.m_cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorFC() {
        if (!this.isFCMonitoringEnabled()) {
            return;
        }
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            FCEvent event = this.checkQueueFlowControl();
            event = this.checkTopicFlowControl(event);
            if (event != null) {
                this.sendFCReport(event);
            }
        }
    }

    public FCEvent checkTopicFlowControl(FCEvent event) {
        FCEvent evt = event;
        int minSendPrio = this.m_cc.getOutQueue().getMinDequeuePriority();
        int p = this.m_cc.getOutQueue().getMaxNonEmptyBlockedPriority();
        if (p > -1) {
            if (!this.m_blocked) {
                this.m_blocked = true;
                this.m_blockedAtPriority = p;
                this.m_blockedTime = System.currentTimeMillis();
                return evt;
            }
            long elapsed = System.currentTimeMillis() - this.m_blockedTime;
            this.m_reportedBlocked = true;
            if (this.DEBUG) {
                this.debug("checkTopicFlowControl: Adding topic blocked data; minsendprio= " + minSendPrio + " ThisBlockedAtPrio= " + p + " SavedBlockedAtPrio= " + this.m_blockedAtPriority + " elapsed= " + elapsed);
            }
            if (evt == null) {
                evt = this.createBlockedFCEvent();
            }
            evt.addTopicBlockedData(minSendPrio);
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTopicResume(int prio) {
        if (!this.isFCMonitoringEnabled()) {
            return;
        }
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            if (this.m_blocked && prio <= this.m_blockedAtPriority) {
                this.m_blocked = false;
                this.m_blockedAtPriority = -1;
                if (this.m_reportedBlocked) {
                    this.m_reportedBlocked = false;
                    if (this.DEBUG) {
                        this.debug("checkTopicResume: Adding resumed data; prio= " + prio);
                    }
                    FCEvent evt = this.createResumedFCEvent();
                    evt.addTopicResumedData(prio);
                    this.sendFCReport(evt);
                }
            }
        }
    }

    public FCEvent checkQueueFlowControl() {
        FCEvent evt = null;
        IPTPFlowControlHandler fch = this.m_cc.getPTPFlowControlHandler();
        if (fch != null && fch.hasBlocked()) {
            int i;
            String[] blockedNow = fch.getBlockedDestinations();
            ArrayList<String> reportList = new ArrayList<String>();
            for (i = 0; i < blockedNow.length; ++i) {
                if (!this.m_previousBlocked.containsKey(blockedNow[i])) continue;
                reportList.add(blockedNow[i]);
                this.m_reportedBlockedDests.put(blockedNow[i], blockedNow[i]);
                if (!this.DEBUG) continue;
                this.debug("checkQueueFlowControl: added Blocked dest to reportList " + blockedNow[i] + " sizeReportList= " + reportList.size());
            }
            this.m_previousBlocked.clear();
            for (i = 0; i < blockedNow.length; ++i) {
                this.m_previousBlocked.put(blockedNow[i], blockedNow[i]);
            }
            if (!reportList.isEmpty()) {
                evt = this.createBlockedFCEvent();
                evt.addQueueBlockedData(reportList.toArray(new String[reportList.size()]));
            }
        } else {
            this.m_previousBlocked.clear();
            if (this.DEBUG && !this.m_reportedBlockedDests.isEmpty()) {
                this.debug("checkQueueFlowControl: no blocked destinations; reportedBlocked= " + this.m_reportedBlockedDests.size());
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkQueueResumed(String dest) {
        if (!this.isFCMonitoringEnabled()) {
            return;
        }
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            if (this.m_reportedBlockedDests.remove(dest) != null) {
                this.m_previousBlocked.remove(dest);
                if (this.DEBUG) {
                    this.debug("CheckQueueResumed: adding resumed data " + dest + " remaining(reportedBlocked)= " + this.m_reportedBlockedDests.size());
                }
                FCEvent evt = this.createResumedFCEvent();
                evt.addQueueResumedData(dest);
                this.sendFCReport(evt);
            } else if (this.DEBUG) {
                this.debug("CheckQueueResumed: destNotFound: " + dest + " remaining(reportedBlocked)= " + this.m_reportedBlockedDests.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            this.m_blocked = false;
            this.m_blockedAtPriority = 0;
            this.m_blockedTime = 0L;
            this.m_reportedBlocked = false;
            this.m_reportedBlockedDests.clear();
            this.m_previousBlocked.clear();
        }
    }

    public void preMonitorFC() {
    }

    protected abstract boolean isFCMonitoringEnabled();

    protected abstract FCEvent createBlockedFCEvent();

    protected abstract FCEvent createResumedFCEvent();

    protected abstract void sendFCReport(FCEvent var1);

    String getDebugIdent() {
        return this.m_cc.getUid() + "/" + this.m_cc.getAppid();
    }
}

