/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq;

import progress.message.db.Db;
import progress.message.db.EDatabaseException;
import progress.message.db.jdbc.JDBCDatabase;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.dbq.IDupDetectDBQ;
import progress.message.dbq.IInitDbDBQ;
import progress.message.dbq.IPtpDBQ;
import progress.message.dbq.IPubSubDBQ;
import progress.message.dbq.IRegDBQ;
import progress.message.dbq.IRoutingDBQ;
import progress.message.dbq.pse.DupDetectDBQImplPSE;
import progress.message.dbq.pse.InitDbDBQImplPSE;
import progress.message.dbq.pse.PtpDBQImplPSE;
import progress.message.dbq.pse.PubSubDBQImplPSE;
import progress.message.dbq.pse.RegDBQImplPSE;
import progress.message.dbq.pse.RoutingDBQImplPSE;
import progress.message.dbq.sql.DupDetectDBQImplSQL;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class DBQSetup {
    public static IRegDBQ initRegDBQ(Db db) throws EDatabaseException {
        RegDBQImplPSE dbq = null;
        if (!(db instanceof PSEBrokerDb)) {
            throw new EAssertFailure("Unsupported dbtype: " + db);
        }
        PSEBrokerDb psedb = (PSEBrokerDb)db;
        dbq = new RegDBQImplPSE(psedb);
        dbq.init();
        return dbq;
    }

    public static IPtpDBQ initPtpDBQ(Db db) throws EDatabaseException {
        PtpDBQImplPSE dbq = null;
        if (!(db instanceof PSEBrokerDb)) {
            throw new EAssertFailure("Unsupported dbtype: " + db);
        }
        PSEBrokerDb psedb = (PSEBrokerDb)db;
        dbq = new PtpDBQImplPSE(psedb);
        dbq.init();
        return dbq;
    }

    public static IPubSubDBQ initPubSubDBQ(Db db) throws EDatabaseException {
        PubSubDBQImplPSE dbq = null;
        if (!(db instanceof PSEBrokerDb)) {
            throw new EAssertFailure("Unsupported dbtype: " + db);
        }
        PSEBrokerDb psedb = (PSEBrokerDb)db;
        dbq = new PubSubDBQImplPSE(psedb);
        dbq.init();
        return dbq;
    }

    public static IRoutingDBQ initRoutingDBQ(Db db) throws EDatabaseException {
        RoutingDBQImplPSE dbq = null;
        if (!(db instanceof PSEBrokerDb)) {
            throw new EAssertFailure("Unsupported dbtype: " + db);
        }
        PSEBrokerDb psedb = (PSEBrokerDb)db;
        dbq = new RoutingDBQImplPSE(psedb);
        dbq.init();
        return dbq;
    }

    public static IDupDetectDBQ initDupDetectDBQ(Db db) throws EDatabaseException {
        DebugObject dbq = null;
        String ddname = db.getDDName();
        if (db instanceof JDBCDatabase) {
            JDBCDatabase jdbcdb = (JDBCDatabase)db;
            dbq = new DupDetectDBQImplSQL(jdbcdb, ddname);
            dbq.init();
        } else if (db instanceof PSEBrokerDb) {
            PSEBrokerDb psedb = (PSEBrokerDb)db;
            dbq = new DupDetectDBQImplPSE(psedb, ddname);
            dbq.init();
        }
        return dbq;
    }

    public static IInitDbDBQ initDbInitDBQ(Db db) throws EDatabaseException {
        InitDbDBQImplPSE dbq = null;
        if (!(db instanceof PSEBrokerDb)) {
            throw new EAssertFailure("Unsupported dbtype: " + db);
        }
        PSEBrokerDb psedb = (PSEBrokerDb)db;
        dbq = new InitDbDBQImplPSE(psedb);
        dbq.init();
        return dbq;
    }
}

