/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.broker.AgentRegistrar;
import progress.message.dbq.IRoutingDBQ;
import progress.message.gr.RouteInfo;
import progress.message.gr.RouteSaverOp;

public final class DynamicSyncRoutesSaveOp
implements RouteSaverOp {
    private LinkedList m_ris;
    private boolean m_lastChunk = false;

    public DynamicSyncRoutesSaveOp() {
    }

    public DynamicSyncRoutesSaveOp(DataInput di) throws IOException {
        this.m_lastChunk = di.readBoolean();
        int size = di.readInt();
        this.m_ris = new LinkedList();
        for (int i = 0; i < size; ++i) {
            RouteInfo ri = new RouteInfo();
            ri.readFromStream(di, (short)-1);
            this.m_ris.add(ri);
        }
    }

    @Override
    public boolean executeOutsideRoutingDBTx() {
        return false;
    }

    @Override
    public void doit(IRoutingDBQ dbq) throws IOException {
        Iterator it = this.m_ris.iterator();
        RouteInfo ri = null;
        while (it.hasNext()) {
            ri = (RouteInfo)it.next();
            dbq.addRouteTx(ri);
        }
        AgentRegistrar.getAgentRegistrar().getReplicationManager().setDynamicSyncStatus(64);
    }

    @Override
    public int memsize() {
        return 0;
    }

    @Override
    public boolean okToReplicate() {
        return false;
    }
}

