/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IAckHandle;
import progress.message.msg.IAckListHandle;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IBrokerHandle;
import progress.message.msg.IConnectionSyncHandle;
import progress.message.msg.IErrorHandle;
import progress.message.msg.IExtendedTXNRequestHandle;
import progress.message.msg.IFailoverStatusNotificationHandle;
import progress.message.msg.IFlowControlHandle;
import progress.message.msg.IIDRHandle;
import progress.message.msg.IJMSClientHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.IOperationHandle;
import progress.message.msg.IPTPFlowControlHandle;
import progress.message.msg.IQueueFlowControlHandle;
import progress.message.msg.IReplicatedMgramHandle;
import progress.message.msg.IRoutingHandle;
import progress.message.msg.ISaverOpHandle;
import progress.message.msg.IStateEventHandle;
import progress.message.msg.ITXNRequestHandle;
import progress.message.msg.IWindowAckHandle;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v24.AckPayload;
import progress.message.msg.v24.DefaultDynamicHeader;
import progress.message.msg.v24.DefaultPayload;
import progress.message.msg.v24.DynamicHeader;
import progress.message.msg.v24.ErrorPayload;
import progress.message.msg.v24.FlowControlPayload;
import progress.message.msg.v24.NackPayload;
import progress.message.msg.v24.Payload;
import progress.message.msg.v24.QueueFlowControlPayload;
import progress.message.msg.v24.SecureDynamicHeader;
import progress.message.msg.v24.SidebandData;
import progress.message.msg.v24.StaticHeader;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.CryptoInfoLinkedList;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.prAccessor;

public final class Mgram
implements Cloneable,
IMgram {
    static final int PROTECTED_HEADER_LEN = 8;
    static final int RRS_SEND = 0;
    static final int RRS_REQUEST = 2;
    static final int RRS_REPLY = 3;
    static final int AF_NONE = 0;
    static final int AF_STRING = 1;
    static final int AF_FIXED = 2;
    static final int AF_VAR = 3;
    static final int UNINITIALIZED_STATUS = 0;
    static final int STATIC_HEADER_INITIALIZED = 1;
    static final int DYNAMIC_HEADER_INITIALIZED = 2;
    static final int PAYLOAD_INITIALIZED = 3;
    static final int ID_LEN = 16;
    private int m_status = 0;
    private IMgramStatusListener m_listener = null;
    private StaticHeader m_staticHeader = null;
    private DynamicHeader m_dynamicHeader = null;
    private Payload m_payload = null;
    private boolean m_staticHeaderProtected = false;
    private boolean m_dynamicHeaderProtected = false;

    public Mgram(boolean initialize) {
        if (initialize) {
            this.m_staticHeader = new StaticHeader();
            this.m_dynamicHeader = new DefaultDynamicHeader(this);
            this.m_payload = new DefaultPayload(this);
        }
        this.setStatus(3);
    }

    public void setStaticHeader(StaticHeader sh) {
        this.m_staticHeader = sh;
        this.m_staticHeaderProtected = false;
    }

    public void setDynamicHeader(DynamicHeader dh) {
        this.m_dynamicHeader = dh;
        this.m_dynamicHeaderProtected = false;
    }

    public void setPayload(Payload p) {
        this.m_payload = p;
    }

    Mgram(byte[] value) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.initMgramFromStream(new ByteArrayInputStream(value));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Mgram m = (Mgram)super.clone();
        m.m_staticHeader = (StaticHeader)this.m_staticHeader.clone();
        m.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(m);
        m.m_payload = (Payload)this.m_payload.clone(m);
        m.m_staticHeaderProtected = false;
        m.m_dynamicHeaderProtected = false;
        return m;
    }

    @Override
    public Object shallowClone() throws CloneNotSupportedException {
        Mgram m = (Mgram)super.clone();
        m.m_staticHeader = (StaticHeader)this.m_staticHeader.shallowClone();
        m.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.shallowClone(m);
        m.m_payload = (Payload)this.m_payload.shallowClone(m);
        return m;
    }

    @Override
    public Object protectedClone() throws CloneNotSupportedException {
        this.m_staticHeaderProtected = true;
        this.m_dynamicHeaderProtected = true;
        Mgram m = (Mgram)super.clone();
        m.m_payload = (Payload)this.m_payload.protectedClone(m);
        return m;
    }

    @Override
    public void protect() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public void protectSideband() {
        this.m_payload.protectSideband();
    }

    private void unprotectStaticHeader() {
        if (this.m_staticHeaderProtected) {
            try {
                this.m_staticHeader = (StaticHeader)this.m_staticHeader.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            this.m_staticHeaderProtected = false;
        }
    }

    private void unprotectDynamicHeader() {
        if (this.m_dynamicHeaderProtected) {
            try {
                this.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(this);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            this.m_dynamicHeaderProtected = false;
        }
    }

    @Override
    public void unprotectSuccessor() {
        this.unprotectStaticHeader();
    }

    @Override
    public void initMgramFromStream(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.initMgramFromStream(is, null, null, null, false, null);
    }

    @Override
    public void initMgramFromStream(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert, StreamUtilCounter sc) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        this.m_staticHeader = Mgram.initStaticHeaderFromStream(is, this.m_listener, tteTTLConvert, this);
        if (this.getType() == 4) {
            return;
        }
        this.m_dynamicHeader = Mgram.initDynamicHeaderFromStream(is, this.m_staticHeader, mp, this);
        this.m_payload = Mgram.initPayloadFromStream(is, sis, mp, csc, this.m_staticHeader, this.m_dynamicHeader, this);
    }

    public static StaticHeader initStaticHeaderFromStream(InputStream is, IMgramStatusListener ml, boolean tteTTLConvert, Mgram m) throws IOException, EMgramVersionMismatch {
        StaticHeader result = new StaticHeader(ml, m);
        result.initStaticHeaderFromStream(is, tteTTLConvert);
        return result;
    }

    public static DynamicHeader initDynamicHeaderFromStream(InputStream is, StaticHeader sh, IMessageProtection mp, Mgram m) throws IOException, EMgramVersionMismatch {
        DynamicHeader result = null;
        if (sh.isSecure()) {
            result = new SecureDynamicHeader(m, mp);
            result.initDynamicHeaderFromStream(is);
        } else {
            result = new DefaultDynamicHeader(m);
            result.initDynamicHeaderFromStream(is);
        }
        return result;
    }

    public static Payload initPayloadFromStream(InputStream is, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, StaticHeader sh, DynamicHeader dh, Mgram m) throws EMgramFormatError, IOException {
        Payload result = null;
        switch (sh.getType()) {
            case 4: {
                return null;
            }
            case 18: 
            case 19: {
                result = new QueueFlowControlPayload(m);
                break;
            }
            case 6: {
                result = new FlowControlPayload(m);
                break;
            }
            case 3: 
            case 14: {
                result = new AckPayload(m);
                break;
            }
            case 20: {
                result = new NackPayload(m);
                break;
            }
            case -1: {
                result = new ErrorPayload(m);
                break;
            }
            default: {
                result = new DefaultPayload(m);
            }
        }
        if (sh.isSecure()) {
            Mgram.decryptSecurePayload(is, dh, result, sis, mp, csc);
            Mgram.verifyMacs(mp, csc, sh, dh, result);
        } else {
            result.initPayloadFromStream(is);
        }
        return result;
    }

    public static Mgram unserialize(boolean canBeEncrypted, DataInput in) throws IOException {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public void serialize(DataOutput out) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    private static Payload decryptSecurePayload(InputStream is, DynamicHeader dh, Payload p, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc) throws ESecurityGeneralException, IOException, EMgramFormatError {
        byte security = dh.getSecurity();
        if (SecurityLogic.isMKeyDigest(security) || SecurityLogic.isMKeyMacHeader(security)) {
            mp.decryptWithSessionKey(dh.getMessageKey(), 0, dh.getSubjKeyLen(), dh.getMessageKey(), 0);
            if (SecurityLogic.isMKeyEncryption(security)) {
                byte[] copyKey = new byte[dh.getSubjKeyLen()];
                System.arraycopy(dh.getMessageKey(), 0, copyKey, 0, dh.getSubjKeyLen());
                sis.setMessageKey(copyKey);
                sis.bytesExpected(dh.getMessageLength() + dh.getMessagePad());
                p.initPayloadFromStream(sis.getInputStream());
                return p;
            }
        } else if (SecurityLogic.isSKeyEncryption(security)) {
            sis.useSessionKey();
            sis.bytesExpected(dh.getMessageLength() + dh.getMessagePad());
            p.initPayloadFromStream(sis.getInputStream());
            return p;
        }
        p.initPayloadFromStream(is);
        return p;
    }

    private static void verifyMacs(IMessageProtection mp, ClientSecurityContext csc, StaticHeader sh, DynamicHeader dh, Payload p) throws ESecurityGeneralException, EIntegrityCompromised {
        boolean verified;
        byte[] DigestKey;
        boolean verified2;
        CryptoInfoLinkedList macLinkedList = null;
        byte security = dh.getSecurity();
        if (SecurityLogic.isSKeyDigest(security) || SecurityLogic.isMKeyDigest(security)) {
            macLinkedList = Mgram.createMacInfoLinkedList(p);
        }
        if (SecurityLogic.isSKeyDigest(security) ? !(verified2 = mp.verifyMac(DigestKey = csc.getDigestKey(), 0, DigestKey.length, macLinkedList, dh.getDigest(), 0, dh.getDigestLen())) : (SecurityLogic.isMKeyDigest(security) ? !(verified = mp.verifyMac(dh.getMessageKey(), 0, dh.getSubjKeyLen(), macLinkedList, dh.getDigest(), 0, dh.getDigestLen())) : SecurityLogic.isMKeyMacHeader(security) && !(verified = mp.verifyMac(dh.getMessageKey(), 0, dh.getSubjKeyLen(), sh.getRawHeader(), 0, 8, dh.getDigest(), 0, dh.getDigestLen())))) {
            throw new EIntegrityCompromised();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] calculateMac(byte[] key, IMessageProtection mp) throws ESecurityGeneralException {
        CryptoInfoLinkedList macLinkedList = Mgram.createMacInfoLinkedList(this.m_payload);
        IMessageProtection iMessageProtection = mp;
        synchronized (iMessageProtection) {
            byte[] result = new byte[mp.getHashSize()];
            mp.mac(key, 0, key.length, macLinkedList, result, 0, result.length);
            return result;
        }
    }

    private void recalculatePad(IMessageProtection mp) {
        int length = this.m_payload.length();
        int newSize = mp.getOutputSize(length);
        this.m_dynamicHeader.setMessagePad(newSize - length);
    }

    private static CryptoInfoLinkedList createMacInfoLinkedList(Payload p) {
        return p.createMacInfoLinkedList();
    }

    @Override
    public IQueueFlowControlHandle getQueueFlowControlHandle() {
        return this.m_payload.getQueueFlowControlHandle();
    }

    @Override
    public IFlowControlHandle getFlowControlHandle() {
        return this.m_payload.getFlowControlHandle();
    }

    @Override
    public IPTPFlowControlHandle getPTPFlowControlHandle() {
        return null;
    }

    @Override
    public IAckHandle getAckHandle() {
        return this.m_payload.getAckHandle();
    }

    @Override
    public synchronized IAckListHandle getAckListHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IFailoverStatusNotificationHandle getFailoverStatusNotificationHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IIDRHandle getIDRHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IConnectionSyncHandle getConnectionSyncHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public ITXNRequestHandle getTXNRequestHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IExtendedTXNRequestHandle getExtendedTXNRequestHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IWindowAckHandle getWindowAckHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IBrokerHandle getBrokerHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IJMSClientHandle getJMSClientHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IStateEventHandle getStateEventHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IOperationHandle getOperationHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public final synchronized IBatchHandle getBatchHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IRoutingHandle getRoutingHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IReplicatedMgramHandle getReplicatedMgramHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean supportsRouting() {
        return false;
    }

    @Override
    public boolean supportsOperationHandle() {
        return false;
    }

    @Override
    public ISaverOpHandle getSaverOpHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IMessageProtection getMessageProtection() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public IErrorHandle getErrorHandle() {
        return this.m_payload.getErrorHandle();
    }

    @Override
    public IMgramConverterHandle getMgramConverterHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isSecure() {
        return this.m_staticHeader.isSecure();
    }

    @Override
    public boolean isGuarenteed() {
        return this.m_staticHeader.isGuarenteed();
    }

    @Override
    public long getGuarenteedTrackingNum() {
        return this.m_payload.getGuarenteedTrackingNum();
    }

    @Override
    public void setSuccessor(boolean value) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setSuccessor(value);
    }

    @Override
    public byte getSecurity() {
        return this.m_dynamicHeader.getSecurity();
    }

    @Override
    public int getMessageLength() {
        return this.m_dynamicHeader.getMessageLength();
    }

    @Override
    public int getBodyLength() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int getMessagePad() {
        return this.m_dynamicHeader.getMessagePad();
    }

    @Override
    public void setMessageKey(byte[] key) {
        this.m_dynamicHeader.setMessageKey(key);
    }

    @Override
    public byte[] getMessageKey() {
        return this.m_dynamicHeader.getMessageKey();
    }

    public int getDestinationAddressFormat() {
        return this.m_staticHeader.getDestinationAddressFormat();
    }

    public byte[] getDestinationAddress() {
        return this.m_payload.getDestinationAddress();
    }

    public void setDestinationAddress(byte[] address, int daf) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setDestinationAddressFormat(daf);
        this.m_payload.setDestinationAddress(address);
    }

    public int getSourceAddressFormat() {
        return this.m_staticHeader.getSourceAddressFormat();
    }

    @Override
    public int getRequestReplyFieldType() {
        return this.m_staticHeader.getRequestReplyFieldType();
    }

    @Override
    public byte getType() {
        return this.m_staticHeader.getType();
    }

    @Override
    public void setType(byte type) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setType(type);
    }

    @Override
    public void sync() {
        this.unprotectStaticHeader();
        this.unprotectDynamicHeader();
        this.m_staticHeader.sync();
        this.m_dynamicHeader.sync();
        this.m_payload.sync();
    }

    @Override
    public boolean hasTxn() {
        return this.m_staticHeader.hasTxn();
    }

    public boolean isTransactionalPublish() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public void setTxnPublish(int tid, int txnseq) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public int getTxnPublishTid() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public int getTxnPublishTidSeqNo() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public long getSequenceNumber() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public void setSequenceNumber(long sequence_number) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public void setAckNoReply(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public boolean isAckNoReply() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int getChannel() {
        return this.m_staticHeader.getChannel();
    }

    @Override
    public void setChannel(int channel) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setChannel(channel);
    }

    @Override
    public boolean isPostSV22() {
        return this.m_staticHeader.isPostSV22();
    }

    @Override
    public boolean hasSessionVer() {
        return this.m_staticHeader.hasSessionVer();
    }

    @Override
    public void setSessionVer(byte version) {
        this.m_staticHeader.setSessionVer(version);
    }

    public void setSenderID(long id) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public long getSenderID() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public boolean isFromDB() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public void setFromDB(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public Object getLogEvent() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public void setLogEvent(Object event) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isReply() {
        return this.m_staticHeader.isReply();
    }

    @Override
    public boolean isRequest() {
        return this.m_staticHeader.isRequest();
    }

    @Override
    public boolean isSend() {
        return this.m_staticHeader.isSend();
    }

    @Override
    public byte getPriority() {
        return this.m_staticHeader.getPriority();
    }

    public byte[] getPayload() {
        if (this.m_payload != null) {
            return this.m_payload.toByteArray();
        }
        return null;
    }

    public byte[] getDynamicHeader() {
        if (this.m_dynamicHeader != null) {
            return this.m_dynamicHeader.toByteArray();
        }
        return null;
    }

    @Override
    public int getRouteLimit() {
        return this.m_staticHeader.getRouteLimit();
    }

    @Override
    public void setRouteLimit(int routeLimit) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setRouteLimit(routeLimit);
    }

    @Override
    public boolean isSuccessor() {
        return this.m_staticHeader.isSuccessor();
    }

    @Override
    public boolean isJMSPersistent() {
        return this.m_staticHeader.isJMSPersistent();
    }

    @Override
    public boolean isPubSub() {
        return this.getType() == 2;
    }

    @Override
    public boolean isPTP() {
        return this.getType() == 12;
    }

    @Override
    public int getReplyPriority() {
        return this.m_payload.getReplyPriority();
    }

    @Override
    public void setReplyPriority(int priority) {
        this.m_payload.setReplyPriority(priority);
    }

    @Override
    public boolean isTTE() {
        return this.m_staticHeader.getTTE() != 0L;
    }

    @Override
    public long getTTE() {
        return this.m_staticHeader.getTTE();
    }

    @Override
    public void setTTE(long time) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setTTE(time);
    }

    @Override
    public void removeTTE() {
        this.unprotectStaticHeader();
        this.m_staticHeader.enableTTE(false);
    }

    @Override
    public void setDiscardable(boolean value) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setDiscardable(value);
    }

    @Override
    public boolean isDiscardable() {
        return this.m_staticHeader.isDiscardable();
    }

    @Override
    public final void setRejectable(boolean rejectable) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public final boolean isRejectable() {
        return false;
    }

    @Override
    public final synchronized void setInstrumented(boolean instrumented) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public final synchronized boolean isInstrumented() {
        return false;
    }

    @Override
    public void setJMSPersistent(boolean value) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setJMSPersistent(value);
    }

    @Override
    public void setSecurityAttribute(byte value) {
        this.m_dynamicHeader.setSecurityAttributeByte(value);
    }

    @Override
    public void setMgramSecure(IMessageProtection mp) {
        this.unprotectStaticHeader();
        this.unprotectDynamicHeader();
        this.m_staticHeader.setMgramSecure(true);
        this.m_dynamicHeader = this.m_dynamicHeader.getSecureDynamicHeader(mp);
    }

    @Override
    public void setMgramNonSecure() {
        this.unprotectStaticHeader();
        this.unprotectDynamicHeader();
        this.m_staticHeader.setMgramSecure(false);
        this.m_dynamicHeader = this.m_dynamicHeader.getNonSecureDynamicHeader();
    }

    @Override
    public void setPriority(byte value) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setPriority(value);
    }

    @Override
    public boolean hasSubject() {
        return this.m_payload.hasSubject();
    }

    @Override
    public ISubject getSubject() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int getSubjectFormat() {
        return this.m_staticHeader.getDestinationAddressFormat();
    }

    public void setSubject(String subject) {
        this.m_payload.setSubject(subject);
    }

    public void setSubject(String subject, int format) {
        throw new EAssertFailure("INVALID OPERATION.");
    }

    @Override
    public void setSubject(ISubject subject, int format) {
        throw new EAssertFailure("INVALID OPERATION.");
    }

    @Override
    public boolean hasBody() {
        return this.m_payload.hasBody();
    }

    @Override
    public void setBody(byte[] body) {
        if (body != null) {
            this.setBody(body, body.length);
        } else {
            this.setBody(body, 0);
        }
    }

    @Override
    public void setBody(byte[] body, int length) {
        this.m_payload.setBody(body, length);
    }

    @Override
    public int getPayloadLength() {
        if (this.m_payload == null) {
            return -1;
        }
        return this.m_payload.length();
    }

    @Override
    public void setSidebandData(ISidebandData sd) {
        this.m_payload.setSidebandData(sd);
    }

    @Override
    public ISidebandData getSidebandData() {
        return this.m_payload.getSidebandData();
    }

    @Override
    public ISidebandData getSidebandDataReadOnly() {
        return this.getSidebandData();
    }

    @Override
    public boolean hasSidebandData() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void createSidebandDataIfNeeded() {
        this.m_payload.createSidebandDataIfNeeded();
    }

    @Override
    public String getRouting() {
        SidebandData sd = (SidebandData)this.getSidebandData();
        if (sd != null) {
            return sd.getRouting();
        }
        return null;
    }

    @Override
    public boolean forRemoteNode(String localNodeName) {
        String node = this.getRouting();
        return node != null && !node.equals(localNodeName) && !node.equals("");
    }

    @Override
    public String getCorrectedRemoteNode(String localNodeName) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public byte[] getRawBody() {
        return this.m_payload.getRawBodyBuffer();
    }

    @Override
    public boolean hasID() {
        return this.m_staticHeader.hasID();
    }

    @Override
    public void setID(byte[] value) {
        this.unprotectStaticHeader();
        this.m_staticHeader.enableID();
        this.m_payload.setID(value);
    }

    @Override
    public byte[] getID() {
        return this.m_payload.getID();
    }

    @Override
    public void clearID() {
        this.m_payload.clearID();
    }

    public void clearAddresses() {
        this.unprotectStaticHeader();
        this.m_staticHeader.clearAddresses();
        this.m_payload.clearAddresses();
    }

    @Override
    public void setRequestReplySend() {
        this.unprotectStaticHeader();
        this.m_staticHeader.setRequestReplyType(0);
    }

    @Override
    public void setRequestReplyReply() {
        this.unprotectStaticHeader();
        this.m_staticHeader.setRequestReplyType(3);
    }

    @Override
    public void setGuarenteed(long tracking) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setGuarenteed(true);
        this.m_payload.setGuarenteed(tracking);
    }

    @Override
    public void setReliable() {
        this.unprotectStaticHeader();
        this.m_staticHeader.setGuarenteed(false);
        this.m_payload.setGuarenteed(0L);
    }

    @Override
    public void setTxn(int tid) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setTxn(true);
        this.m_payload.setTxn(tid);
    }

    @Override
    public int getTxnId() {
        return this.m_payload.getTxnId();
    }

    @Override
    public void removeTxn() {
        this.unprotectStaticHeader();
        this.m_staticHeader.setTxn(false);
    }

    @Override
    public void setRequest(long tracking, String subject) {
        throw new EAssertFailure("INVALID OPERATION.");
    }

    @Override
    public int serializedLength() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int memoryLength() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void saveMemory() {
    }

    @Override
    public int networkLength() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public ISubject getReplySubject() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public byte[] getReplyToAddress() {
        return this.m_payload.getReplyToAddress();
    }

    public int getReplyToAddressFormat() {
        return this.m_payload.getReplyToAddressFormat();
    }

    public void setReplyToAddressFormat(int type) {
        this.m_payload.setReplyToAddressFormat(type);
    }

    public String getReplyToAddressString() {
        return this.m_payload.getReplyToAddressString();
    }

    public void setReplyToString(String value) {
        this.m_payload.setReplyToString(value);
    }

    @Override
    public void setReply(IMgram nm) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int getReplyFormat() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setReplyFormat(int format) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setRequestReplyType(int type) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setRequestReplyType(type);
    }

    @Override
    public int getReplyTracking() throws ENoTrackingNum {
        if (!this.m_staticHeader.canHaveReplyTracking() || !this.m_payload.canHaveReplyTracking()) {
            throw new ENoTrackingNum();
        }
        byte[] address = this.m_payload.getDestinationAddress();
        int p = address.length - 4;
        return ArrayUtil.readInt(address, p);
    }

    public int getReplyToAddressTracking() throws ENoTrackingNum {
        byte[] address = this.m_payload.getReplyToAddress();
        int p = address.length - 4;
        return ArrayUtil.readInt(address, p);
    }

    @Override
    public void writeMgramToNetworkStream(OutputStream os, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        this.writeMgramToStream(os, csc, sos, mp, true);
    }

    @Override
    public void writeMgramToNetworkStream(OutputStream os, int channel, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
    }

    @Override
    public void writeMgramToStream(OutputStream os) throws IOException {
        this.writeMgramToStream(os, null, null, null, false);
    }

    @Override
    public void writeMgramToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeMgramToStream(os, null, null, null, tteTTLConvert);
    }

    @Override
    public void writeMgramToStream(OutputStream os, ClientSecurityContext csc, ISecureOutputStream sos, IMessageProtection mp, boolean tteTTLConvert) throws IOException {
        this.writeStaticHeaderToStream(os, tteTTLConvert);
        if (this.m_staticHeader.getType() == 4) {
            return;
        }
        this.writeDynamicHeaderToStream(os, csc, mp, null);
        this.writePayloadToStream(os, sos);
    }

    @Override
    public void writeStaticHeaderToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.m_staticHeader.writeToStream(os, -1, tteTTLConvert);
    }

    @Override
    public void writeDynamicHeaderToStream(OutputStream os, ClientSecurityContext csc, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        if (this.isSecure()) {
            if (SecurityLogic.isSKeyDigest(this.getSecurity())) {
                byte[] sessionKey = csc.getSessionKey();
                byte[] key = new byte[sessionKey.length];
                System.arraycopy(sessionKey, 0, key, 0, sessionKey.length);
                byte[] mac = this.calculateMac(csc.getDigestKey(), mp);
                this.m_dynamicHeader.setMessageDigest(mac);
            }
            this.recalculatePad(mp);
            this.m_dynamicHeader.writeToStream(os, mp);
        } else {
            this.m_dynamicHeader.writeToStream(os);
        }
    }

    @Override
    public void writePayloadToStream(OutputStream os, ISecureOutputStream sos) throws IOException {
        if (this.isSecure()) {
            if (SecurityLogic.isSKeyEncryption(this.getSecurity())) {
                sos.useSessionKey();
                OutputStream ios = sos.getOutputStream();
                this.m_payload.writeToStream(ios);
                ios.flush();
            } else {
                this.m_payload.writeToStream(os);
            }
        } else {
            this.m_payload.writeToStream(os);
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] staticHeader = this.m_staticHeader.toByteArray();
        byte[] dynamicHeader = this.m_dynamicHeader.toByteArray();
        byte[] payload = this.m_payload.toByteArray();
        int staticLength = staticHeader.length;
        int dynamicLength = dynamicHeader.length;
        int payloadLength = payload.length;
        int totalLength = staticLength + dynamicLength + payloadLength;
        byte[] newByteArray = new byte[totalLength];
        System.arraycopy(staticHeader, 0, newByteArray, 0, staticLength);
        System.arraycopy(dynamicHeader, 0, newByteArray, staticLength, dynamicLength);
        System.arraycopy(payload, 0, newByteArray, staticLength + dynamicLength, payloadLength);
        return newByteArray;
    }

    @Override
    public byte getVersion() {
        return this.m_staticHeader.getVersion();
    }

    @Override
    public byte getSessionVersion() {
        return this.m_staticHeader.getSessionVersion();
    }

    public void setPostV22() {
        this.m_staticHeader.setPostV22(true);
    }

    void setVersion(byte version) {
        this.unprotectStaticHeader();
        this.m_staticHeader.setVersion(version);
    }

    @Override
    public void setStatus(int value) {
        this.m_status = value;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    public static Mgram createMgram(InputStream is, byte[] buffer, ISecureInputStream sis, IMessageProtection mp, ClientSecurityContext csc, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        Mgram mgram = new Mgram(false);
        mgram.initMgramFromStream(is, sis, mp, csc, tteTTLConvert, null);
        return mgram;
    }

    @Override
    public void dump() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public ObjectInput getPayloadInputStreamHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public ObjectOutput getPayloadOutputStreamHandle() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void writeMgramToStreamNonSecure(OutputStream os, boolean tteTTLConvert, MgramDeliveryContext ctx) throws IOException {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void writeMgramToNetworkStreamNonSecure(OutputStream os, int channel, boolean tteTTLConvert, MgramDeliveryContext ctx) throws IOException {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public void initMgramFromStreamNonSecure(byte version, InputStream is, boolean tteTTLConvert, StreamUtilCounter sc) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setEnqueuedSize(int size) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int getEnqueuedSize() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isEnqueuedSizeSet() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void removeEnqueuedSize() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean contains(Object obj) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public synchronized void setLimiterSizeIncrement(int size) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void markLimiterSize() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public int getLimiterSize() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isNonPersistentReplicated() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean requiresXOnceDelivery() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setNonPersistentReplicated(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean hasUndeliveredDestination() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setUndeliveredDestination(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isQueueMessage() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean hasStreamVersion() {
        return false;
    }

    @Override
    public byte getStreamVersion() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public byte getStreamFlags() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setStreamVersion(byte vers) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setStreamFlags(byte flags) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setCompressionEnabled(boolean b) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isCompressionEnabled() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public byte getCompressionId() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setCompressionId(byte vers) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setNoOutqueueExpire(boolean value) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean getNoOutqueueExpire() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public byte getReenqueueCount() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setReenqueueCount(byte reenqueues) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setDeliveryCancelled() {
    }

    @Override
    public boolean isDeliveryCancelled() {
        return false;
    }
}

