/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.msg.IAckHandle;
import progress.message.msg.v24.Mgram;
import progress.message.msg.v24.Payload;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.prAccessor;

final class NackPayload
extends Payload
implements IAckHandle {
    private static final int NACK_PAYLOAD_LENGTH = 6;
    private long m_trackingNum;
    private byte[] m_payload;

    public NackPayload(Mgram m) {
        super(m);
    }

    @Override
    void initPayloadFromStream(InputStream is) throws IOException, EMgramFormatError {
        this.m_payload = new byte[6];
        StreamUtil.readBytes(is, this.m_payload, 0, 6);
        this.m_trackingNum = ArrayUtil.read6ByteLong(this.m_payload, 0);
    }

    @Override
    byte[] toByteArray() {
        this.sync();
        byte[] result = new byte[6];
        System.arraycopy(this.m_payload, 0, result, 0, 6);
        return result;
    }

    @Override
    void sync() {
    }

    byte[] getRawPayload() {
        this.sync();
        return this.m_payload;
    }

    @Override
    void writeToStream(OutputStream os) throws IOException {
        this.sync();
        os.write(this.m_payload);
    }

    @Override
    public void setClientID(long id) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public long getClientID() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setErr(short err) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public short getErr() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public boolean isSubjectAck() {
        return false;
    }

    @Override
    public short getSubjectTracking() {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public void setSubjectTracking(short subjectTracking) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    @Override
    public long getTrackingNumber() {
        return this.m_trackingNum;
    }

    @Override
    public void setTrackingNumber(long number) {
        this.m_trackingNum = number;
        ArrayUtil.write6ByteLong(this.m_payload, 0, this.m_trackingNum);
    }

    @Override
    public IAckHandle getAckHandle() {
        return this;
    }
}

