/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.DefaultDynamicHeader;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.MgramCreator;
import progress.message.msg.v26.Payload;
import progress.message.msg.v26.SecureDynamicHeader;
import progress.message.msg.v26.SidebandData;
import progress.message.msg.v26.StaticHeader;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.SecurityLogic;

public class MgramConverter25
extends DebugObject
implements IMgramConverter {
    private IMgramConverter m_converter;
    private ClientSecurityContext m_csc;
    private ISecureInputStream m_sis;
    private ISecureOutputStream m_sos;
    private boolean m_tteTTLConvert;
    private IMessageProtection m_mp;
    private IMgramStatusListener m_listener;
    private boolean m_canBeEncrypted;
    private byte[] m_encryptedMessageKey;
    private IMessageProtection m_decryptMp;
    private StreamUtilCounter m_counter = null;

    public MgramConverter25() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        super(DebugState.GLOBAL_DEBUG_ON ? "MgramConverter25" : null);
        Class<?> converterClass = Class.forName("progress.message.msg.v25.MgramCreator");
        this.m_converter = (IMgramConverter)converterClass.newInstance();
    }

    @Override
    public IMgram createMgram(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (this.m_counter != null) {
            this.m_counter.resetCounter();
        }
        Mgram result = new Mgram(false);
        progress.message.msg.v25.Mgram oldMgram = progress.message.msg.v25.Mgram.createMgram(is, this.m_sis, this.m_mp, this.m_csc, this.m_listener, this.m_counter, this.m_tteTTLConvert);
        if (oldMgram.supportsOperationHandle()) {
            int size = StreamUtil.readInt(is);
            for (int count = 0; count < size; ++count) {
                IMgram payload = this.createMgram(is);
                oldMgram.getOperationHandle().addMgram(payload);
            }
        }
        byte[] oldShArray = oldMgram.getMgramConverterHandle().getInternalStaticHeader();
        byte[] newSh = this.createV26sh(oldShArray);
        result.setStaticHeader(newSh);
        if (this.m_tteTTLConvert) {
            result.getTTE();
        }
        if (StaticHeader.getType(newSh) != 4) {
            DynamicHeader newDh = this.createV26dh(oldMgram.isSecure(), this.m_mp, oldMgram.getMgramConverterHandle().getInternalDynamicHeader(), null, null, result);
            result.setDynamicHeader(newDh);
            this.setV26Payload(oldMgram, result);
        } else if (StaticHeader.hasSessionVer(newSh)) {
            result.setSessionVer(StreamUtil.readByte(is));
        }
        return result;
    }

    void setV26Payload(IMgram oldMgram, Mgram newMgram) throws IOException {
        HashMap oldPayload = oldMgram.getMgramConverterHandle().getInternalPayload().getPayloadProperties();
        Payload newPayload = MgramCreator.getPayloadObject(oldMgram.getType(), newMgram);
        newMgram.setPayload(newPayload);
        if (newPayload != null) {
            progress.message.msg.v25.SidebandData oldSideband;
            newMgram.getMgramConverterHandle().getInternalPayload().setPayloadProperties(oldPayload);
            newPayload.initRemainingPayload();
            newPayload.sync();
            if ((oldMgram.getType() == 2 || oldMgram.getType() == 12 || oldMgram.getType() == 25) && (oldSideband = (progress.message.msg.v25.SidebandData)oldMgram.getSidebandData()) != null) {
                String oldRouting = oldSideband.getAllRoutingString();
                SidebandData newSideband = this.createV26Sideband(oldSideband);
                newMgram.setSidebandData(newSideband);
                newMgram.getRoutingHandle().setGSAPublication(oldSideband.isGSAPublication());
                newMgram.getRoutingHandle().setRouting(oldRouting);
            }
        }
    }

    progress.message.msg.v25.Payload setV25Payload(progress.message.msg.v25.Mgram oldMgram, IMgram newMgram) {
        HashMap newPayload = newMgram.getMgramConverterHandle().getInternalPayload().getPayloadProperties();
        progress.message.msg.v25.Payload oldPayload = progress.message.msg.v25.MgramCreator.getPayloadObject(newMgram.getType(), oldMgram);
        oldMgram.setPayload(oldPayload);
        if (oldPayload != null) {
            ISidebandData newSideband;
            newPayload.remove("DP_SIDEBAND_DATA");
            oldMgram.getMgramConverterHandle().getInternalPayload().setPayloadProperties(newPayload);
            if ((oldMgram.getType() == 2 || oldMgram.getType() == 12 || oldMgram.getType() == 25) && (newSideband = newMgram.getSidebandData()) != null) {
                progress.message.msg.v25.SidebandData oldSideband = this.createV25Sideband(newSideband);
                oldSideband.setRouting(newMgram.getRoutingHandle().getAllRoutingString());
                oldSideband.setGSAPublication(newMgram.getRoutingHandle().isGSAPublication());
                oldMgram.setSidebandData(oldSideband);
            }
        }
        return oldPayload;
    }

    progress.message.msg.v25.DynamicHeader createV25dh(boolean isSecure, IMessageProtection mp, IMgramConverterHandle.IDynamicHeader newDh, byte[] encryptedMessageKey, byte[] digest, progress.message.msg.v25.Mgram oldMgram) throws IOException {
        progress.message.msg.v25.DynamicHeader dh = new progress.message.msg.v25.DefaultDynamicHeader(oldMgram);
        dh.setMessageLength(newDh.getMessageLength());
        if (isSecure) {
            dh = new progress.message.msg.v25.SecureDynamicHeader(mp, dh);
            if (digest != null) {
                dh.setMessageDigest(digest);
            } else {
                dh.setMessageDigest(newDh.getDigest());
            }
            if (encryptedMessageKey != null) {
                dh.setMessageKey(encryptedMessageKey);
            } else {
                dh.setMessageKey(newDh.getMessageKey());
            }
            dh.setMessagePad(newDh.getMessagePad());
            dh.setSecurityAttributeByte(newDh.getSecurity());
        }
        return dh;
    }

    DynamicHeader createV26dh(boolean isSecure, IMessageProtection mp, IMgramConverterHandle.IDynamicHeader oldDh, byte[] encryptedMessageKey, byte[] digest, Mgram newMgram) throws IOException {
        DynamicHeader dh = new DefaultDynamicHeader(newMgram);
        dh.setMessageLength(oldDh.getMessageLength());
        if (isSecure) {
            dh = new SecureDynamicHeader(mp, dh);
            if (digest != null) {
                dh.setMessageDigest(digest);
            } else {
                dh.setMessageDigest(oldDh.getDigest());
            }
            if (encryptedMessageKey != null) {
                dh.setMessageKey(encryptedMessageKey);
            } else {
                dh.setMessageKey(oldDh.getMessageKey());
            }
            dh.setMessagePad(oldDh.getMessagePad());
            dh.setSecurityAttributeByte(oldDh.getSecurity());
        }
        return dh;
    }

    SidebandData createV26Sideband(progress.message.msg.v25.SidebandData oldSideband) {
        oldSideband.setRouting(null);
        SidebandData newSideband = new SidebandData();
        newSideband.fromByteArray(oldSideband.getRawSidebandBuffer(), 0);
        return newSideband;
    }

    progress.message.msg.v25.SidebandData createV25Sideband(ISidebandData newSideband) {
        progress.message.msg.v25.SidebandData oldSideband = new progress.message.msg.v25.SidebandData();
        oldSideband.fromByteArray(newSideband.getRawSidebandBuffer(), 0);
        return oldSideband;
    }

    @Override
    public IMgram createMgram(byte version, InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return null;
    }

    private void writeMgramToNetworkStream(IMgram m, int channel, OutputStream os) throws IOException {
        if (m.getVersion() != 25) {
            progress.message.msg.v25.Mgram oldMgram = this.createv25Mgram(m, channel);
            oldMgram.writeMgramToStream(os, this.m_csc, this.m_sos, this.m_mp, this.m_tteTTLConvert);
        } else {
            m.writeMgramToStream(os, this.m_csc, this.m_sos, this.m_mp, this.m_tteTTLConvert);
        }
    }

    private progress.message.msg.v25.Mgram createv25Mgram(IMgram m, int channel) throws IOException {
        progress.message.msg.v25.Mgram oldMgram = new progress.message.msg.v25.Mgram(false);
        byte[] oldSh = this.createV25sh(m, channel);
        oldMgram.setStaticHeader(oldSh);
        IMgramConverterHandle.IDynamicHeader newDh = m.getMgramConverterHandle().getInternalDynamicHeader();
        boolean isSecure = m.isSecure();
        if (isSecure) {
            m.getMgramConverterHandle().recalculatePad(this.m_mp);
        }
        oldMgram.setDynamicHeader(this.createV25dh(isSecure, this.m_mp, newDh, null, null, oldMgram));
        this.setV25Payload(oldMgram, m);
        return oldMgram;
    }

    private void messageKeySlicedDelivery(IMgram mParam, int channel, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        IMgram m = mParam;
        if (SecurityLogic.isMKeyEncryption(m.getSecurity()) || m.getBrokerHandle().isGuarFormatIncorrect()) {
            try {
                m = (IMgram)m.protectedClone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        if (SecurityLogic.isMKeyEncryption(m.getSecurity())) {
            m.getBrokerHandle().decryptMessageWithMessageKey(this.m_decryptMp);
        }
        if (m.getBrokerHandle().isGuarFormatIncorrect()) {
            m.getBrokerHandle().setGuarFormatIncorrect(false);
            if (!m.isGuarenteed()) {
                m.setGuarenteed(m.getBrokerHandle().getDbTracking());
            } else {
                m.setReliable();
            }
        }
        progress.message.msg.v25.Mgram oldMgram = this.createv25Mgram(m, channel);
        IMgramConverterHandle mch = oldMgram.getMgramConverterHandle();
        if (SecurityLogic.isMKeyDigest(oldMgram.getSecurity())) {
            oldMgram.getBrokerHandle().macMessageWithMessageKey(this.m_mp);
            if (SecurityLogic.isMKeyEncryption(oldMgram.getSecurity())) {
                oldMgram.getBrokerHandle().encryptMessageWithMessageKey(this.m_mp);
            }
        } else if (SecurityLogic.isMKeyMacHeader(oldMgram.getSecurity())) {
            oldMgram.getBrokerHandle().macHeaderWithMessageKey(this.m_mp);
        }
        oldMgram.getBrokerHandle().encryptMessageKey(this.m_encryptedMessageKey, this.m_mp);
        mch.getInternalDynamicHeader().setMessageKey(this.m_encryptedMessageKey);
        mch.recalculatePad(this.m_mp);
        oldMgram.writeMgramToStream(os, this.m_csc, this.m_sos, this.m_mp, this.m_tteTTLConvert);
        this.deliverSecureOperationPayloads(m, channel, this.m_csc, os, ctx);
    }

    private void sessionKeySlicedDelivery(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        progress.message.msg.v25.Mgram oldMgram = this.createv25Mgram(m, channel);
        IMgramConverterHandle mch = oldMgram.getMgramConverterHandle();
        mch.recalculatePad(this.m_mp);
        byte[] mac = null;
        if (SecurityLogic.isSKeyDigest(m.getSecurity())) {
            mac = mch.calculateMac(csc.getDigestKey(), this.m_mp);
        }
        mch.getInternalDynamicHeader().setMessageDigest(mac);
        oldMgram.writeMgramToStream(os, csc, this.m_sos, this.m_mp, this.m_tteTTLConvert);
        this.deliverSecureOperationPayloads(m, channel, csc, os, ctx);
    }

    @Override
    public void secureDeliver(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        if (m == null) {
            return;
        }
        if (m.getType() == 27) {
            Iterator iter = m.getBatchHandle().getBatchIterator();
            while (iter.hasNext()) {
                this.secureDeliver((IMgram)iter.next(), channel, csc, os, ctx);
            }
        } else {
            if (ctx != null && ctx.protocolAdapter != null && ctx.protocolAdapter.makeProtocolCorrections(m, ctx)) {
                while (ctx.protocolAdapter.hasCorrected()) {
                    this.secureDeliver(ctx.protocolAdapter.getNextCorrected(), channel, csc, os, null);
                }
                return;
            }
            if (m.isSecure() && (SecurityLogic.isMKeyMacHeader(m.getSecurity()) || SecurityLogic.isMKeyDigest(m.getSecurity()))) {
                this.messageKeySlicedDelivery(m, channel, os, ctx);
            } else if (m.isSecure() && (SecurityLogic.isSKeyDigest(m.getSecurity()) || SecurityLogic.isSKeyEncryption(m.getSecurity()))) {
                this.sessionKeySlicedDelivery(m, channel, csc, os, ctx);
            } else {
                this.writeMgramToNetworkStream(m, channel, os);
                this.deliverSecureOperationPayloads(m, channel, csc, os, ctx);
            }
        }
    }

    @Override
    public void deliver(IMgram m, OutputStream os) throws IOException {
        this.deliver(m, -1, os, null);
    }

    @Override
    public void deliver(IMgram mParam, int channel, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        IMgram m = mParam;
        if (m == null) {
            return;
        }
        if (m.getType() == 27) {
            Iterator iter = m.getBatchHandle().getBatchIterator();
            while (iter.hasNext()) {
                this.deliver((IMgram)iter.next(), channel, os, ctx);
            }
        } else {
            if (ctx != null && ctx.protocolAdapter != null && ctx.protocolAdapter.makeProtocolCorrections(m, ctx)) {
                while (ctx.protocolAdapter.hasCorrected()) {
                    this.deliver(ctx.protocolAdapter.getNextCorrected(), channel, os, null);
                }
                return;
            }
            this.writeMgramToNetworkStream(m, channel, os);
            if (m.supportsOperationHandle()) {
                LinkedList ll = m.getOperationHandle().getMgramList();
                if (ll != null) {
                    StreamUtil.writeInt(ll.size(), os);
                    for (int count = 0; count < ll.size(); ++count) {
                        m = (IMgram)ll.get(count);
                        this.deliver(m, channel, os, ctx);
                    }
                } else {
                    StreamUtil.writeInt(0, os);
                }
            }
        }
    }

    @Override
    public IMgram unserialize(InputStream in, boolean tteTTLConvert) throws IOException {
        return this.unserialize(in);
    }

    public IMgram unserialize(InputStream is) throws IOException {
        IMgram result = this.unserializeInternal(is);
        if (result.supportsOperationHandle()) {
            int size = StreamUtil.readInt(is);
            for (int count = 0; count < size; ++count) {
                byte version = StreamUtil.readByte(is);
                IMgram payload = this.unserializeInternal(is);
                result.getOperationHandle().addMgram(payload);
            }
        }
        return result;
    }

    private IMgram unserializeInternal(InputStream in) throws IOException {
        Mgram result = new Mgram(false);
        IMgram oldMgram = progress.message.msg.v25.Mgram.unserialize(in);
        boolean mgramDecrypted = false;
        boolean isSecure = oldMgram.isSecure();
        if (isSecure && SecurityLogic.isMKeyEncryption(oldMgram.getSecurity()) && oldMgram.getBrokerHandle().isEncrypted()) {
            oldMgram.getBrokerHandle().decryptMessageWithMessageKey(this.m_decryptMp);
            mgramDecrypted = true;
        }
        byte[] oldShArray = oldMgram.getMgramConverterHandle().getInternalStaticHeader();
        byte[] newSh = this.createV26sh(oldShArray);
        result.setStaticHeader(newSh);
        DynamicHeader newDh = this.createV26dh(oldMgram.isSecure(), this.m_mp, oldMgram.getMgramConverterHandle().getInternalDynamicHeader(), null, null, result);
        result.setDynamicHeader(newDh);
        this.setV26Payload(oldMgram, result);
        result.setStatus(3);
        if (isSecure && SecurityLogic.isMKeyDigest(oldMgram.getSecurity())) {
            result.getBrokerHandle().macMessageWithMessageKey(this.m_mp);
        }
        if (mgramDecrypted) {
            result.getBrokerHandle().encryptMessageWithMessageKey(this.m_mp);
        }
        return result;
    }

    @Override
    public void serialize(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
        throw new EAssertFailure("Unable to serialize v25 mgrams to the log or database");
    }

    private void deliverSecureOperationPayloads(IMgram mParam, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        IMgram m = mParam;
        if (m.supportsOperationHandle()) {
            LinkedList ll = m.getOperationHandle().getMgramList();
            if (ll != null) {
                StreamUtil.writeInt(ll.size(), os);
                for (int count = 0; count < ll.size(); ++count) {
                    m = (IMgram)ll.get(count);
                    this.secureDeliver(m, channel, csc, os, ctx);
                }
            } else {
                StreamUtil.writeInt(0, os);
            }
        }
    }

    public void writeMgramToStreamNonSecure(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
    }

    @Override
    public void initializeConverter(Hashtable properties) {
        this.m_csc = (ClientSecurityContext)properties.get(MgramConstants.CLIENT_SECURITY_CONTEXT);
        this.m_sis = (ISecureInputStream)properties.get(MgramConstants.SECURE_INPUT_STREAM);
        this.m_sos = (ISecureOutputStream)properties.get(MgramConstants.SECURE_OUTPUT_STREAM);
        this.m_mp = (IMessageProtection)properties.get(MgramConstants.MESSAGE_PROTECTION);
        if (this.m_mp != null) {
            this.m_encryptedMessageKey = new byte[this.m_mp.getOutputSize(this.m_mp.getSecretKeyLength())];
        }
        this.m_decryptMp = (IMessageProtection)properties.get(MgramConstants.DECRYPT_MESSAGE_PROTECTION);
        this.m_listener = (IMgramStatusListener)properties.get(MgramConstants.MGRAM_STATUS_LISTENER);
        Boolean tteTTL = (Boolean)properties.get(MgramConstants.TTE_TTL_CONVERT);
        this.m_tteTTLConvert = tteTTL != null ? tteTTL : false;
        Boolean canBeEncrypted = (Boolean)properties.get(MgramConstants.CAN_BE_ENCRYPTED);
        this.m_canBeEncrypted = canBeEncrypted != null ? canBeEncrypted : false;
        this.m_counter = new StreamUtilCounter(true);
        this.m_converter.initializeConverter(properties);
    }

    byte[] createV25sh(IMgram m, int channel) {
        byte[] v26 = m.getMgramConverterHandle().getInternalStaticHeader();
        byte[] v25 = new byte[v26.length];
        System.arraycopy(v26, 0, v25, 0, v26.length);
        progress.message.msg.v25.StaticHeader.setVersion((byte)25, v25);
        if (channel != -1) {
            progress.message.msg.v25.StaticHeader.setChannel(channel, v25);
        }
        return v25;
    }

    byte[] createV26sh(byte[] oldSh) {
        byte[] result = new byte[oldSh.length];
        System.arraycopy(oldSh, 0, result, 0, oldSh.length);
        StaticHeader.setVersion((byte)26, result);
        return result;
    }

    @Override
    public byte getVersion() {
        return 25;
    }
}

