/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.tcp;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Principal;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressSocket;
import progress.message.net.TCPProxy;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.zclient.SessionConfig;

public abstract class AbstractTcpSocket
extends ProgressSocket {
    public AbstractTcpSocket(Principal principal, String host, int port, Object properties, IHttpProxyConfig pConfig) throws UnknownHostException, IOException {
        this.m_impl = pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0 ? TCPProxy.connectProxy(host, port, null, -1, pConfig) : TCPProxy.connectProxy(host, port);
        if (this.m_impl == null) {
            this.m_impl = new Socket(host, port);
            if (ProgressInetAddress.debugIPAddress()) {
                ProgressInetAddress.showIPAddressDiagnostic("AbstractTcpSocket (" + this.getClass().getName() + ") opened connection to host = " + host + ", port = " + port + ", InetAddress = " + this.m_impl.getInetAddress());
            }
            try {
                this.m_impl.setTcpNoDelay(SessionConfig.TCP_NODELAY);
                if (SessionConfig.SOCKET_MAX_SEND_BUFFER_SIZE > 0) {
                    this.m_impl.setSendBufferSize(SessionConfig.SOCKET_MAX_SEND_BUFFER_SIZE);
                }
                if (SessionConfig.SOCKET_MAX_RCV_BUFFER_SIZE > 0) {
                    this.m_impl.setReceiveBufferSize(SessionConfig.SOCKET_MAX_RCV_BUFFER_SIZE);
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    protected AbstractTcpSocket(Socket socket) {
        this.m_impl = socket;
    }

    @Override
    public void setSoTimeout(int timeout) throws IOException {
        this.m_impl.setSoTimeout(timeout);
    }
}

