/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.jms.InvalidDestinationException;
import progress.message.jimpl.DestUtil;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

public class DraDestUtil {
    private static final String DEBUG_NAME = "DraDestUtil";
    public static String HTTP_PREFIX = "HTTP://";
    public static String HTTPS_PREFIX = "HTTPS://";
    public static final String HTTP_DEFAULT_PORT = "80";
    public static final String HTTPS_DEFAULT_PORT = "443";
    public static String HTTP_ROOT = SessionConfig.HTTP_ROOT;
    public static String HTTPS_ROOT = SessionConfig.HTTPS_ROOT;
    public static String ROUTING_ROOT = SessionConfig.ROUTING_ROOT;
    public static String TOPIC_ROOT = SessionConfig.TOPIC_ROOT;
    public static String QUEUE_ROOT = SessionConfig.QUEUE_ROOT;
    public static String TOPIC_RESOUCE_TYPE = SessionConfig.ACL_RESOURCE_TOPIC;
    public static String QUEUE_RESOUCE_TYPE = SessionConfig.ACL_RESOURCE_QUEUE;
    public static String NODE_RESOUCE_TYPE = SessionConfig.ACL_RESOURCE_NODE;
    public static String URL_RESOUCE_TYPE = SessionConfig.ACL_RESOURCE_URL;
    public static String SONIC_HTTP = SessionConfig.SONIC_HTTP;
    public static String SUBJECT_SONIC_URL_ALL = "$SONIC_URL_ALL";
    public static String HTTP_ALL = "http://#";
    public static String HTTPS_ALL = "https://#";
    public static String SUBJECT_RNN_ALL_HTTP_ALL = "$RNN.*.$HTTP.#";
    public static String SUBJECT_RNN_ALL_HTTPS_ALL = "$RNN.*.$HTTPS.#";

    public static boolean isHttpOrHttps(String destination) {
        return DraDestUtil.isHttpURL(destination) || DraDestUtil.isHttpsURL(destination);
    }

    public static boolean isSubjectURL(ISubject subject) {
        if (subject.isMultiSubject()) {
            return false;
        }
        String jmsName = subject.getJMSName();
        return DraDestUtil.isHttpOrHttps(jmsName);
    }

    private static boolean isHttpURL(String destination) {
        return destination.length() >= HTTP_PREFIX.length() && destination.substring(0, HTTP_PREFIX.length()).equalsIgnoreCase(HTTP_PREFIX);
    }

    private static boolean isHttpsURL(String destination) {
        return destination.length() >= HTTPS_PREFIX.length() && destination.substring(0, HTTPS_PREFIX.length()).equalsIgnoreCase(HTTPS_PREFIX);
    }

    private static String getRoutingNode(String name) {
        return DestUtil.getRoutingName(name);
    }

    private static String getLocalDestination(String name) {
        return DestUtil.getDestinationName(name);
    }

    private static String reverseDSN(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        int count = st.countTokens();
        String[] nodes = new String[count];
        for (int i = 0; i < count; ++i) {
            nodes[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer();
        int j = count - 1;
        while (true) {
            sb.append(nodes[j]);
            if (--j < 0) break;
            sb.append(".");
        }
        return sb.toString();
    }

    public static String resourceToSecSubject(String resourceType, String resourceName) {
        if (resourceType.equalsIgnoreCase(NODE_RESOUCE_TYPE)) {
            return resourceName;
        }
        String rnn = DraDestUtil.getRoutingNode(resourceName);
        if (!DraDestUtil.validateNodeName(rnn)) {
            return null;
        }
        String localDest = DraDestUtil.getLocalDestination(resourceName);
        String secSubject = null;
        if (resourceType.equalsIgnoreCase(TOPIC_RESOUCE_TYPE)) {
            secSubject = DraDestUtil.topicToSecSubject(rnn, localDest);
        } else if (resourceType.equalsIgnoreCase(QUEUE_RESOUCE_TYPE)) {
            secSubject = DraDestUtil.queueToSecSubject(rnn, localDest);
        } else if (resourceType.equalsIgnoreCase(URL_RESOUCE_TYPE)) {
            secSubject = DraDestUtil.httpUrlToSecSubject(rnn, localDest);
        }
        DebugObject.class_debug(DEBUG_NAME, "resourceToSecSubject() result is " + secSubject + " for resource: " + resourceName + ", type : " + resourceType);
        return secSubject;
    }

    private static boolean validateNodeName(String rnn) {
        int length;
        try {
            DestUtil.validateRoutingName(rnn);
        }
        catch (InvalidDestinationException e) {
            return false;
        }
        int n = length = rnn == null ? 0 : rnn.length();
        return length <= 0 || rnn.indexOf("*") == -1;
    }

    private static String getRNNSecSubject(String rnn) {
        if (rnn == null) {
            return null;
        }
        if ("".equals(rnn)) {
            return ROUTING_ROOT;
        }
        if ("#".equals(rnn)) {
            return ROUTING_ROOT + "*";
        }
        if (rnn.indexOf(".") != -1) {
            return ROUTING_ROOT + rnn.replace('.', '$');
        }
        return ROUTING_ROOT + rnn;
    }

    public static String topicToSecSubject(String rnn, String localDest) {
        return rnn == null ? localDest : DraDestUtil.getRNNSecSubject(rnn) + "." + TOPIC_ROOT + localDest;
    }

    public static String queueToSecSubject(String rnn, String localDest) {
        String dest = QUEUE_ROOT + localDest;
        return rnn == null ? dest : DraDestUtil.getRNNSecSubject(rnn) + "." + dest;
    }

    public static String httpUrlToSecSubject(String rnn, String localDest) {
        return DraDestUtil.httpUrlToSecSubject(rnn, localDest, true);
    }

    public static String httpUrlToSecSubject(String rnn, String localDest, boolean routingPrefix) {
        if (localDest != null && "#".equals(localDest) && (rnn == null || "#".equals(rnn))) {
            return SUBJECT_SONIC_URL_ALL;
        }
        String dsn = DraDestUtil.getDsnForAclEntry(localDest);
        if (dsn != null && !"".equals(dsn)) {
            dsn = DraDestUtil.reverseDSN(dsn.toLowerCase());
        }
        if (dsn == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (routingPrefix) {
            sb.append(DraDestUtil.getRNNSecSubject(rnn == null ? "#" : rnn)).append(".");
        }
        sb.append(DraDestUtil.isHttpsURL(localDest) ? HTTPS_ROOT : HTTP_ROOT);
        sb.append(dsn);
        return sb.toString();
    }

    public static String httpUrlToRoutingSubject(String destParam, boolean routingPrefix) {
        String dest = destParam;
        String protocol = null;
        String host = null;
        String port = null;
        String path = null;
        if (DraDestUtil.isHttpURL(dest)) {
            protocol = HTTP_ROOT;
            dest = dest.substring(HTTP_PREFIX.length());
        } else if (DraDestUtil.isHttpsURL(dest)) {
            protocol = HTTPS_ROOT;
            dest = dest.substring(HTTPS_PREFIX.length());
        } else {
            return null;
        }
        int index = -1;
        String addr = dest;
        index = dest.indexOf(47);
        if (index != -1) {
            addr = dest.substring(0, index);
            path = dest.substring(index);
            if (path.trim().length() == 1) {
                path = null;
            }
        }
        if (addr.startsWith("[")) {
            index = addr.indexOf("]");
            if (index > 0) {
                host = DraDestUtil.getCanonicalIPv6Address(addr.substring(0, index + 1));
                int portIdx = addr.lastIndexOf(58);
                if (portIdx > index) {
                    port = addr.substring(portIdx + 1);
                }
            }
        } else {
            index = addr.indexOf(58);
            if (index == -1) {
                host = addr;
            } else {
                host = addr.substring(0, index);
                port = addr.substring(index + 1);
            }
        }
        if (host == null || host.length() == 0) {
            return null;
        }
        if (port == null && path != null) {
            port = protocol.equals(HTTP_ROOT) ? HTTP_DEFAULT_PORT : HTTPS_DEFAULT_PORT;
        }
        host = DraDestUtil.reverseDSN(host.toLowerCase());
        if (path != null && path.length() != 0) {
            path = path.replace('.', '$');
        }
        if (path != null && path.length() != 0) {
            path = path.replace('/', '.');
        }
        StringBuffer sb = new StringBuffer();
        if (routingPrefix) {
            sb.append(DraDestUtil.getRNNSecSubject(SessionConfig.SONIC_HTTP)).append(".");
        }
        sb.append(protocol);
        sb.append(host);
        if (port != null) {
            sb.append("." + port);
        }
        if (path != null) {
            sb.append(path);
        }
        return sb.toString();
    }

    public static ISubject getRemoteSubject(ISubject subject, String rnn) {
        if (subject.isMultiSubject()) {
            Subject ret = new Subject();
            Iterator<ISubject> components = subject.getMultiSubjects();
            while (components.hasNext()) {
                ISubject component = components.next();
                ret.addSubject(DraDestUtil.getRemoteSubject(component, rnn));
            }
            return ret;
        }
        String subjectName = subject.getLookupName();
        String jmsName = subject.getJMSName();
        subjectName = !subject.isQueue() ? (DraDestUtil.isHttpOrHttps(jmsName) ? DraDestUtil.httpUrlToSecSubject(rnn, jmsName) : DraDestUtil.topicToSecSubject(rnn, jmsName)) : (DraDestUtil.isHttpOrHttps(jmsName) ? DraDestUtil.httpUrlToSecSubject(rnn, jmsName) : DraDestUtil.queueToSecSubject(rnn, jmsName));
        DebugObject.class_debug(DEBUG_NAME, "getRemoteSubject() result is " + subjectName + " for rnn: " + rnn + ", subject : " + jmsName);
        return subjectName != null ? new Subject(subjectName) : null;
    }

    public static String getUrlHostName(String localUrl) {
        if (!DraDestUtil.isHttpOrHttps(localUrl)) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(localUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return url.getHost();
    }

    private static String getDsnForAclEntry(String localUrl) {
        if (!DraDestUtil.isHttpOrHttps(localUrl)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(localUrl, "/\\");
        int count = st.countTokens();
        if (count < 2) {
            return null;
        }
        st.nextToken();
        String dsn = st.nextToken();
        if (dsn.startsWith("[")) {
            int idx = dsn.indexOf("]");
            if (idx == -1) {
                return null;
            }
            dsn = dsn.substring(0, idx + 1);
            return DraDestUtil.getCanonicalIPv6Address(dsn);
        }
        st = new StringTokenizer(dsn, ":?&$");
        return st.nextToken();
    }

    private static String getCanonicalIPv6Address(String ipStr) {
        try {
            InetAddress addr = InetAddress.getByName(ipStr);
            return "[" + addr.getHostAddress() + "]";
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

