/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

public class Lock {
    private Object m_mutex = new Object();
    private Thread m_lockOwner = null;
    int m_lockCount = 0;

    public void lock() {
        try {
            this.lock(false);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lock(boolean interruptable) throws InterruptedException {
        Object object = this.m_mutex;
        synchronized (object) {
            Thread t = Thread.currentThread();
            if (this.m_lockOwner == t) {
                ++this.m_lockCount;
                return;
            }
            boolean interrupted = false;
            while (this.m_lockOwner != null) {
                try {
                    this.m_mutex.wait();
                }
                catch (InterruptedException e) {
                    if (interruptable) {
                        throw new InterruptedException();
                    }
                    interrupted = true;
                }
            }
            this.m_lockOwner = t;
            this.m_lockCount = 1;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        Object object = this.m_mutex;
        synchronized (object) {
            Thread t = Thread.currentThread();
            if (this.m_lockOwner == t) {
                ++this.m_lockCount;
                return true;
            }
            if (this.m_lockOwner != null) {
                return false;
            }
            this.m_lockOwner = t;
            this.m_lockCount = 1;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws IllegalMonitorStateException {
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_lockOwner == Thread.currentThread()) {
                if (--this.m_lockCount == 0) {
                    this.m_lockOwner = null;
                    this.m_mutex.notifyAll();
                }
            } else {
                throw new IllegalMonitorStateException("unlock() without lock()");
            }
        }
    }
}

