/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.server;

import java.io.EOFException;
import progress.message.util.server.IByteBuffer;

public class ByteBuffer
implements IByteBuffer {
    protected byte[] m_data;
    private static final int INITIAL_CAPACITANCE = 256;
    protected int m_initialCap;
    protected int m_capInc;
    protected int m_count;
    protected int m_cRead;
    protected int m_markedReaderIndex;

    public ByteBuffer(int initialCap, int capInc) {
        this.m_initialCap = initialCap;
        this.m_data = new byte[initialCap];
        this.m_capInc = capInc;
        this.m_count = 0;
        this.m_cRead = 0;
    }

    public ByteBuffer(int initialCap) {
        this(initialCap, 0);
    }

    public ByteBuffer(byte[] data) {
        this.m_data = data;
        this.m_capInc = 0;
        this.m_count = data.length;
        this.m_cRead = 0;
        this.m_markedReaderIndex = 0;
    }

    public ByteBuffer() {
        this(256);
    }

    @Override
    public final int count() {
        return this.m_count;
    }

    @Override
    public final int countRead() {
        return this.m_cRead;
    }

    @Override
    public final int countUnread() {
        return this.m_count - this.m_cRead;
    }

    @Override
    public final int cap() {
        return this.m_data.length;
    }

    @Override
    public final int capInc() {
        return this.m_capInc;
    }

    @Override
    public final byte[] buffer() {
        return this.m_data;
    }

    @Override
    public final byte[] data() {
        byte[] data = new byte[this.m_count];
        System.arraycopy(this.m_data, 0, data, 0, this.m_count);
        return data;
    }

    @Override
    public void gotoByte(int offset) throws EOFException {
        if (offset < 0 || offset >= this.cap()) {
            throw new EOFException("" + this.cap());
        }
        this.m_cRead = offset;
    }

    @Override
    public void skipBytes(int amount) throws EOFException {
        if (this.m_cRead + amount <= this.cap() && this.m_cRead + amount >= 0) {
            this.m_cRead += amount;
        } else {
            throw new EOFException("" + this.cap());
        }
    }

    @Override
    public final void write(byte data) {
        this.ensureWrite(1);
        this.m_data[this.m_count++] = data;
    }

    @Override
    public void writeByte(int data) {
        this.ensureWrite(1);
        this.m_data[this.m_count++] = (byte)data;
    }

    @Override
    public final void write(byte[] data) {
        this.write(data, 0, data.length);
    }

    @Override
    public final void read(byte[] data) throws EOFException {
        this.ensureRead(data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.m_data[this.m_cRead++];
        }
    }

    @Override
    public final byte readByte() throws EOFException {
        this.ensureRead(1);
        return this.m_data[this.m_cRead++];
    }

    @Override
    public final void write(char data) {
        this.ensureWrite(2);
        this.m_data[this.m_count++] = (byte)(data >>> 8 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data & 0xFF);
    }

    @Override
    public final void write(char[] data) {
        this.ensureWrite(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            this.m_data[this.m_count++] = (byte)(data[i] >>> 8 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] & 0xFF);
        }
    }

    @Override
    public final void read(char[] data) throws EOFException {
        this.ensureRead(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (char)(this.m_data[this.m_cRead++] << 8 | this.m_data[this.m_cRead++] & 0xFF);
        }
    }

    @Override
    public final char readChar() throws EOFException {
        this.ensureRead(2);
        return (char)(this.m_data[this.m_cRead++] << 8 | this.m_data[this.m_cRead++] & 0xFF);
    }

    @Override
    public final void write(short data) {
        this.ensureWrite(2);
        this.m_data[this.m_count++] = (byte)(data >>> 8 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data & 0xFF);
    }

    @Override
    public final void write(short[] data) {
        this.ensureWrite(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            this.m_data[this.m_count++] = (byte)(data[i] >>> 8 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] & 0xFF);
        }
    }

    @Override
    public final void read(short[] data) throws EOFException {
        this.ensureRead(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            data[i] = (short)(this.m_data[this.m_cRead++] << 8 | this.m_data[this.m_cRead++] & 0xFF);
        }
    }

    @Override
    public final short readShort() throws EOFException {
        this.ensureRead(2);
        return (short)(this.m_data[this.m_cRead++] << 8 | this.m_data[this.m_cRead++] & 0xFF);
    }

    @Override
    public final void writeUnsignedShort(int dataParam) {
        int data = dataParam;
        this.ensureWrite(2);
        this.m_data[this.m_count++] = (byte)((data &= 0xFFFF) >> 8 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data & 0xFF);
    }

    @Override
    public final int readUnsignedShort() throws EOFException {
        this.ensureRead(2);
        return (this.m_data[this.m_cRead++] << 8 | this.m_data[this.m_cRead++] & 0xFF) & 0xFFFF;
    }

    @Override
    public final void write(int data) {
        this.ensureWrite(4);
        this.m_data[this.m_count++] = (byte)(data >>> 24 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data >>> 16 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data >>> 8 & 0xFF);
        this.m_data[this.m_count++] = (byte)(data & 0xFF);
    }

    @Override
    public final void write(int[] data) {
        this.ensureWrite(data.length * 4);
        for (int i = 0; i < data.length; ++i) {
            this.m_data[this.m_count++] = (byte)(data[i] >>> 24 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 16 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 8 & 0xFF);
            this.m_data[this.m_count++] = (byte)(data[i] & 0xFF);
        }
    }

    @Override
    public final void read(int[] data) throws EOFException {
        this.ensureRead(data.length * 4);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.m_data[this.m_cRead++] << 24 | (this.m_data[this.m_cRead++] & 0xFF) << 16 | (this.m_data[this.m_cRead++] & 0xFF) << 8 | this.m_data[this.m_cRead++] & 0xFF;
        }
    }

    @Override
    public final int readInt() throws EOFException {
        this.ensureRead(4);
        return this.m_data[this.m_cRead++] << 24 | (this.m_data[this.m_cRead++] & 0xFF) << 16 | (this.m_data[this.m_cRead++] & 0xFF) << 8 | this.m_data[this.m_cRead++] & 0xFF;
    }

    @Override
    public final void write(long data) {
        this.ensureWrite(8);
        this.m_data[this.m_count++] = (byte)(data >>> 56 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 48 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 40 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 32 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 24 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 16 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data >>> 8 & 0xFFL);
        this.m_data[this.m_count++] = (byte)(data & 0xFFL);
    }

    @Override
    public final void write(long[] data) {
        this.ensureWrite(data.length * 8);
        for (int i = 0; i < data.length; ++i) {
            this.m_data[this.m_count++] = (byte)(data[i] >>> 56 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 48 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 40 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 32 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 24 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 16 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] >>> 8 & 0xFFL);
            this.m_data[this.m_count++] = (byte)(data[i] & 0xFFL);
        }
    }

    @Override
    public final void read(long[] data) throws EOFException {
        this.ensureRead(data.length * 8);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.m_data[this.m_cRead++] << 56 | (this.m_data[this.m_cRead++] & 0xFF) << 48 | (this.m_data[this.m_cRead++] & 0xFF) << 40 | (this.m_data[this.m_cRead++] & 0xFF) << 32 | (this.m_data[this.m_cRead++] & 0xFF) << 24 | (this.m_data[this.m_cRead++] & 0xFF) << 16 | (this.m_data[this.m_cRead++] & 0xFF) << 8 | this.m_data[this.m_cRead++] & 0xFF;
        }
    }

    @Override
    public final long readLong() throws EOFException {
        this.ensureRead(8);
        long temp = ((long)this.m_data[this.m_cRead++] & 0xFFL) << 56 | ((long)this.m_data[this.m_cRead++] & 0xFFL) << 48 | ((long)this.m_data[this.m_cRead++] & 0xFFL) << 40 | ((long)this.m_data[this.m_cRead++] & 0xFFL) << 32 | ((long)this.m_data[this.m_cRead++] & 0xFFL) << 24 | ((long)this.m_data[this.m_cRead++] & 0xFFL) << 16 | ((long)this.m_data[this.m_cRead++] & 0xFFL) << 8 | (long)this.m_data[this.m_cRead++] & 0xFFL;
        return temp;
    }

    @Override
    public final void write(float data) {
        this.write(Float.floatToIntBits(data));
    }

    @Override
    public final void write(float[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.write(data[i]);
        }
    }

    @Override
    public final void read(float[] data) throws EOFException {
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.readFloat();
        }
    }

    @Override
    public final float readFloat() throws EOFException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void write(double data) {
        this.write(Double.doubleToLongBits(data));
    }

    @Override
    public final void write(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.write(data[i]);
        }
    }

    @Override
    public final void read(double[] data) throws EOFException {
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.readDouble();
        }
    }

    @Override
    public final double readDouble() throws EOFException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final void write(String data) {
        int len = data.length();
        this.ensureWrite(len * 2);
        for (int i = 0; i < len; ++i) {
            char ch = data.charAt(i);
            this.m_data[this.m_count++] = (byte)(ch >>> 8 & 0xFF);
            this.m_data[this.m_count++] = (byte)(ch & 0xFF);
        }
    }

    @Override
    public final String readString(int len) throws EOFException {
        this.ensureRead(len * 2);
        char[] charr = new char[len];
        for (int i = 0; i < len; ++i) {
            charr[i] = (char)(this.m_data[this.m_cRead++] << 8 | this.m_data[this.m_cRead++] & 0xFF);
        }
        return new String(charr);
    }

    @Override
    public final void write(boolean data) {
        if (data) {
            this.write((byte)1);
        } else {
            this.write((byte)0);
        }
    }

    @Override
    public final void write(boolean[] data) {
        this.ensureWrite(data.length);
        for (int i = 0; i < data.length; ++i) {
            this.write(data[i]);
        }
    }

    @Override
    public final void read(boolean[] data) throws EOFException {
        this.ensureRead(data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.readBoolean();
        }
    }

    @Override
    public final boolean readBoolean() throws EOFException {
        this.ensureRead(1);
        byte b = this.m_data[this.m_cRead++];
        return b == 1;
    }

    @Override
    public final void merge(IByteBuffer bb) {
        byte[] arrby = new byte[this.countUnread() + bb.countUnread()];
        System.arraycopy(this.m_data, this.m_cRead, arrby, 0, this.countUnread());
        System.arraycopy(bb.buffer(), bb.countRead(), arrby, this.countUnread(), bb.countUnread());
        this.m_data = arrby;
        this.m_count = arrby.length;
        this.m_cRead = 0;
        this.m_markedReaderIndex = 0;
    }

    @Override
    public void clear() {
        this.m_data = new byte[this.m_initialCap];
        this.m_count = 0;
        this.m_cRead = 0;
        this.m_markedReaderIndex = 0;
    }

    @Override
    public final ByteBuffer[] split(int threshold) {
        int count = this.m_count;
        ByteBuffer bbRem = this;
        int cBb = (int)Math.ceil((double)count / (double)threshold);
        ByteBuffer[] arrbb = new ByteBuffer[cBb];
        for (int i = 0; i < cBb; ++i) {
            ByteBuffer bbSub;
            if (count <= threshold) {
                arrbb[i] = bbRem;
                continue;
            }
            byte[] bySub = new byte[threshold];
            System.arraycopy(bbRem.buffer(), 0, bySub, 0, threshold);
            arrbb[i] = bbSub = new ByteBuffer(bySub);
            byte[] byTmp = new byte[count -= threshold];
            System.arraycopy(bbRem.buffer(), threshold, byTmp, 0, count);
            bbRem = new ByteBuffer(byTmp);
        }
        return arrbb;
    }

    public String toString() {
        return "m_data: " + this.m_data + "m_count: " + this.m_count + "m_cRead: " + this.m_cRead;
    }

    protected final void ensureWrite(int len) {
        int curCap = this.m_data.length;
        int reqCap = this.m_count + len;
        if (curCap < reqCap) {
            byte[] curData = this.m_data;
            int newCap = this.m_capInc > 0 ? curCap + this.m_capInc : curCap * 2;
            if (newCap < reqCap) {
                newCap = reqCap;
            }
            this.m_data = new byte[newCap];
            System.arraycopy(curData, 0, this.m_data, 0, this.m_count);
        }
    }

    protected final void ensureRead(int len) throws EOFException {
        if (this.countUnread() < len) {
            throw new EOFException();
        }
    }

    @Override
    public void gotoMarkedRead() throws EOFException {
        this.gotoByte(this.m_markedReaderIndex);
    }

    @Override
    public void markRead() {
        this.m_markedReaderIndex = this.m_cRead;
    }

    @Override
    public void write(byte[] data, int length) {
        this.write(data, 0, length);
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        this.ensureWrite(length);
        for (int i = offset; i < length; ++i) {
            this.m_data[this.m_count++] = data[i];
        }
    }
}

