/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.text.MessageFormat;
import progress.message.util.EAssertFailure;
import progress.message.zclient.IPrioQueueLimiter;
import progress.message.zclient.IQuencher;
import progress.message.zclient.ITimeOnBufferTracker;
import progress.message.zclient.SessionConfig;

public final class PrioQueueLimiter
implements IPrioQueueLimiter {
    public int m_normSize;
    public final int[] m_normStopSize = new int[10];
    public final int[] m_normStartSize = new int[10];
    public int m_hiSize;
    public final int m_hiStopSize;
    public final int m_hiStartSize;
    public int m_minPriority = 0;
    public IQuencher m_quencher;
    private boolean m_sizeError;
    private ITimeOnBufferTracker.IBufferListener m_timeOnBufferListener;

    private PrioQueueLimiter(Builder builder, IQuencher quencher, ITimeOnBufferTracker.IBufferListener timeOnBufferListener) {
        for (int p = 0; p < 10; ++p) {
            this.m_normStopSize[p] = builder.normLimit - (9 - p) * builder.reserved;
            this.m_normStartSize[p] = this.m_normStopSize[p] - builder.restartThreshold;
        }
        this.m_hiStopSize = builder.highLimit;
        this.m_hiStartSize = this.m_hiStopSize - builder.restartThreshold;
        this.m_quencher = quencher;
        this.m_timeOnBufferListener = timeOnBufferListener;
    }

    @Override
    public void add(int size, int priority) {
        this.updateSize(size, priority);
        this.updateMinPriority(size);
    }

    public void updateSize(int size, int priority) {
        this.m_normSize += size;
        if (priority == 10) {
            this.m_hiSize += size;
        }
        if (this.m_normSize < 0 || this.m_hiSize < 0) {
            if (SessionConfig.IN_BROKER) {
                if (!this.m_sizeError) {
                    SessionConfig.logMessage("Negative queue size: " + size + " " + this.m_normStopSize[9], SessionConfig.getLevelWarning());
                    this.m_sizeError = true;
                }
            } else {
                throw new EAssertFailure("negative queue size");
            }
        }
        if (this.m_timeOnBufferListener != null) {
            this.updateBufferListener(size);
        }
    }

    public void updateMinPriority(int size) {
        int newMinPrio;
        if (size > 0) {
            for (newMinPrio = this.m_minPriority; newMinPrio <= 9 && this.m_normStopSize[newMinPrio] <= this.m_normSize; ++newMinPrio) {
            }
            if (newMinPrio == 10 && this.m_hiSize >= this.m_hiStopSize) {
                ++newMinPrio;
            }
        } else {
            if (newMinPrio == 11 && (this.m_hiSize < this.m_hiStartSize || this.m_normSize < this.m_normStartSize[9])) {
                --newMinPrio;
            }
            if (newMinPrio <= 10) {
                while (newMinPrio > 0 && this.m_normStartSize[newMinPrio - 1] > this.m_normSize) {
                    --newMinPrio;
                }
            }
        }
        if (newMinPrio != this.m_minPriority) {
            this.m_minPriority = newMinPrio;
            this.m_quencher.setMinEnqueuePriority(this.m_minPriority);
        }
    }

    public boolean hasRoom(int size, int priority) {
        if (priority == 10) {
            return this.m_hiSize + size <= this.m_hiStopSize || this.m_normSize == 0 || this.m_normSize + size <= this.m_normStopSize[9];
        }
        if (priority <= 9) {
            return this.m_normSize == 0 || this.m_normSize + size <= this.m_normStopSize[priority];
        }
        return true;
    }

    public void reset() {
        this.m_normSize = 0;
        this.m_hiSize = 0;
        if (this.m_minPriority != 0) {
            this.m_minPriority = 0;
            this.m_quencher.setMinEnqueuePriority(this.m_minPriority);
        }
    }

    @Override
    public int size() {
        return this.m_normSize;
    }

    @Override
    public void resetMinPriority(int prior) {
        this.m_minPriority = prior;
    }

    private void updateBufferListener(int size) {
        if (size > 0) {
            if (size == this.m_normSize) {
                this.m_timeOnBufferListener.onNewMessageAtHead();
            }
        } else if (this.m_normSize <= 0) {
            this.m_timeOnBufferListener.onEmpty();
        } else {
            this.m_timeOnBufferListener.onNewMessageAtHead();
        }
    }

    public static class Builder {
        static final int MIN_RESTART_THRESHOLD = 500;
        static final int MIN_RESERVED_MULTIPLIER = 2;
        static final int MIN_HIGH_LIMIT_MULTIPLIER = 2;
        static final int MIN_NORM_LIMIT_MULTIPLIER = 15;
        static final String PARAMETER_CHANGED_PATTERN = "{0} too small: {1}.  Increasing to {2}.";
        protected int restartThreshold;
        protected int reserved;
        protected int highLimit;
        protected int normLimit;
        protected Callback cb;

        public Builder() {
            this(new Callback(){

                @Override
                public void restartThresholdChanged(int old, int current) {
                    Builder.logParameterChange("restartThreshold", old, current);
                }

                @Override
                public void reservedChanged(int old, int current) {
                    Builder.logParameterChange("reserved", old, current);
                }

                @Override
                public void highLimitChanged(int old, int current) {
                    Builder.logParameterChange("highLimit", old, current);
                }

                @Override
                public void normLimitChanged(int old, int current) {
                    Builder.logParameterChange("normLimit", old, current);
                }
            });
        }

        public Builder(Callback cb) {
            this.cb = cb;
        }

        public Builder normLimit(int value) {
            this.normLimit = value;
            return this;
        }

        public Builder reserved(int value) {
            this.reserved = value;
            return this;
        }

        public Builder highLimit(int value) {
            this.highLimit = value;
            return this;
        }

        public Builder restartThreshold(int value) {
            this.restartThreshold = value;
            return this;
        }

        public PrioQueueLimiter build(IQuencher quencher, ITimeOnBufferTracker.IBufferListener timeOnQueueListener) {
            this.adjustParameters();
            return new PrioQueueLimiter(this, quencher, timeOnQueueListener);
        }

        public PrioQueueLimiter build(IQuencher quencher) {
            return this.build(quencher, null);
        }

        public int getNormLimit() {
            return this.normLimit;
        }

        public int getReserved() {
            return this.reserved;
        }

        public int getHighLimit() {
            return this.highLimit;
        }

        public int getRestartThreshold() {
            return this.restartThreshold;
        }

        private void adjustParameters() {
            this.adjustRestartThreshold();
            this.adjustReserved();
            this.adjustHighLimit();
            this.adjustNormLimit();
        }

        private void adjustRestartThreshold() {
            if (this.restartThreshold <= 0) {
                this.restartThreshold = 500;
            } else if (this.restartThreshold < 500) {
                int old = this.restartThreshold;
                this.restartThreshold = 500;
                this.cb.restartThresholdChanged(old, this.restartThreshold);
            }
        }

        private void adjustReserved() {
            if (this.reserved <= 0) {
                this.reserved = this.restartThreshold * 2;
            } else if (this.reserved < this.restartThreshold * 2) {
                int old = this.reserved;
                this.reserved = this.restartThreshold * 2;
                this.cb.reservedChanged(old, this.reserved);
            }
        }

        private void adjustHighLimit() {
            if (this.highLimit <= 0) {
                this.highLimit = this.reserved * 2;
            } else if (this.highLimit < this.reserved * 2) {
                int old = this.highLimit;
                this.highLimit = this.reserved * 2;
                this.cb.highLimitChanged(old, this.highLimit);
            }
        }

        private void adjustNormLimit() {
            if (this.normLimit <= 0) {
                this.normLimit = this.reserved * 15;
            } else if (this.normLimit < this.reserved * 15) {
                int old = this.normLimit;
                this.normLimit = this.reserved * 15;
                this.cb.normLimitChanged(old, this.normLimit);
            }
        }

        private static void logParameterChange(String name, int old, int current) {
            SessionConfig.logMessage(MessageFormat.format(PARAMETER_CHANGED_PATTERN, name, new Integer(old), new Integer(current)), SessionConfig.getLevelWarning());
        }

        public static interface Callback {
            public void normLimitChanged(int var1, int var2);

            public void reservedChanged(int var1, int var2);

            public void highLimitChanged(int var1, int var2);

            public void restartThresholdChanged(int var1, int var2);
        }
    }
}

