/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mq.common.runtime.IDestination;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import progress.message.util.StreamUtil;

public class Destination
implements IDestination {
    private static final short CURRENT_VERSION = 1;
    static final long serialVersionUID = 838732755250444110L;
    private String m_destination;
    private transient byte[] m_subject;
    private transient String m_routing;
    private transient short m_version = 1;

    public Destination(String name) {
        this.m_destination = name;
        this.m_version = 0;
    }

    public Destination(String routing, byte[] subject) {
        this.m_subject = subject;
        this.m_routing = routing;
    }

    public String getDestination() {
        return this.m_destination;
    }

    public byte[] getSubject() {
        return this.m_subject;
    }

    public String getRouting() {
        return this.m_routing;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(this.m_version);
        if (this.m_version <= 0) {
            stream.writeUTF(this.m_destination);
        } else {
            if (this.m_routing != null) {
                stream.writeBoolean(true);
                stream.writeUTF(this.m_routing);
            } else {
                stream.writeBoolean(false);
            }
            stream.writeInt(this.m_subject.length);
            stream.write(this.m_subject);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.m_version = stream.readShort();
        if (this.m_version <= 0) {
            this.m_destination = stream.readUTF();
        } else {
            boolean routing = stream.readBoolean();
            if (routing) {
                this.m_routing = stream.readUTF();
            }
            this.m_subject = new byte[stream.readInt()];
            StreamUtil.readBytes(stream, this.m_subject, 0, this.m_subject.length);
            this.m_destination = null;
        }
    }
}

